// CDlgConfigureMonitor.cpp : implementation file
//

#include "arch/frame/stdafx.h"
#include "arch/frame/aipc.h"
#include "arch/frame/dlgconfiguremonitor.h"

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

/////////////////////////////////////////////////////////////////////////////
// CDlgConfigureMonitor dialog


CDlgConfigureMonitor::CDlgConfigureMonitor(CWnd* pParent /*=NULL*/, CScreen* pScreen)
	: CDialog(CDlgConfigureMonitor::IDD, pParent)
{
	//{{AFX_DATA_INIT(CDlgConfigureMonitor)
		// NOTE: the ClassWizard will add member initialization here
	//}}AFX_DATA_INIT
	m_pScreen = pScreen;
	m_iHue = 350;
	m_bSaturation = 50;
	m_bBright = 50;
}


void CDlgConfigureMonitor::DoDataExchange(CDataExchange* pDX)
{
	CDialog::DoDataExchange(pDX);
	//{{AFX_DATA_MAP(CDlgConfigureMonitor)
	DDX_Control(pDX, IDC_EDIT_SATURATION, m_edSaturation);
	DDX_Control(pDX, IDC_EDIT_HUE, m_edHue);
	DDX_Control(pDX, IDC_EDIT_BRIGHTNESS, m_edBrightness);
	DDX_Control(pDX, IDC_SLIDER_SATURATION, m_sdSaturation);
	DDX_Control(pDX, IDC_SLIDER_BRIGHTNESS, m_sdBrightness);
	DDX_Control(pDX, IDC_SLIDER_HUE, m_sdHue);
	//}}AFX_DATA_MAP
}


BEGIN_MESSAGE_MAP(CDlgConfigureMonitor, CDialog)
	//{{AFX_MSG_MAP(CDlgConfigureMonitor)
	ON_NOTIFY(NM_CUSTOMDRAW, IDC_SLIDER_HUE, OnCustomdraw)
	ON_EN_CHANGE(IDC_EDIT_BRIGHTNESS, OnChangeEditBrightness)
	ON_EN_CHANGE(IDC_EDIT_HUE, OnChangeEditHue)
	ON_EN_CHANGE(IDC_EDIT_SATURATION, OnChangeEditSaturation)
	ON_EN_UPDATE(IDC_EDIT_HUE, OnUpdateEditHue)
	ON_EN_UPDATE(IDC_EDIT_BRIGHTNESS, OnUpdateEditBrightness)
	ON_EN_UPDATE(IDC_EDIT_SATURATION, OnUpdateEditSaturation)
	ON_NOTIFY(NM_CUSTOMDRAW, IDC_SLIDER_SATURATION, OnCustomdraw)
	ON_NOTIFY(NM_CUSTOMDRAW, IDC_SLIDER_BRIGHTNESS, OnCustomdraw)
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// CDlgConfigureMonitor message handlers


BOOL CDlgConfigureMonitor::OnInitDialog() 
{
	CDialog::OnInitDialog();
	
	// TODO: Add extra initialization here
	m_sdHue.SetRange(0, 359, TRUE);
	m_sdSaturation.SetRange(0, 100);
	m_sdBrightness.SetRange(0, 100);

	m_sdHue.SetPageSize(2);
	m_sdHue.SetLineSize(360);
	m_sdSaturation.SetPageSize(2);
	m_sdSaturation.SetLineSize(101);
	m_sdBrightness.SetPageSize(2);
	m_sdBrightness.SetLineSize(101);

	char temp[5];
	itoa(m_iHue, temp, 10);
	m_edHue.SetWindowText(temp);
	itoa(m_bSaturation, temp, 10);
	m_edSaturation.SetWindowText(temp);
	itoa(m_bBright, temp, 10);
	m_edBrightness.SetWindowText(temp);
	AdjustSlider();
	return TRUE;  // return TRUE unless you set the focus to a control
	              // EXCEPTION: OCX Property Pages should return FALSE
}



void CDlgConfigureMonitor::OnCustomdraw(NMHDR* pNMHDR, LRESULT* pResult) 
{
	// TODO: Add your control notification handler code here
	int i;
	BYTE b;
	char tmp[5];
	i = m_sdHue.GetPos()-180;
	if(m_iHue!=i){
		m_iHue=i;
		itoa(m_iHue, tmp, 10);
		m_edHue.SetWindowText(tmp);
	}
	b = m_sdSaturation.GetPos();
	if(m_bSaturation!=b){
		m_bSaturation=b;
		itoa(m_bSaturation, tmp, 10);
		m_edSaturation.SetWindowText(tmp);
	}
	b = m_sdBrightness.GetPos();
	if(m_bBright!=b){
		m_bBright=b;
		itoa(m_bBright, tmp, 10);
		m_edBrightness.SetWindowText(tmp);
	}

	if(m_pScreen!=NULL)
		m_pScreen->SetHSB((m_iHue+360)%360, m_bSaturation*255/100, m_bBright*255/100);


	*pResult = 0;
}

void CDlgConfigureMonitor::SetHSB(unsigned int HSB)
{
	m_iHue = ((HSB>>16)+180)%360-180;
	m_bSaturation = ((HSB>>8)&0xFF)*100/255;
	m_bBright = (HSB&0xFF)*100/255;
	m_iHSBOrigin = HSB;
}

void CDlgConfigureMonitor::AdjustSlider()
{
	m_sdHue.SetPos((m_iHue+180)%360);
	m_sdSaturation.SetPos(m_bSaturation);
	m_sdBrightness.SetPos(m_bBright);
}

void CDlgConfigureMonitor::OnChangeEditBrightness() 
{
	// TODO: If this is a RICHEDIT control, the control will not
	// send this notification unless you override the CDialog::OnInitDialog()
	// function and call CRichEditCtrl().SetEventMask()
	// with the ENM_CHANGE flag ORed into the mask.
	
	// TODO: Add your control notification handler code here
}

void CDlgConfigureMonitor::OnChangeEditHue() 
{
	// TODO: If this is a RICHEDIT control, the control will not
	// send this notification unless you override the CDialog::OnInitDialog()
	// function and call CRichEditCtrl().SetEventMask()
	// with the ENM_CHANGE flag ORed into the mask.
	
	// TODO: Add your control notification handler code here
	
}

void CDlgConfigureMonitor::OnChangeEditSaturation() 
{
	// TODO: If this is a RICHEDIT control, the control will not
	// send this notification unless you override the CDialog::OnInitDialog()
	// function and call CRichEditCtrl().SetEventMask()
	// with the ENM_CHANGE flag ORed into the mask.
	
	// TODO: Add your control notification handler code here

}

void CDlgConfigureMonitor::OnUpdateEditHue() 
{
	// TODO: If this is a RICHEDIT control, the control will not
	// send this notification unless you override the CDialog::OnInitDialog()
	// function to send the EM_SETEVENTMASK message to the control
	// with the ENM_UPDATE flag ORed into the lParam mask.
	
	// TODO: Add your control notification handler code here
	
	CString str;
	m_edHue.GetWindowText(str);
	int i = atoi(str);
	if(m_iHue==i) return;
	if(i<-180 || i>=180){
		i = (i+180)%360-180;
		char tmp[5];
		itoa(i, tmp, 10);
		m_iHue = i;
		m_edHue.SetWindowText(tmp);
		m_edHue.SetSel(0, m_edHue.GetWindowTextLength());
	}
	else
		m_iHue = i;
	AdjustSlider();
}

void CDlgConfigureMonitor::OnUpdateEditBrightness() 
{
	// TODO: If this is a RICHEDIT control, the control will not
	// send this notification unless you override the CDialog::OnInitDialog()
	// function to send the EM_SETEVENTMASK message to the control
	// with the ENM_UPDATE flag ORed into the lParam mask.
	
	// TODO: Add your control notification handler code here
	
	CString str;
	char temp[5];

	m_edBrightness.GetWindowText(str);
	int i = atoi(str);

	if(i==m_bBright)
		return;

	if(i>100){
		m_bBright=100;
		itoa(m_bBright, temp, 10);
		m_edBrightness.SetWindowText(temp);
		m_edBrightness.SetSel(0, 3);
	}
	else if(i<0){
		m_bBright=0;
		itoa(m_bBright, temp, 10);
		m_edBrightness.SetWindowText(temp);
		m_edBrightness.SetSel(0, 1);
	}
	else
		m_bBright = i;
	AdjustSlider();
}

void CDlgConfigureMonitor::OnUpdateEditSaturation() 
{
	// TODO: If this is a RICHEDIT control, the control will not
	// send this notification unless you override the CDialog::OnInitDialog()
	// function to send the EM_SETEVENTMASK message to the control
	// with the ENM_UPDATE flag ORed into the lParam mask.
	
	// TODO: Add your control notification handler code here
	CString str;
	char temp[5];

	m_edSaturation.GetWindowText(str);
	int i = atoi(str);

	if(i==m_bSaturation)
		return;

	if(i>100){
		m_bSaturation=100;
		itoa(m_bSaturation, temp, 10);
		m_edSaturation.SetWindowText(temp);
		m_edSaturation.SetSel(0, 3);
	}
	else if(i<0){
		m_bSaturation=0;
		itoa(m_bSaturation, temp, 10);
		m_edSaturation.SetWindowText(temp);
		m_edSaturation.SetSel(0, 1);
	}
	else
		m_bSaturation = (BYTE)i;
	AdjustSlider();
	
}

void CDlgConfigureMonitor::OnCancel() 
{
	// TODO: Add extra cleanup here

	if(m_pScreen!=NULL){
		m_pScreen->SetHSB(m_iHSBOrigin>>16, (m_iHSBOrigin>>8)&0xFF, m_iHSBOrigin&0xFF);
	}
	CDialog::OnCancel();
}
