<?php rcs_id('$Id: interwiki.php,v 1.1 2003/05/08 04:17:36 gryu Exp $');

function generate_interwikimap_and_regexp()
{
	global $dbi, $interwikimap_file, $InterWikiLinkRegexp, $interwikimap;
//	$intermap_data = file(INTERWIKI_MAP_FILE, 1);
	$intermap_page = $dbi->getPage('InterWikiMap');
	$intermap_revision = $intermap_page->getCurrentRevision();
	$intermap_data = $intermap_revision->getContent();

	$wikiname_regexp = "";
	$i = 0;
	
	for	($i=0; $i<count($intermap_data); $i++)
	{
		if(preg_match("/^\*([A-z0-9]+) (.+)$/i", 
		chop($intermap_data[$i]), $matches)) {
			$wiki = $matches[1];
			$inter_url = $matches[2];
			$interwikimap[$wiki] = $inter_url;
			if ($wikiname_regexp)
				$wikiname_regexp .=	"|";
			$wikiname_regexp .=	$wiki;
		}
	}
		
	$InterWikiLinkRegexp = "($wikiname_regexp)";

}

generate_interwikimap_and_regexp();	

function LinkInterWikiLink($link, $linktext='')
{
	global $interwikimap;

	list( $wiki, $page ) = split( ":", $link, 2	);

	$url = $interwikimap[$wiki];

	// Urlencode page only if it's a query arg.
//gryu-	if (strstr($url, '?'))
		$url .=	rawurlencode($page);
//gryu-	else
//gryu-		$url .=	$page;

	if ($linktext) {
		$linktext =	htmlspecialchars($linktext);
		$class = 'named-interwiki';
	}
	else {
		$linktext =	( htmlspecialchars("$wiki:")
					  .	QElement('span', array('class' => 'wikipage'), $page) );
		$class = 'interwiki';
	}

	return Element('a',	array('href' =>	$url,
							  'class' => $class),
				   $linktext);
}

// Link	InterWiki links
// These can be	protected by a '!' like	Wiki words.
function wtt_interwikilinks($match,	&$trfrm)
{
	if ($match[0] == "!")
		return htmlspecialchars(substr($match,1));
	return LinkInterWikiLink($match);
}

// For emacs users
// Local Variables:
// mode: php
// tab-width: 8
// c-basic-offset: 4
// c-hanging-comment-ender-p: nil
// indent-tabs-mode: nil
// End:

?>
