<?php // -*-php-*-
rcs_id('$Id: WordIndex.php,v 1.2 2003/06/11 07:20:26 gryu Exp $');

require_once('lib/TextSearchQuery.php');

/**
 */
class WikiPlugin_WordIndex
extends WikiPlugin
{
	var $name = 'WordIndex';
	
	function getDefaultArguments() {
		// FIXME: how to exclude multiple pages?
		return array();
	}

	function run($dbi, $argstr, $request) 
	{
		$page_tbl = $dbi->_backend->_table_names['page_tbl'];
		$nonempty_tbl = $dbi->_backend->_table_names['nonempty_tbl'];
		setlocale(LC_CTYPE, 'C');	
		$sql = "SELECT pagename 
FROM $page_tbl as p, $nonempty_tbl as n
WHERE p.id = n.id
ORDER BY pagename ASC";
		if(!$f_res = mysql_query($sql) )
		{
				echo "$f_res \n";
				echo $sql;
				die("Error getting data<br>$sql");
		}
		
		while($row = mysql_fetch_assoc($f_res))
		{
			$pagenames[] = $row;
		}
		
		$wordindex = array();
		foreach( $pagenames as $p)
		{
			$pagename = trim($p['pagename']);
			$origname = $pagename;
			$pagename = preg_replace("/([\:\_\.\-\(\)\,\&\?\!])/", " ", $pagename);
			$pagename = preg_replace("/([[:alpha:]])([\x80-\xff])/", "\\1 \\2", $pagename);
			$pagename = preg_replace("/([[:lower:]])([[:upper:]])/", "\\1 \\2",$pagename);
			$pagename = preg_replace("/([[:upper:]])([[:upper:]][[:lower:]])/", "\\1 \\2", $pagename); 
			$words = explode(' ', $pagename);
			foreach ($words as $word)
			{
				$word = trim($word);
				if ($word == '') continue;
				$wordindex[$word][] = $origname;
			}
		}
		
		function case_insensitive_cmp ($a, $b) {
		    if ($a == $b ) return 0;
		    return (strtolower($a) < strtolower($b) ) ? -1 : 1;
		}
		
		uksort($wordindex, "case_insensitive_cmp");
		$html = '<a name="#top"></a>{:index:}';
		$korean_index = array( '', '', '', '', '', '', '', '', '', '', 'ī', 'Ÿ', '', '', 0xFFFF);
		$idx = '';
		$previdx = '';
		$indexnum = 0;
		$indexhtml = '';
		foreach( $wordindex as $word => $pages)
		{
			$idx = strtoupper( substr($word, 0, 1) );
			$i = 0;
			if (ord($idx) > 127) 
			{
				$idx = substr($word, 0, 2);

				for ($i = 0; $i < count($korean_index) ; $i++)
				{
					if ( ($idx >= $korean_index[$i])  and  ($idx < $korean_index[$i+1]) ) 
					{
						$idx = $korean_index[$i];
						break;
					}
				}
				if (ord(substr($idx, 0, 1) ) > 216  ) $idx = 'Ÿ';
			}
			if (ord($idx) < ord('A') ) $idx = '';
			
			if ($idx <> $previdx)
			{
				$indexnum += 1;
				$html .=  '<a name="'.$indexnum.'">&nbsp;</a><a href="#pagetop"><h2>' . $idx . '</h2></a></center>';
				$indexhtml .= '<a href="#'. $indexnum .'">'. $idx .'</a> | ';
			}
			$previdx = $idx;
			$html .=  '<h4>' . $word . ' ('. count($pages) . ")</h4>\n";
			$html .=  '<p>';
			foreach($pages as $val)
			{
				$html .=  LinkWikiWord($val) . '<br/>';
			}
			$html .=  '</p>';
		}

		$html =  str_replace('{:index:}', $indexhtml, $html);

		return $html;
	}

	function _quote($str) {
		return "'" . str_replace("'", "''", $str) . "'";
	}
};
		
// Local Variables:
// mode: php
// tab-width: 8
// c-basic-offset: 4
// c-hanging-comment-ender-p: nil
// indent-tabs-mode: nil
// End:   
?>
