/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fop.pdf;

import java.io.IOException;
import java.io.OutputStream;
import org.apache.commons.io.output.CountingOutputStream;
import org.apache.fop.pdf.PDFFilterList;
import org.apache.fop.pdf.PDFNumber;
import org.apache.fop.pdf.PDFObject;
import org.apache.fop.pdf.StreamCache;
import org.apache.fop.pdf.StreamCacheFactory;
import org.apache.fop.util.CloseBlockerOutputStream;

public abstract class AbstractPDFStream
extends PDFObject {
    private PDFFilterList filters;

    protected String buildStreamDict(String lengthEntry) {
        String filterEntry = this.getFilterList().buildFilterDictEntries();
        return String.valueOf(this.getObjectID()) + "<< /Length " + lengthEntry + "\n" + filterEntry + "\n>>\n";
    }

    protected int encodeAndWriteStream(OutputStream out, PDFNumber refLength) throws IOException {
        int bytesWritten = 0;
        byte[] buf = PDFObject.encode("stream\n");
        out.write(buf);
        bytesWritten += buf.length;
        CloseBlockerOutputStream cbout = new CloseBlockerOutputStream(out);
        CountingOutputStream cout = new CountingOutputStream(cbout);
        OutputStream filteredOutput = this.getFilterList().applyFilters(cout);
        this.outputRawStreamData(filteredOutput);
        filteredOutput.close();
        refLength.setNumber(new Integer(cout.getCount()));
        bytesWritten += cout.getCount();
        buf = PDFObject.encode("\nendstream");
        out.write(buf);
        return bytesWritten += buf.length;
    }

    protected StreamCache encodeStream() throws IOException {
        StreamCache encodedStream = StreamCacheFactory.getInstance().createStreamCache(this.getSizeHint());
        OutputStream filteredOutput = this.getFilterList().applyFilters(encodedStream.getOutputStream());
        this.outputRawStreamData(filteredOutput);
        filteredOutput.flush();
        filteredOutput.close();
        return encodedStream;
    }

    public PDFFilterList getFilterList() {
        if (this.filters == null) {
            this.filters = this.getDocument() == null ? new PDFFilterList() : new PDFFilterList(this.getDocument().isEncryptionActive());
        }
        return this.filters;
    }

    protected abstract int getSizeHint() throws IOException;

    protected int output(OutputStream stream) throws IOException {
        String lengthEntry;
        int length = 0;
        this.setupFilterList();
        StreamCache encodedStream = null;
        PDFNumber refLength = null;
        if (this.getDocument().isEncodingOnTheFly()) {
            refLength = new PDFNumber();
            this.getDocumentSafely().registerObject(refLength);
            lengthEntry = refLength.referencePDF();
        } else {
            encodedStream = this.encodeStream();
            lengthEntry = Integer.toString(encodedStream.getSize() + 1);
        }
        String filterEntry = this.getFilterList().buildFilterDictEntries();
        byte[] p = PDFObject.encode(this.buildStreamDict(lengthEntry));
        stream.write(p);
        length += p.length;
        if (encodedStream == null) {
            int bytesWritten = this.encodeAndWriteStream(stream, refLength);
            length += bytesWritten;
        } else {
            length += this.outputStreamData(encodedStream, stream);
            encodedStream.clear();
        }
        p = PDFObject.encode("\nendobj\n");
        stream.write(p);
        return length += p.length;
    }

    protected abstract void outputRawStreamData(OutputStream var1) throws IOException;

    protected int outputStreamData(StreamCache encodedStream, OutputStream out) throws IOException {
        int length = 0;
        byte[] p = PDFObject.encode("stream\n");
        out.write(p);
        length += p.length;
        encodedStream.outputContents(out);
        length += encodedStream.getSize();
        p = PDFObject.encode("\nendstream");
        out.write(p);
        return length += p.length;
    }

    protected void prepareImplicitFilters() {
    }

    protected void setupFilterList() {
        if (!this.getFilterList().isInitialized()) {
            this.getFilterList().addDefaultFilters(this.getDocumentSafely().getFilterMap(), "default");
        }
        this.prepareImplicitFilters();
        this.getDocument().applyEncryption(this);
    }
}

