/*
 * Decompiled with CFR 0.152.
 */
package imhotepc.transcoder.dxf.tosvg;

import com.ysystems.ycad.lib.yxxf.YxxfEntText;
import com.ysystems.ycad.lib.yxxf._YxxfEntHeader;
import com.ysystems.ycad.lib.yxxf._YxxfEntHeaderRendererListener;
import java.awt.Color;
import java.awt.Shape;
import java.awt.geom.GeneralPath;
import java.awt.geom.PathIterator;
import java.awt.geom.Rectangle2D;
import java.io.Writer;
import org.apache.batik.ext.awt.g2d.AbstractGraphics2D;
import org.apache.batik.svggen.SVGGraphics2D;
import org.apache.batik.svggen.SVGGraphics2DIOException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class DXFGraphics2D
extends SVGGraphics2D
implements _YxxfEntHeaderRendererListener {
    private Document doc;
    private boolean finished = true;
    private GeneralPath shapePath;
    private GeneralPath textPath;
    private Element layer;
    int i = 0;
    int j = 0;
    public String UNICODE_HEAD = "&#x";
    public String UNICODE_TAIL = ";";

    public DXFGraphics2D(Document doc) {
        super(doc);
        this.doc = doc;
    }

    public void stream(Writer writer, boolean useCss) throws SVGGraphics2DIOException {
        Element svgRoot = this.doc.getDocumentElement();
        super.stream(svgRoot, writer, useCss);
    }

    public void setClip(int x, int y, int w, int h) {
        this.doc.getDocumentElement().setAttributeNS(null, "width", "" + w);
        this.doc.getDocumentElement().setAttributeNS(null, "height", "" + h);
        this.doc.getDocumentElement().setAttributeNS(null, "viewBox", "0 0 " + w + " " + h);
    }

    public void fillRect(int x, int y, int w, int h) {
        String cW = this.doc.getDocumentElement().getAttributeNS(null, "width");
        String cH = this.doc.getDocumentElement().getAttributeNS(null, "height");
        String dW = new Integer(w).toString();
        String dH = new Integer(h).toString();
        if (cW.equalsIgnoreCase(dW) && cH.equalsIgnoreCase(dH)) {
            this.finished = false;
        } else {
            super.fillRect(x, y, w, h);
        }
    }

    public void fill(Shape s) {
        GeneralPath path = this.getWorkingPath();
        if (path == null) {
            return;
        }
        path.append(s, false);
    }

    public void draw(Shape s) {
        GeneralPath path = this.getWorkingPath();
        if (path == null) {
            return;
        }
        path.append(s, false);
    }

    private GeneralPath getWorkingPath() {
        if (this.textPath != null) {
            return this.textPath;
        }
        if (this.shapePath != null) {
            return this.shapePath;
        }
        return null;
    }

    public void entityRenderingStarted(_YxxfEntHeader ent) {
        if (this.finished) {
            return;
        }
        if (ent instanceof YxxfEntText) {
            this.textPath = new GeneralPath();
        } else {
            this.shapePath = new GeneralPath();
        }
    }

    public void entityRenderingCompleted(_YxxfEntHeader ent) {
        if (this.finished) {
            return;
        }
        this.drawLayerEntity(this.getEntityLayer(ent));
        if (ent instanceof YxxfEntText) {
            if (this.textPath != null) {
                this.drawTextEntity(this.textPath, this.getEntityText(ent));
            }
            this.textPath = null;
        } else {
            if (this.shapePath != null) {
                this.drawShapeEntity(this.shapePath);
            }
            this.shapePath = null;
        }
    }

    private boolean isTextEntity(_YxxfEntHeader ent) {
        return ent instanceof YxxfEntText;
    }

    private String getEntityText(_YxxfEntHeader ent) {
        String text = ((YxxfEntText)ent).text;
        return text;
    }

    private String getEntityLayer(_YxxfEntHeader ent) {
        return ent.hdr_layer.getName();
    }

    private void drawLayerEntity(String layerName) {
        this.layer = this.doc.getElementById(layerName);
        if (this.layer == null) {
            this.layer = this.createSVGSVGElement(layerName);
            this.doc.getDocumentElement().appendChild(this.layer);
        }
    }

    private void drawTextEntity(Shape shape, String text) {
        Element ele = this.createSVGTextElement(shape, text);
        if (ele != null) {
            this.layer.appendChild(ele);
        }
    }

    private void drawShapeEntity(Shape shape) {
        Element ele = this.createSVGPathElement(shape);
        if (ele != null) {
            this.layer.appendChild(ele);
        }
    }

    private Element createSVGSVGElement(String id) {
        Element layer = this.doc.createElement("svg");
        layer.setAttribute("id", id);
        return layer;
    }

    private Element createSVGPathElement(Shape shape) {
        String d = this.getDValue(shape);
        String c = this.getColorValue();
        if ("".equals(d)) {
            return null;
        }
        Element ele = this.doc.createElement("path");
        ele.setAttribute("d", d);
        ele.setAttribute("style", "fill:none;stroke:" + c);
        return ele;
    }

    private Element createSVGRectElement(Shape shape) {
        Rectangle2D rext = shape.getBounds2D();
        String x = "" + rext.getX();
        String y = "" + rext.getY();
        String w = "" + rext.getWidth();
        String h = "" + rext.getHeight();
        String c = this.getColorValue();
        Element ele = this.doc.createElement("rect");
        ele.setAttribute("x", x);
        ele.setAttribute("y", y);
        ele.setAttribute("width", w);
        ele.setAttribute("height", h);
        ele.setAttribute("style", "fill:none;stroke:" + c + ";stroke-width:0.1;");
        return ele;
    }

    private Element createSVGTextElement(Shape shape, String text) {
        String prettyText = this.getTextValue(text);
        if ("".equals(prettyText.trim())) {
            return null;
        }
        System.out.println("createSVGTextElement :" + prettyText + ": " + this.i++);
        Rectangle2D rect = shape.getBounds2D();
        String x = "" + rect.getMinX();
        String y = "" + rect.getMaxY();
        String c = this.getColorValue();
        String s = "" + rect.getHeight() * 1.3;
        Element ele = this.doc.createElement("text");
        ele.setAttribute("x", x);
        ele.setAttribute("y", y);
        ele.setAttribute("style", "fill:" + c + ";stroke:none;font-size:" + s);
        ele.appendChild(this.doc.createTextNode(prettyText));
        return ele;
    }

    private String getTextValue(String t) {
        String prretty = null;
        int indexOfF = t.indexOf(70);
        int indexOfA = t.indexOf(65);
        int indexOfS = t.indexOf(59);
        prretty = indexOfF != -1 && indexOfS != -1 ? t.substring(indexOfS + 1, t.length() - 1) : (indexOfA != -1 && indexOfS != -1 ? t.substring(indexOfS + 1, t.length()) : t);
        return prretty;
    }

    private String getDValue(Shape s) {
        return this.toSVGPathData(s.getPathIterator(null));
    }

    private String getColorValue() {
        Color color = ((AbstractGraphics2D)((Object)this)).getColor().equals(Color.WHITE) ? Color.BLACK : ((AbstractGraphics2D)((Object)this)).getColor();
        String colorText = this.toSVGColor(color);
        return colorText;
    }

    public String unicode(String txt) {
        try {
            StringBuffer b = new StringBuffer();
            char[] chars = txt.toCharArray();
            int length = chars.length;
            int i = 0;
            while (i < length) {
                b.append(this.UNICODE_HEAD);
                b.append(Integer.toHexString(chars[i]));
                b.append(this.UNICODE_TAIL);
                ++i;
            }
            return b.toString();
        }
        catch (Exception e) {
            return txt;
        }
    }

    public String toSVGPathData(PathIterator pi) {
        StringBuffer d = new StringBuffer("");
        float[] seg = new float[6];
        int segType = 0;
        while (!pi.isDone()) {
            segType = pi.currentSegment(seg);
            switch (segType) {
                case 0: {
                    d.append("M");
                    this.appendPoint(d, seg[0], seg[1]);
                    break;
                }
                case 1: {
                    d.append("L");
                    this.appendPoint(d, seg[0], seg[1]);
                    break;
                }
                case 4: {
                    d.append("Z");
                    break;
                }
                case 2: {
                    d.append("Q");
                    this.appendPoint(d, seg[0], seg[1]);
                    this.appendPoint(d, seg[2], seg[3]);
                    break;
                }
                case 3: {
                    d.append("C");
                    this.appendPoint(d, seg[0], seg[1]);
                    this.appendPoint(d, seg[2], seg[3]);
                    this.appendPoint(d, seg[4], seg[5]);
                    break;
                }
                default: {
                    throw new Error();
                }
            }
            pi.next();
        }
        if (d.length() > 0) {
            return d.toString().trim();
        }
        return "";
    }

    private void appendPoint(StringBuffer d, float x, float y) {
        d.append(x);
        d.append(" ");
        d.append(y);
        d.append(" ");
    }

    public String toSVGColor(Color c) {
        StringBuffer b = new StringBuffer();
        b.append("rgb(");
        b.append(c.getRed());
        b.append(",");
        b.append(c.getGreen());
        b.append(",");
        b.append(c.getBlue());
        b.append(")");
        return b.toString();
    }
}

