/*
 * Decompiled with CFR 0.152.
 */
package imhotepc.transcoder.image.tosvg;

import imhotepc.transcoder.AbstractToSVGTranscoder;
import java.awt.Image;
import java.awt.geom.AffineTransform;
import java.awt.image.BufferedImage;
import java.io.IOException;
import javax.imageio.ImageIO;
import org.apache.batik.svggen.SVGGraphics2D;
import org.apache.batik.transcoder.TranscoderException;
import org.apache.batik.transcoder.TranscoderInput;
import org.apache.batik.transcoder.TranscoderSupport;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class ImageTranscoder
extends AbstractToSVGTranscoder {
    protected SVGGraphics2D createSVGGraphics2D(Document doc) {
        return new SVGGraphics2D(doc);
    }

    protected Element readInputToSVG(SVGGraphics2D svgGenerator, Document svgDocument, TranscoderInput input) throws TranscoderException {
        try {
            BufferedImage image = ImageIO.read(input.getInputStream());
            int imageWidth = image.getWidth();
            int imageHeight = image.getHeight();
            Float widthHint = (Float)((TranscoderSupport)this).hints.get((Object)AbstractToSVGTranscoder.KEY_WIDTH);
            Float heightHint = (Float)((TranscoderSupport)this).hints.get((Object)AbstractToSVGTranscoder.KEY_HEIGHT);
            if (widthHint.floatValue() == Float.MAX_VALUE || heightHint.floatValue() == Float.MAX_VALUE) {
                widthHint = new Float(imageWidth);
                heightHint = new Float(imageHeight);
            }
            double sx = widthHint.doubleValue() / (double)imageWidth;
            double sy = heightHint.doubleValue() / (double)imageHeight;
            AffineTransform at = AffineTransform.getScaleInstance(sx, sy);
            svgGenerator.drawImage((Image)image, at, null);
            Element root = svgDocument.getDocumentElement();
            svgGenerator.getRoot(root);
            String w = "" + widthHint.intValue();
            String h = "" + heightHint.intValue();
            root.setAttribute("width", w);
            root.setAttribute("height", h);
            root.setAttribute("viewBox", "0 0 " + w + " " + h);
            return root;
        }
        catch (IOException e) {
            ((TranscoderSupport)this).handler.fatalError(new TranscoderException((Exception)e));
            return null;
        }
    }
}

