/*
 * Decompiled with CFR 0.152.
 */
package com.sun.media.imageioimpl.plugins.jpeg;

import com.sun.media.imageioimpl.common.PackageUtil;
import com.sun.media.imageioimpl.plugins.jpeg.CLibJPEGImageWriter;
import java.awt.image.ColorModel;
import java.awt.image.IndexColorModel;
import java.awt.image.SampleModel;
import java.io.IOException;
import java.util.Locale;
import javax.imageio.ImageTypeSpecifier;
import javax.imageio.ImageWriter;
import javax.imageio.spi.ImageWriterSpi;
import javax.imageio.spi.ServiceRegistry;

public class CLibJPEGImageWriterSpi
extends ImageWriterSpi {
    private static final String[] names = new String[]{"jpeg", "JPEG", "jpg", "JPG", "jfif", "JFIF", "jpeg-lossless", "JPEG-LOSSLESS", "jpeg-ls", "JPEG-LS"};
    private static final String[] suffixes = new String[]{"jpeg", "jpg", "jfif", "jls"};
    private static final String[] MIMETypes = new String[]{"image/jpeg"};
    private static final String writerClassName = "com.sun.media.imageioimpl.plugins.jpeg.CLibJPEGImageWriter";
    private static final String[] readerSpiNames;

    public CLibJPEGImageWriterSpi() {
        super(PackageUtil.getVendor(), PackageUtil.getVersion(), names, suffixes, MIMETypes, writerClassName, ImageWriterSpi.STANDARD_OUTPUT_TYPE, readerSpiNames, false, null, null, null, null, false, null, null, null, null);
    }

    public void onRegistration(ServiceRegistry registry, Class category) {
        if (!PackageUtil.isCodecLibAvailable()) {
            registry.deregisterServiceProvider(this);
        } else {
            Object coreWriterSPI;
            Class<?> coreWriterSPIClass = null;
            try {
                coreWriterSPIClass = Class.forName("com.sun.imageio.plugins.jpeg.JPEGImageWriterSpi");
            }
            catch (Throwable t) {
                // empty catch block
            }
            if (coreWriterSPIClass != null && (coreWriterSPI = registry.getServiceProviderByClass(coreWriterSPIClass)) != null) {
                registry.setOrdering(category, this, coreWriterSPI);
            }
        }
    }

    public boolean canEncodeImage(ImageTypeSpecifier type) {
        int bitDepth;
        ColorModel colorModel = type.getColorModel();
        if (colorModel instanceof IndexColorModel) {
            return false;
        }
        SampleModel sampleModel = type.getSampleModel();
        if (colorModel != null) {
            int[] componentSize = colorModel.getComponentSize();
            bitDepth = componentSize[0];
            int i = 1;
            while (i < componentSize.length) {
                if (componentSize[i] != bitDepth) {
                    return false;
                }
                ++i;
            }
        } else {
            int[] sampleSize = sampleModel.getSampleSize();
            bitDepth = sampleSize[0];
            int i = 1;
            while (i < sampleSize.length) {
                if (sampleSize[i] != bitDepth) {
                    return false;
                }
                ++i;
            }
        }
        if (bitDepth > 16) {
            return false;
        }
        int numBands = sampleModel.getNumBands();
        return numBands == 1 || numBands == 3;
    }

    public String getDescription(Locale locale) {
        return "codecLib JPEG image writer";
    }

    public ImageWriter createWriterInstance(Object extension) throws IOException {
        return new CLibJPEGImageWriter(this);
    }

    static {
        writerClassName = writerClassName;
        readerSpiNames = new String[]{"com.sun.media.imageioimpl.plugins.jpeg.CLibJPEGImageReaderSpi"};
    }
}

