/*
 * Decompiled with CFR 0.152.
 */
package com.sun.media.imageioimpl.plugins.jpeg2000;

import com.sun.media.imageioimpl.plugins.jpeg2000.Box;
import javax.imageio.metadata.IIOInvalidTreeException;
import javax.imageio.metadata.IIOMetadataNode;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class DataEntryURLBox
extends Box {
    private static String[] elementNames = new String[]{"Version", "Flags", "URL"};
    private byte version;
    private byte[] flags;
    private String url;

    public static String[] getElementNames() {
        return elementNames;
    }

    public DataEntryURLBox(byte[] data) {
        super(8 + data.length, 1970433056, data);
    }

    public DataEntryURLBox(byte version, byte[] flags, String url) {
        super(12 + url.length(), 1970433056, null);
        this.version = version;
        this.flags = flags;
        this.url = url;
    }

    public DataEntryURLBox(Node node) throws IIOInvalidTreeException {
        super(node);
        NodeList children = node.getChildNodes();
        int i = 0;
        while (i < children.getLength()) {
            Node child = children.item(i);
            String name = child.getNodeName();
            if ("Version".equals(name)) {
                this.version = Box.getByteElementValue(child);
            }
            if ("Flags".equals(name)) {
                this.flags = Box.getByteArrayElementValue(child);
            }
            if ("URL".equals(name)) {
                this.url = Box.getStringElementValue(child);
            }
            ++i;
        }
    }

    protected void parse(byte[] data) {
        this.version = data[0];
        this.flags = new byte[3];
        this.flags[0] = data[1];
        this.flags[1] = data[2];
        this.flags[2] = data[3];
        this.url = new String(data, 4, data.length - 4);
    }

    public IIOMetadataNode getNativeNode() {
        return this.getNativeNodeForSimpleBox();
    }

    public byte getVersion() {
        return this.version;
    }

    public byte[] getFlags() {
        return this.flags;
    }

    public String getURL() {
        return this.url;
    }

    protected void compose() {
        if (this.data != null) {
            return;
        }
        this.data = new byte[4 + this.url.length()];
        this.data[0] = this.version;
        this.data[1] = this.flags[0];
        this.data[2] = this.flags[1];
        this.data[3] = this.flags[2];
        System.arraycopy(this.url.getBytes(), 0, this.data, 4, this.url.length());
    }
}

