/*
 * Decompiled with CFR 0.152.
 */
package com.sun.media.imageioimpl.plugins.png;

import com.sun.media.imageioimpl.plugins.png.I18N;
import java.util.Locale;
import javax.imageio.ImageWriteParam;

final class CLibPNGImageWriteParam
extends ImageWriteParam {
    private static final float DEFAULT_COMPRESSION_QUALITY = 1.0f;
    private static final String DEFAULT_COMPRESSION_TYPE = "DEFAULT";
    private static final String FILTERED_COMPRESSION_TYPE = "FILTERED";
    private static final String HUFFMAN_COMPRESSION_TYPE = "HUFFMAN_ONLY";
    private static final String[] compressionQualityDescriptions;

    CLibPNGImageWriteParam(Locale locale) {
        super(locale);
        this.canWriteCompressed = true;
        this.canWriteProgressive = true;
        this.compressionTypes = new String[]{DEFAULT_COMPRESSION_TYPE, FILTERED_COMPRESSION_TYPE, HUFFMAN_COMPRESSION_TYPE};
        this.compressionMode = 1;
        this.progressiveMode = 0;
        this.compressionQuality = 1.0f;
        this.compressionType = DEFAULT_COMPRESSION_TYPE;
    }

    int getStrategy() {
        if (this.compressionType.equals(FILTERED_COMPRESSION_TYPE)) {
            return 1;
        }
        if (this.compressionType.equals(HUFFMAN_COMPRESSION_TYPE)) {
            return 2;
        }
        return 0;
    }

    public String[] getCompressionQualityDescriptions() {
        super.getCompressionQualityDescriptions();
        return compressionQualityDescriptions;
    }

    public float[] getCompressionQualityValues() {
        super.getCompressionQualityValues();
        return new float[]{0.0f, 0.11111111f, 1.0f};
    }

    public void setCompressionMode(int mode) {
        if (mode == 0 || mode == 3) {
            throw new UnsupportedOperationException("mode == MODE_DISABLED || mode == MODE_COPY_FROM_METADATA");
        }
        super.setCompressionMode(mode);
    }

    public void setProgressiveMode(int mode) {
        if (mode == 3) {
            throw new UnsupportedOperationException("mode == MODE_COPY_FROM_METADATA");
        }
        super.setProgressiveMode(mode);
    }

    public void unsetCompression() {
        super.unsetCompression();
        this.compressionQuality = 1.0f;
        this.compressionType = DEFAULT_COMPRESSION_TYPE;
    }

    static {
        DEFAULT_COMPRESSION_QUALITY = 1.0f;
        DEFAULT_COMPRESSION_TYPE = DEFAULT_COMPRESSION_TYPE;
        FILTERED_COMPRESSION_TYPE = FILTERED_COMPRESSION_TYPE;
        HUFFMAN_COMPRESSION_TYPE = HUFFMAN_COMPRESSION_TYPE;
        compressionQualityDescriptions = new String[]{I18N.getString("CLibPNGImageWriteParam0"), I18N.getString("CLibPNGImageWriteParam1"), I18N.getString("CLibPNGImageWriteParam2")};
    }
}

