/*
 * Decompiled with CFR 0.152.
 */
package com.sun.media.imageioimpl.plugins.png;

import com.sun.media.imageioimpl.common.ImageUtil;
import com.sun.media.imageioimpl.plugins.clib.CLibImageWriter;
import com.sun.media.imageioimpl.plugins.clib.OutputStreamAdapter;
import com.sun.media.imageioimpl.plugins.png.CLibPNGImageWriteParam;
import com.sun.medialib.codec.png.Encoder;
import com.sun.medialib.mlib.mediaLibImage;
import java.awt.image.ColorModel;
import java.awt.image.IndexColorModel;
import java.awt.image.RenderedImage;
import java.io.IOException;
import java.io.OutputStream;
import javax.imageio.IIOException;
import javax.imageio.IIOImage;
import javax.imageio.ImageTypeSpecifier;
import javax.imageio.ImageWriteParam;
import javax.imageio.metadata.IIOMetadata;
import javax.imageio.spi.ImageWriterSpi;
import javax.imageio.stream.ImageOutputStream;

final class CLibPNGImageWriter
extends CLibImageWriter {
    CLibPNGImageWriter(ImageWriterSpi originatingProvider) {
        super(originatingProvider);
    }

    public ImageWriteParam getDefaultWriteParam() {
        return new CLibPNGImageWriteParam(this.getLocale());
    }

    public void write(IIOMetadata streamMetadata, IIOImage image, ImageWriteParam param) throws IOException {
        if (this.output == null) {
            throw new IllegalStateException("output == null");
        }
        OutputStreamAdapter stream = null;
        if (!(this.output instanceof ImageOutputStream)) {
            throw new IllegalArgumentException("!(output instanceof ImageOutputStream)");
        }
        stream = new OutputStreamAdapter((ImageOutputStream)this.output);
        RenderedImage renderedImage = image.getRenderedImage();
        ImageUtil.canEncodeImage(this, renderedImage.getColorModel(), renderedImage.getSampleModel());
        mediaLibImage mlImage = this.getMediaLibImage(renderedImage, param, true);
        Encoder encoder = null;
        try {
            encoder = new Encoder(mlImage);
        }
        catch (Throwable t) {
            throw new IIOException("codecLib error", t);
        }
        ColorModel colorModel = null;
        if (param != null) {
            ImageTypeSpecifier destinationType = param.getDestinationType();
            if (destinationType != null) {
                colorModel = destinationType.getColorModel();
            }
            if (param.getCompressionMode() == 2) {
                try {
                    encoder.setCompressionLevel((int)(param.getCompressionQuality() * 9.0f));
                }
                catch (Throwable t) {
                    throw new IIOException("codecLib error", t);
                }
                if (param instanceof CLibPNGImageWriteParam) {
                    try {
                        encoder.setStrategy(((CLibPNGImageWriteParam)param).getStrategy());
                    }
                    catch (Throwable t) {
                        throw new IIOException("codecLib error", t);
                    }
                }
            }
            switch (param.getProgressiveMode()) {
                case 1: {
                    try {
                        encoder.setInterlaceMethod(1);
                        break;
                    }
                    catch (Throwable t) {
                        throw new IIOException("codecLib error", t);
                    }
                }
                case 0: {
                    try {
                        encoder.setInterlaceMethod(0);
                        break;
                    }
                    catch (Throwable t) {
                        throw new IIOException("codecLib error", t);
                    }
                }
            }
        } else {
            try {
                encoder.setCompressionLevel(1);
                encoder.setStrategy(0);
                encoder.setInterlaceMethod(0);
            }
            catch (Throwable t) {
                throw new IIOException("codecLib error", t);
            }
        }
        if (colorModel == null) {
            colorModel = renderedImage.getColorModel();
        }
        if (colorModel instanceof IndexColorModel) {
            IndexColorModel icm = (IndexColorModel)colorModel;
            int mapSize = icm.getMapSize();
            byte[] map = new byte[mapSize];
            byte[] rgbPalette = new byte[3 * mapSize];
            icm.getReds(map);
            int i = 0;
            int j = 0;
            while (i < mapSize) {
                rgbPalette[j] = map[i];
                ++i;
                j += 3;
            }
            icm.getGreens(map);
            int i2 = 0;
            int j2 = 1;
            while (i2 < mapSize) {
                rgbPalette[j2] = map[i2];
                ++i2;
                j2 += 3;
            }
            icm.getBlues(map);
            int i3 = 0;
            int j3 = 2;
            while (i3 < mapSize) {
                rgbPalette[j3] = map[i3];
                ++i3;
                j3 += 3;
            }
            try {
                encoder.setPalette(rgbPalette);
            }
            catch (Throwable t) {
                throw new IIOException("codecLib error", t);
            }
            if (icm.hasAlpha()) {
                icm.getAlphas(map);
                int[] alphaPalette = new int[mapSize];
                int i4 = 0;
                while (i4 < mapSize) {
                    alphaPalette[i4] = map[i4];
                    ++i4;
                }
                try {
                    encoder.setTransparency(alphaPalette);
                }
                catch (Throwable t) {
                    throw new IIOException("codecLib error", t);
                }
            }
        } else if (mlImage.getType() == 0) {
            byte[] rgbPalette = colorModel != null ? new byte[]{(byte)colorModel.getRed(0), (byte)colorModel.getGreen(0), (byte)colorModel.getBlue(0), (byte)colorModel.getRed(1), (byte)colorModel.getGreen(1), (byte)colorModel.getBlue(1)} : new byte[]{0, 0, 0, -1, -1, -1};
            try {
                encoder.setPalette(rgbPalette);
            }
            catch (Throwable t) {
                throw new IIOException("codecLib error", t);
            }
        }
        try {
            encoder.encode((OutputStream)stream);
        }
        catch (Throwable t) {
            throw new IIOException("codecLib error", t);
        }
    }
}

