/*
 * Decompiled with CFR 0.152.
 */
package com.sun.media.imageioimpl.plugins.pnm;

import com.sun.media.imageio.plugins.pnm.PNMImageWriteParam;
import com.sun.media.imageioimpl.common.ImageUtil;
import com.sun.media.imageioimpl.plugins.pnm.I18N;
import com.sun.media.imageioimpl.plugins.pnm.PNMImageReader;
import com.sun.media.imageioimpl.plugins.pnm.PNMMetadataFormat;
import java.awt.image.SampleModel;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import javax.imageio.ImageTypeSpecifier;
import javax.imageio.ImageWriteParam;
import javax.imageio.ImageWriter;
import javax.imageio.metadata.IIOInvalidTreeException;
import javax.imageio.metadata.IIOMetadata;
import javax.imageio.metadata.IIOMetadataNode;
import javax.imageio.stream.ImageInputStream;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class PNMMetadata
extends IIOMetadata
implements Cloneable {
    static final String nativeMetadataFormatName = "com_sun_media_imageio_plugins_pnm_image_1.0";
    private PNMMetadataFormat format = (PNMMetadataFormat)this.getMetadataFormat("com_sun_media_imageio_plugins_pnm_image_1.0");
    private int maxSampleSize;
    private int width;
    private int height;
    private int variant;
    private ArrayList comments;
    private ImageInputStream iis;
    private PNMImageReader reader;

    public PNMMetadata() {
        super(true, nativeMetadataFormatName, "com.sun.media.imageioimpl.plugins.pnm.PNMMetadataFormat", null, null);
    }

    public PNMMetadata(ImageInputStream iis, PNMImageReader reader) throws IOException {
        this();
        this.iis = iis;
        this.reader = reader;
    }

    public PNMMetadata(ImageWriteParam param, ImageWriter writer) {
        this(null, param, writer);
    }

    public PNMMetadata(ImageTypeSpecifier imageType, ImageWriteParam param, ImageWriter writer) {
        this();
        ImageTypeSpecifier destType = null;
        if (param != null) {
            destType = param.getDestinationType();
            if (imageType != null) {
                destType = imageType;
            }
        }
        if (destType != null) {
            SampleModel sm = destType.getSampleModel();
            int[] sampleSize = sm.getSampleSize();
            this.width = sm.getWidth();
            this.height = sm.getHeight();
            int i = 0;
            while (i < sampleSize.length) {
                if (sampleSize[i] > this.maxSampleSize) {
                    this.maxSampleSize = sampleSize[i];
                }
                ++i;
            }
            boolean isRaw = true;
            if (param instanceof PNMImageWriteParam) {
                isRaw = ((PNMImageWriteParam)param).getRaw();
            }
            if (this.maxSampleSize == 1) {
                this.variant = 49;
            } else if (sm.getNumBands() == 1) {
                this.variant = 50;
            } else if (sm.getNumBands() == 3) {
                this.variant = 51;
            }
            if (this.variant <= 51 && isRaw && this.maxSampleSize <= 8) {
                this.variant += 3;
            }
        }
    }

    protected Object clone() {
        PNMMetadata theClone = null;
        try {
            theClone = (PNMMetadata)super.clone();
        }
        catch (CloneNotSupportedException e) {
            // empty catch block
        }
        if (this.comments != null) {
            Iterator iter = this.comments.iterator();
            while (iter.hasNext()) {
                theClone.addComment((String)iter.next());
            }
        }
        return theClone;
    }

    public Node getAsTree(String formatName) {
        if (formatName == null) {
            throw new IllegalArgumentException(I18N.getString("PNMMetadata0"));
        }
        if (formatName.equals(nativeMetadataFormatName)) {
            return this.getNativeTree();
        }
        if (formatName.equals("javax_imageio_1.0")) {
            return this.getStandardTree();
        }
        throw new IllegalArgumentException(I18N.getString("PNMMetadata1") + " " + formatName);
    }

    IIOMetadataNode getNativeTree() {
        IIOMetadataNode root = new IIOMetadataNode(nativeMetadataFormatName);
        IIOMetadataNode child = new IIOMetadataNode("FormatName");
        child.setUserObject(this.getFormatName());
        child.setNodeValue(this.getFormatName());
        child = new IIOMetadataNode("Variant");
        child.setUserObject(this.getVariant());
        child.setNodeValue(this.getVariant());
        child = new IIOMetadataNode("Width");
        Number tmp = new Integer(this.width);
        child.setUserObject(tmp);
        child.setNodeValue(ImageUtil.convertObjectToString(tmp));
        child = new IIOMetadataNode("Height");
        tmp = new Integer(this.height);
        child.setUserObject(tmp);
        child.setNodeValue(ImageUtil.convertObjectToString(tmp));
        child = new IIOMetadataNode("MaximumSample");
        tmp = new Byte((byte)this.maxSampleSize);
        child.setUserObject(tmp);
        child.setNodeValue(ImageUtil.convertObjectToString(tmp));
        int i = 0;
        while (i < this.comments.size()) {
            child = new IIOMetadataNode("Comment");
            tmp = this.comments.get(i);
            child.setUserObject(tmp);
            child.setNodeValue(ImageUtil.convertObjectToString(tmp));
            ++i;
        }
        return root;
    }

    protected IIOMetadataNode getStandardChromaNode() {
        IIOMetadataNode node = new IIOMetadataNode("Chroma");
        int temp = (this.variant - 49) % 3 + 1;
        IIOMetadataNode subNode = new IIOMetadataNode("ColorSpaceType");
        if (temp == 3) {
            subNode.setAttribute("name", "RGB");
        } else {
            subNode.setAttribute("name", "GRAY");
        }
        node.appendChild(subNode);
        subNode = new IIOMetadataNode("NumChannels");
        subNode.setAttribute("value", "" + (temp == 3 ? 3 : 1));
        node.appendChild(subNode);
        return node;
    }

    protected IIOMetadataNode getStandardCompressionNode() {
        return null;
    }

    protected IIOMetadataNode getStandardDataNode() {
        IIOMetadataNode node = new IIOMetadataNode("Data");
        IIOMetadataNode subNode = new IIOMetadataNode("SampleFormat");
        subNode.setAttribute("value", "UnsignedIntegral");
        node.appendChild(subNode);
        subNode = new IIOMetadataNode("SignificantBitsPerSample");
        subNode.setAttribute("value", "" + this.maxSampleSize);
        node.appendChild(subNode);
        return node;
    }

    protected IIOMetadataNode getStandardDimensionNode() {
        return null;
    }

    protected IIOMetadataNode getStandardTransparencyNode() {
        return null;
    }

    public boolean isReadOnly() {
        return false;
    }

    public void mergeTree(String formatName, Node root) throws IIOInvalidTreeException {
        if (formatName == null) {
            throw new IllegalArgumentException(I18N.getString("PNMMetadata0"));
        }
        if (root == null) {
            throw new IllegalArgumentException(I18N.getString("PNMMetadata2"));
        }
        if (formatName.equals(nativeMetadataFormatName) && root.getNodeName().equals(nativeMetadataFormatName)) {
            this.mergeNativeTree(root);
        } else if (formatName.equals("javax_imageio_1.0")) {
            this.mergeStandardTree(root);
        } else {
            throw new IllegalArgumentException(I18N.getString("PNMMetadata1") + " " + formatName);
        }
    }

    public void setFromTree(String formatName, Node root) throws IIOInvalidTreeException {
        if (formatName == null) {
            throw new IllegalArgumentException(I18N.getString("PNMMetadata0"));
        }
        if (root == null) {
            throw new IllegalArgumentException(I18N.getString("PNMMetadata2"));
        }
        if (formatName.equals(nativeMetadataFormatName) && root.getNodeName().equals(nativeMetadataFormatName)) {
            this.comments = new ArrayList();
            this.mergeNativeTree(root);
        } else if (formatName.equals("javax_imageio_1.0")) {
            this.comments = new ArrayList();
            this.mergeStandardTree(root);
        } else {
            throw new IllegalArgumentException(I18N.getString("PNMMetadata2") + " " + formatName);
        }
    }

    public void reset() {
        this.comments = null;
    }

    public String getFormatName() {
        int v = (this.variant - 49) % 3 + 1;
        if (v == 1) {
            return "PBM";
        }
        if (v == 2) {
            return "PGM";
        }
        if (v == 3) {
            return "PPM";
        }
        return null;
    }

    public String getVariant() {
        if (this.variant > 51) {
            return "RAWBITS";
        }
        return "ASCII";
    }

    public void setVariant(int v) {
        this.variant = v;
    }

    public void setWidth(int w) {
        this.width = w;
    }

    public void setHeight(int h) {
        this.height = h;
    }

    public void setMaxBitDepth(int maxValue) {
        this.maxSampleSize = 0;
        while (maxValue > 0) {
            maxValue >>>= 1;
            ++this.maxSampleSize;
        }
    }

    public void addComment(String comment) {
        if (this.comments == null) {
            this.comments = new ArrayList();
        }
        this.comments.add(comment);
    }

    private void mergeNativeTree(Node root) throws IIOInvalidTreeException {
        NodeList list = root.getChildNodes();
        String format = null;
        String var = null;
        int i = list.getLength() - 1;
        while (i >= 0) {
            IIOMetadataNode node = (IIOMetadataNode)list.item(i);
            String name = node.getNodeName();
            if (name.equals("Comment")) {
                this.comments.add(node.getUserObject());
            } else if (name.equals("Width")) {
                this.width = (Integer)node.getUserObject();
            } else if (name.equals("Height")) {
                this.width = (Integer)node.getUserObject();
            } else if (name.equals("MaximumSample")) {
                this.maxSampleSize = (Integer)node.getUserObject();
            } else if (name.equals("FormatName")) {
                format = (String)node.getUserObject();
            } else if (name.equals("Variant")) {
                var = (String)node.getUserObject();
            }
            --i;
        }
        if (format.equals("PBM")) {
            this.variant = 49;
        } else if (format.equals("PGM")) {
            this.variant = 50;
        } else if (format.equals("PPM")) {
            this.variant = 51;
        }
        if (var.equals("RAWBITS")) {
            this.variant += 3;
        }
    }

    private void mergeStandardTree(Node root) throws IIOInvalidTreeException {
        NodeList children = root.getChildNodes();
        int numComps = 0;
        int i = 0;
        while (i < children.getLength()) {
            String s;
            String name1;
            Node child;
            int j;
            NodeList children1;
            Node node = children.item(i);
            String name = node.getNodeName();
            if (name.equals("Chroma")) {
                children1 = node.getChildNodes();
                j = 0;
                while (j < children1.getLength()) {
                    child = children1.item(i);
                    name1 = child.getNodeName();
                    if (name1.equals("NumChannels")) {
                        s = (String)this.getAttribute(node, "value");
                        numComps = new Integer(s);
                    }
                    ++j;
                }
            } else if (name.equals("Data")) {
                children1 = node.getChildNodes();
                j = 0;
                while (j < children1.getLength()) {
                    child = children1.item(i);
                    name1 = child.getNodeName();
                    if (name1.equals("SignificantBitsPerSample")) {
                        s = (String)this.getAttribute(node, "value");
                        this.maxSampleSize = new Integer(s);
                    }
                    ++j;
                }
            } else if (name.equals("Text")) {
                children1 = node.getChildNodes();
                j = 0;
                while (j < children1.getLength()) {
                    child = children1.item(i);
                    name1 = child.getNodeName();
                    if (name1.equals("Comment")) {
                        this.comments.add((String)this.getAttribute(node, "value"));
                    }
                    ++j;
                }
            } else {
                throw new IIOInvalidTreeException(I18N.getString("PNMMetadata3") + " " + name, node);
            }
            ++i;
        }
        if (numComps == 1) {
            this.variant = this.maxSampleSize == 1 ? 49 : 50;
        } else if (numComps == 3) {
            this.variant = 51;
        }
    }

    public Object getAttribute(Node node, String name) {
        NamedNodeMap map = node.getAttributes();
        return (node = map.getNamedItem(name)) != null ? node.getNodeValue() : null;
    }

    static {
        nativeMetadataFormatName = nativeMetadataFormatName;
    }
}

