/*
 * Decompiled with CFR 0.152.
 */
package com.sun.media.imageioimpl.plugins.tiff;

import com.sun.media.imageio.plugins.tiff.BaselineTIFFTagSet;
import com.sun.media.imageio.plugins.tiff.TIFFColorConverter;
import com.sun.media.imageio.plugins.tiff.TIFFCompressor;
import com.sun.media.imageio.plugins.tiff.TIFFImageWriteParam;
import com.sun.media.imageio.plugins.tiff.TIFFTag;
import com.sun.media.imageioimpl.common.ImageUtil;
import com.sun.media.imageioimpl.common.PackageUtil;
import com.sun.media.imageioimpl.common.SingleTileRenderedImage;
import com.sun.media.imageioimpl.plugins.tiff.TIFFCIELabColorConverter;
import com.sun.media.imageioimpl.plugins.tiff.TIFFCodecLibT4Compressor;
import com.sun.media.imageioimpl.plugins.tiff.TIFFCodecLibT6Compressor;
import com.sun.media.imageioimpl.plugins.tiff.TIFFDeflateCompressor;
import com.sun.media.imageioimpl.plugins.tiff.TIFFField;
import com.sun.media.imageioimpl.plugins.tiff.TIFFIFD;
import com.sun.media.imageioimpl.plugins.tiff.TIFFImageMetadata;
import com.sun.media.imageioimpl.plugins.tiff.TIFFImageReader;
import com.sun.media.imageioimpl.plugins.tiff.TIFFImageReaderSpi;
import com.sun.media.imageioimpl.plugins.tiff.TIFFJPEGCompressor;
import com.sun.media.imageioimpl.plugins.tiff.TIFFLSBCompressor;
import com.sun.media.imageioimpl.plugins.tiff.TIFFNullCompressor;
import com.sun.media.imageioimpl.plugins.tiff.TIFFPackBitsCompressor;
import com.sun.media.imageioimpl.plugins.tiff.TIFFRLECompressor;
import com.sun.media.imageioimpl.plugins.tiff.TIFFStreamMetadata;
import com.sun.media.imageioimpl.plugins.tiff.TIFFT4Compressor;
import com.sun.media.imageioimpl.plugins.tiff.TIFFT6Compressor;
import com.sun.media.imageioimpl.plugins.tiff.TIFFYCbCrColorConverter;
import com.sun.media.imageioimpl.plugins.tiff.TIFFZLibCompressor;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.image.BufferedImage;
import java.awt.image.ColorModel;
import java.awt.image.ComponentSampleModel;
import java.awt.image.DataBuffer;
import java.awt.image.DataBufferByte;
import java.awt.image.IndexColorModel;
import java.awt.image.Raster;
import java.awt.image.RenderedImage;
import java.awt.image.SampleModel;
import java.awt.image.WritableRaster;
import java.io.EOFException;
import java.io.IOException;
import java.nio.ByteOrder;
import java.util.ArrayList;
import java.util.Arrays;
import javax.imageio.IIOException;
import javax.imageio.IIOImage;
import javax.imageio.ImageTypeSpecifier;
import javax.imageio.ImageWriteParam;
import javax.imageio.ImageWriter;
import javax.imageio.metadata.IIOMetadata;
import javax.imageio.spi.ImageWriterSpi;
import javax.imageio.stream.ImageOutputStream;

public class TIFFImageWriter
extends ImageWriter {
    private static final boolean DEBUG = false;
    public static final int DEFAULT_BYTES_PER_STRIP = 8192;
    public static final String[] TIFFCompressionTypes;
    public static final String[] compressionTypes;
    public static final boolean[] isCompressionLossless;
    public static final int[] compressionNumbers;
    ImageOutputStream stream;
    long headerPosition;
    RenderedImage image;
    ImageTypeSpecifier imageType;
    ByteOrder byteOrder;
    ImageWriteParam param;
    TIFFCompressor compressor;
    TIFFColorConverter colorConverter;
    TIFFStreamMetadata streamMetadata;
    TIFFImageMetadata imageMetadata;
    int sourceXOffset;
    int sourceYOffset;
    int sourceWidth;
    int sourceHeight;
    int[] sourceBands;
    int periodX;
    int periodY;
    int bitDepth;
    int numBands;
    int tileWidth;
    int tileLength;
    int tilesAcross;
    int tilesDown;
    int[] sampleSize = null;
    int scalingBitDepth = -1;
    boolean isRescaling = false;
    boolean isBilevel;
    boolean isImageSimple;
    boolean isInverted;
    boolean isTiled;
    int nativePhotometricInterpretation;
    int photometricInterpretation;
    char[] bitsPerSample;
    int sampleFormat = 4;
    byte[][] scale = null;
    byte[] scale0 = null;
    byte[][] scaleh = null;
    byte[][] scalel = null;
    int compression;
    int totalPixels;
    int pixelsDone;
    long nextIFDPointerPos;
    private Object replacePixelsLock = new Object();
    private int replacePixelsIndex = -1;
    private TIFFImageMetadata replacePixelsMetadata = null;
    private long[] replacePixelsTileOffsets = null;
    private Rectangle replacePixelsRegion = null;
    private boolean inReplacePixelsNest = false;
    private TIFFImageReader reader = null;

    public static int XToTileX(int x, int tileGridXOffset, int tileWidth) {
        if ((x -= tileGridXOffset) < 0) {
            x += 1 - tileWidth;
        }
        return x / tileWidth;
    }

    public static int YToTileY(int y, int tileGridYOffset, int tileHeight) {
        if ((y -= tileGridYOffset) < 0) {
            y += 1 - tileHeight;
        }
        return y / tileHeight;
    }

    public TIFFImageWriter(ImageWriterSpi originatingProvider) {
        super(originatingProvider);
    }

    public ImageWriteParam getDefaultWriteParam() {
        return new TIFFImageWriteParam(this.getLocale());
    }

    public void setOutput(Object output) {
        super.setOutput(output);
        if (output != null) {
            if (!(output instanceof ImageOutputStream)) {
                throw new IllegalArgumentException("output not an ImageOutputStream!");
            }
            this.stream = (ImageOutputStream)output;
            try {
                this.headerPosition = this.stream.getStreamPosition();
            }
            catch (IOException ioe) {
                this.headerPosition = 0L;
            }
        } else {
            this.stream = null;
        }
    }

    public IIOMetadata getDefaultStreamMetadata(ImageWriteParam param) {
        return null;
    }

    public IIOMetadata getDefaultImageMetadata(ImageTypeSpecifier imageType, ImageWriteParam param) {
        ArrayList<BaselineTIFFTagSet> tagSets = new ArrayList<BaselineTIFFTagSet>(1);
        tagSets.add(BaselineTIFFTagSet.getInstance());
        TIFFImageMetadata imageMetadata = new TIFFImageMetadata(tagSets);
        return imageMetadata;
    }

    public IIOMetadata convertStreamMetadata(IIOMetadata inData, ImageWriteParam param) {
        return inData;
    }

    public IIOMetadata convertImageMetadata(IIOMetadata inData, ImageTypeSpecifier imageType, ImageWriteParam param) {
        return inData;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void setupMetadata(int destWidth, int destHeight) throws IIOException {
        boolean useTiling;
        int tilingMode;
        int rowsPerStrip;
        int i;
        TIFFIFD rootIFD = this.imageMetadata.getRootIFD();
        BaselineTIFFTagSet base = BaselineTIFFTagSet.getInstance();
        TIFFField f = rootIFD.getTIFFField(284);
        if (f != null && f.getAsInt(0) != 1) {
            TIFFField planarConfigurationField = new TIFFField(base.getTag(284), 1);
            rootIFD.addTIFFField(planarConfigurationField);
        }
        char[] extraSamples = null;
        this.photometricInterpretation = -1;
        boolean forcePhotometricInterpretation = false;
        f = rootIFD.getTIFFField(262);
        if (f != null) {
            this.photometricInterpretation = f.getAsInt(0);
            forcePhotometricInterpretation = true;
        }
        SampleModel sm = this.image.getSampleModel();
        ColorModel cm = this.image.getColorModel();
        int[] sampleSize = sm.getSampleSize();
        int numBands = sm.getNumBands();
        int numExtraSamples = 0;
        if (numBands > 1 && cm != null && cm.hasAlpha()) {
            --numBands;
            numExtraSamples = 1;
            extraSamples = new char[]{cm.isAlphaPremultiplied() ? (char)'\u0001' : '\u0002'};
        }
        if (numBands == 3) {
            this.nativePhotometricInterpretation = 2;
            if (this.photometricInterpretation == -1) {
                this.photometricInterpretation = 2;
            }
        } else if (sm.getNumBands() == 1 && cm instanceof IndexColorModel) {
            IndexColorModel icm = (IndexColorModel)cm;
            int r0 = icm.getRed(0);
            int r1 = icm.getRed(1);
            if (!(r0 != icm.getGreen(0) || r0 != icm.getBlue(0) || r1 != icm.getGreen(1) || r1 != icm.getBlue(1) || r0 != 0 && r0 != 255 || r1 != 0 && r1 != 255 || r0 == r1)) {
                this.nativePhotometricInterpretation = r0 == 0 ? 1 : 0;
                if (this.photometricInterpretation != 1 && this.photometricInterpretation != 0) {
                    this.photometricInterpretation = r0 == 0 ? 1 : 0;
                }
            } else {
                this.photometricInterpretation = 3;
                this.nativePhotometricInterpretation = 3;
            }
        } else {
            if (cm != null) {
                switch (cm.getColorSpace().getType()) {
                    case 1: {
                        this.nativePhotometricInterpretation = 8;
                        break;
                    }
                    case 3: {
                        this.nativePhotometricInterpretation = 6;
                        break;
                    }
                    case 9: {
                        this.nativePhotometricInterpretation = 5;
                        break;
                    }
                    default: {
                        this.nativePhotometricInterpretation = 1;
                        break;
                    }
                }
            } else {
                this.nativePhotometricInterpretation = 1;
            }
            if (this.photometricInterpretation == -1) {
                this.photometricInterpretation = this.nativePhotometricInterpretation;
            }
        }
        this.compressor = null;
        this.colorConverter = null;
        if (this.param instanceof TIFFImageWriteParam) {
            TIFFImageWriteParam tparam = (TIFFImageWriteParam)this.param;
            if (tparam.getCompressionMode() == 2) {
                this.compressor = tparam.getTIFFCompressor();
                String compressionType = this.param.getCompressionType();
                if (this.compressor != null && !this.compressor.getCompressionType().equals(compressionType)) {
                    this.compressor = null;
                }
            } else {
                this.compressor = null;
            }
            this.colorConverter = tparam.getColorConverter();
            if (this.colorConverter != null) {
                this.photometricInterpretation = tparam.getPhotometricInterpretation();
            }
        }
        int compressionMode = this.param instanceof TIFFImageWriteParam ? this.param.getCompressionMode() : 1;
        switch (compressionMode) {
            case 2: {
                String compressionType = this.param.getCompressionType();
                if (compressionType == null) {
                    this.compression = 1;
                } else {
                    int len = compressionTypes.length;
                    i = 0;
                    while (i < len) {
                        if (compressionType.equals(compressionTypes[i])) {
                            this.compression = compressionNumbers[i];
                        }
                        ++i;
                    }
                }
                if (this.compressor == null || this.compressor.getCompressionTagValue() == this.compression) break;
                this.compressor = null;
                break;
            }
            case 3: {
                TIFFField compField = rootIFD.getTIFFField(259);
                if (compField != null) {
                    this.compression = compField.getAsInt(0);
                    break;
                }
            }
            default: {
                this.compression = 1;
            }
        }
        TIFFField compressionField = new TIFFField(base.getTag(259), this.compression);
        rootIFD.addTIFFField(compressionField);
        if (this.compressor == null) {
            if (this.compression == 2) {
                this.compressor = new TIFFRLECompressor();
                if (!forcePhotometricInterpretation) {
                    this.photometricInterpretation = 0;
                }
            } else if (this.compression == 3) {
                if (PackageUtil.isCodecLibAvailable()) {
                    try {
                        this.compressor = new TIFFCodecLibT4Compressor();
                    }
                    catch (RuntimeException e) {
                        // empty catch block
                    }
                }
                if (this.compressor == null) {
                    this.compressor = new TIFFT4Compressor();
                }
                if (!forcePhotometricInterpretation) {
                    this.photometricInterpretation = 0;
                }
            } else if (this.compression == 4) {
                if (PackageUtil.isCodecLibAvailable()) {
                    try {
                        this.compressor = new TIFFCodecLibT6Compressor();
                    }
                    catch (RuntimeException e) {
                        // empty catch block
                    }
                }
                if (this.compressor == null) {
                    this.compressor = new TIFFT6Compressor();
                }
                if (!forcePhotometricInterpretation) {
                    this.photometricInterpretation = 0;
                }
            } else {
                if (this.compression == 5) {
                    throw new IIOException("LZW compression not supported!");
                }
                if (this.compression == 6) {
                    throw new IIOException("Old JPEG compression not supported!");
                }
                if (this.compression == 7) {
                    this.compressor = new TIFFJPEGCompressor(this.param);
                    if (numBands == 3) {
                        this.photometricInterpretation = 6;
                    } else {
                        if (numBands != 1) throw new IIOException("JPEG compression supported for 1- and 3-band byte images only!");
                        this.photometricInterpretation = 1;
                    }
                } else if (this.compression == 8) {
                    this.compressor = new TIFFZLibCompressor(this.param);
                } else if (this.compression == 32773) {
                    this.compressor = new TIFFPackBitsCompressor();
                } else if (this.compression == 32946) {
                    this.compressor = new TIFFDeflateCompressor(this.param);
                } else {
                    f = rootIFD.getTIFFField(266);
                    boolean inverseFill = f != null && f.getAsInt(0) == 2;
                    this.compressor = inverseFill ? new TIFFLSBCompressor() : new TIFFNullCompressor();
                }
            }
        }
        if (this.colorConverter == null && cm != null && cm.getColorSpace().getType() == 5) {
            if (this.photometricInterpretation == 6 && this.compression != 7) {
                this.colorConverter = new TIFFYCbCrColorConverter(this.imageMetadata);
            } else if (this.photometricInterpretation == 8) {
                this.colorConverter = new TIFFCIELabColorConverter();
            }
        }
        if (this.photometricInterpretation == 6 && this.compression != 7) {
            rootIFD.removeTIFFField(530);
            rootIFD.removeTIFFField(531);
            rootIFD.addTIFFField(new TIFFField(base.getTag(530), 3, 2, new char[]{'\u0001', '\u0001'}));
            rootIFD.addTIFFField(new TIFFField(base.getTag(531), 3, 1, new char[]{'\u0002'}));
        }
        TIFFField photometricInterpretationField = new TIFFField(base.getTag(262), this.photometricInterpretation);
        rootIFD.addTIFFField(photometricInterpretationField);
        this.bitsPerSample = new char[numBands + numExtraSamples];
        this.bitDepth = 0;
        i = 0;
        while (i < numBands) {
            this.bitDepth = Math.max(this.bitDepth, sampleSize[i]);
            ++i;
        }
        if (this.bitDepth == 3) {
            this.bitDepth = 4;
        } else if (this.bitDepth > 4 && this.bitDepth < 8) {
            this.bitDepth = 8;
        } else if (this.bitDepth > 8 && this.bitDepth < 16) {
            this.bitDepth = 16;
        } else if (this.bitDepth > 16) {
            this.bitDepth = 32;
        }
        int i2 = 0;
        while (i2 < this.bitsPerSample.length) {
            this.bitsPerSample[i2] = (char)this.bitDepth;
            ++i2;
        }
        if (this.bitsPerSample.length != 1 || this.bitsPerSample[0] != '\u0001') {
            TIFFField bitsPerSampleField = new TIFFField(base.getTag(258), 3, this.bitsPerSample.length, this.bitsPerSample);
            rootIFD.addTIFFField(bitsPerSampleField);
        } else {
            rootIFD.removeTIFFField(258);
        }
        f = rootIFD.getTIFFField(339);
        if (f == null && (this.bitDepth == 16 || this.bitDepth == 32)) {
            int dataType = sm.getDataType();
            char sampleFormatValue = this.bitDepth == 16 && dataType == 1 ? (char)'\u0001' : (this.bitDepth == 32 && dataType == 4 ? (char)'\u0003' : '\u0002');
            char[] sampleFormatArray = new char[this.bitsPerSample.length];
            Arrays.fill(sampleFormatArray, sampleFormatValue);
            TIFFTag sampleFormatTag = base.getTag(339);
            TIFFField sampleFormatField = new TIFFField(sampleFormatTag, 3, sampleFormatArray.length, sampleFormatArray);
            rootIFD.addTIFFField(sampleFormatField);
        } else {
            this.sampleFormat = f != null ? f.getAsInt(0) : 4;
        }
        if (extraSamples != null) {
            TIFFField extraSamplesField = new TIFFField(base.getTag(338), 3, extraSamples.length, extraSamples);
            rootIFD.addTIFFField(extraSamplesField);
        } else {
            rootIFD.removeTIFFField(338);
        }
        TIFFField samplesPerPixelField = new TIFFField(base.getTag(277), this.bitsPerSample.length);
        rootIFD.addTIFFField(samplesPerPixelField);
        if (this.photometricInterpretation == 3) {
            char[] colorMap = new char[3 * ('\u0001' << this.bitsPerSample[0])];
            IndexColorModel icm = (IndexColorModel)cm;
            int mapSize = icm.getMapSize();
            int i3 = 0;
            while (i3 < mapSize) {
                colorMap[i3] = (char)(icm.getRed(i3) * 65535 / 255);
                colorMap[mapSize + i3] = (char)(icm.getGreen(i3) * 65535 / 255);
                colorMap[2 * mapSize + i3] = (char)(icm.getBlue(i3) * 65535 / 255);
                ++i3;
            }
            TIFFField colorMapField = new TIFFField(base.getTag(320), 3, colorMap.length, colorMap);
            rootIFD.addTIFFField(colorMapField);
        } else {
            rootIFD.removeTIFFField(320);
        }
        if (rootIFD.getTIFFField(282) == null && rootIFD.getTIFFField(283) == null && rootIFD.getTIFFField(296) == null) {
            long[][] rationalOne = new long[1][2];
            rationalOne[0] = new long[2];
            rationalOne[0][0] = 1L;
            rationalOne[0][1] = 1L;
            TIFFField XResolutionField = new TIFFField(rootIFD.getTag(282), 5, 1, rationalOne);
            rootIFD.addTIFFField(XResolutionField);
            TIFFField YResolutionField = new TIFFField(rootIFD.getTag(283), 5, 1, rationalOne);
            rootIFD.addTIFFField(YResolutionField);
            TIFFField ResolutionUnitField = new TIFFField(rootIFD.getTag(296), 1);
            rootIFD.addTIFFField(ResolutionUnitField);
        }
        int width = destWidth;
        TIFFField imageWidthField = new TIFFField(base.getTag(256), width);
        rootIFD.addTIFFField(imageWidthField);
        int height = destHeight;
        TIFFField imageLengthField = new TIFFField(base.getTag(257), height);
        rootIFD.addTIFFField(imageLengthField);
        TIFFField rowsPerStripField = rootIFD.getTIFFField(278);
        if (rowsPerStripField != null) {
            rowsPerStrip = rowsPerStripField.getAsInt(0);
            if (rowsPerStrip < 0) {
                rowsPerStrip = height;
            }
        } else {
            int bitsPerPixel = this.bitDepth * (numBands + numExtraSamples);
            int bytesPerRow = (bitsPerPixel * width + 7) / 8;
            rowsPerStrip = Math.max(Math.max(8192 / bytesPerRow, 1), 8);
        }
        rowsPerStrip = Math.min(rowsPerStrip, height);
        int n = tilingMode = this.param instanceof TIFFImageWriteParam ? this.param.getTilingMode() : 1;
        if (tilingMode == 0 || tilingMode == 1) {
            this.tileWidth = width;
            this.tileLength = rowsPerStrip;
        } else if (tilingMode == 2) {
            this.tileWidth = this.param.getTileWidth();
            this.tileLength = this.param.getTileHeight();
        } else {
            if (tilingMode != 3) throw new IIOException("Illegal value of tilingMode!");
            f = rootIFD.getTIFFField(322);
            this.tileWidth = f == null ? width : f.getAsInt(0);
            f = rootIFD.getTIFFField(323);
            this.tileLength = f == null ? rowsPerStrip : f.getAsInt(0);
        }
        boolean bl = useTiling = this.tileWidth != width || this.tileLength != rowsPerStrip;
        if (this.compression == 7) {
            int subX;
            int subY;
            if (numBands == 1) {
                subY = 1;
                subX = 1;
            } else {
                subY = 2;
                subX = 2;
            }
            if (useTiling) {
                int MCUMultipleX = 8 * subX;
                int MCUMultipleY = 8 * subY;
                this.tileWidth = Math.max(MCUMultipleX * ((this.tileWidth + MCUMultipleX / 2) / MCUMultipleX), MCUMultipleX);
                this.tileLength = Math.max(MCUMultipleY * ((this.tileLength + MCUMultipleY / 2) / MCUMultipleY), MCUMultipleY);
            } else if (rowsPerStrip < height) {
                int MCUMultiple = 8 * Math.max(subX, subY);
                rowsPerStrip = this.tileLength = Math.max(MCUMultiple * ((this.tileLength + MCUMultiple / 2) / MCUMultiple), MCUMultiple);
            }
        } else if (useTiling) {
            int tileLengthRemainder;
            int tileWidthRemainder = this.tileWidth % 16;
            if (tileWidthRemainder != 0) {
                this.tileWidth = Math.max(16 * ((this.tileWidth + 8) / 16), 16);
            }
            if ((tileLengthRemainder = this.tileLength % 16) != 0) {
                this.tileLength = Math.max(16 * ((this.tileLength + 8) / 16), 16);
            }
        }
        this.tilesAcross = (width + this.tileWidth - 1) / this.tileWidth;
        this.tilesDown = (height + this.tileLength - 1) / this.tileLength;
        if (!useTiling) {
            this.isTiled = false;
            rootIFD.removeTIFFField(322);
            rootIFD.removeTIFFField(323);
            rootIFD.removeTIFFField(324);
            rootIFD.removeTIFFField(325);
            rowsPerStripField = new TIFFField(base.getTag(278), rowsPerStrip);
            rootIFD.addTIFFField(rowsPerStripField);
            TIFFField stripOffsetsField = new TIFFField(base.getTag(273), 4, this.tilesDown);
            rootIFD.addTIFFField(stripOffsetsField);
            TIFFField stripByteCountsField = new TIFFField(base.getTag(279), 4, this.tilesDown);
            rootIFD.addTIFFField(stripByteCountsField);
            return;
        } else {
            this.isTiled = true;
            rootIFD.removeTIFFField(278);
            rootIFD.removeTIFFField(273);
            rootIFD.removeTIFFField(279);
            TIFFField tileWidthField = new TIFFField(base.getTag(322), this.tileWidth);
            rootIFD.addTIFFField(tileWidthField);
            TIFFField tileLengthField = new TIFFField(base.getTag(323), this.tileLength);
            rootIFD.addTIFFField(tileLengthField);
            TIFFField tileOffsetsField = new TIFFField(base.getTag(324), 4, this.tilesDown * this.tilesAcross);
            rootIFD.addTIFFField(tileOffsetsField);
            TIFFField tileByteCountsField = new TIFFField(base.getTag(325), 4, this.tilesDown * this.tilesAcross);
            rootIFD.addTIFFField(tileByteCountsField);
        }
    }

    private int writeTile(Rectangle tileRect, TIFFCompressor compressor) throws IOException {
        boolean isPadded;
        Rectangle activeRect;
        Rectangle imageBounds = new Rectangle(this.image.getMinX(), this.image.getMinY(), this.image.getWidth(), this.image.getHeight());
        if (!this.isTiled) {
            tileRect = activeRect = tileRect.intersection(imageBounds);
            isPadded = false;
        } else if (imageBounds.contains(tileRect)) {
            activeRect = tileRect;
            isPadded = false;
        } else {
            activeRect = imageBounds.intersection(tileRect);
            isPadded = true;
        }
        if (activeRect.isEmpty()) {
            return 0;
        }
        int minX = tileRect.x;
        int minY = tileRect.y;
        int width = tileRect.width;
        int height = tileRect.height;
        if (this.isImageSimple) {
            SampleModel sm = this.image.getSampleModel();
            Raster raster = this.image.getData(activeRect);
            if (isPadded) {
                WritableRaster wr = raster.createCompatibleWritableRaster(minX, minY, width, height);
                wr.setRect(raster);
                raster = wr;
            }
            if (this.isBilevel) {
                byte[] buf = ImageUtil.getPackedBinaryData(raster, tileRect);
                if (this.isInverted) {
                    DataBuffer dbb = raster.getDataBuffer();
                    if (dbb instanceof DataBufferByte && buf == ((DataBufferByte)dbb).getData()) {
                        byte[] bbuf = new byte[buf.length];
                        int len = buf.length;
                        int i = 0;
                        while (i < len) {
                            bbuf[i] = (byte)(buf[i] ^ 0xFF);
                            ++i;
                        }
                        buf = bbuf;
                    } else {
                        int len = buf.length;
                        int i = 0;
                        while (i < len) {
                            int n = i++;
                            buf[n] = (byte)(buf[n] ^ 0xFF);
                        }
                    }
                }
                return compressor.encode(buf, 0, width, height, this.sampleSize, (tileRect.width + 7) / 8);
            }
            if (this.bitDepth == 8 && sm.getDataType() == 0) {
                ComponentSampleModel csm = (ComponentSampleModel)raster.getSampleModel();
                byte[] buf = ((DataBufferByte)raster.getDataBuffer()).getData();
                int off = csm.getOffset(minX - raster.getSampleModelTranslateX(), minY - raster.getSampleModelTranslateY());
                return compressor.encode(buf, off, width, height, this.sampleSize, csm.getScanlineStride());
            }
        }
        int xOffset = minX;
        int xSkip = this.periodX;
        int yOffset = minY;
        int ySkip = this.periodY;
        int hpixels = (width + xSkip - 1) / xSkip;
        int vpixels = (height + ySkip - 1) / ySkip;
        if (hpixels == 0 || vpixels == 0) {
            return 0;
        }
        xOffset *= this.numBands;
        xSkip *= this.numBands;
        int samplesPerByte = 8 / this.bitDepth;
        int numSamples = width * this.numBands;
        int bytesPerRow = hpixels * this.numBands;
        if (this.bitDepth < 8) {
            bytesPerRow = (bytesPerRow + samplesPerByte - 1) / samplesPerByte;
        } else if (this.bitDepth == 16) {
            bytesPerRow *= 2;
        } else if (this.bitDepth == 32) {
            bytesPerRow *= 4;
        }
        int[] samples = null;
        float[] fsamples = null;
        if (this.sampleFormat == 3) {
            fsamples = new float[numSamples];
        } else {
            samples = new int[numSamples];
        }
        byte[] currTile = new byte[bytesPerRow * vpixels];
        int tcount = 0;
        int activeMinX = activeRect.x;
        int activeMinY = activeRect.y;
        int activeMaxY = activeMinY + activeRect.height - 1;
        int activeWidth = activeRect.width;
        SampleModel rowSampleModel = null;
        if (isPadded) {
            rowSampleModel = this.image.getSampleModel().createCompatibleSampleModel(width, 1);
        }
        int row = yOffset;
        while (row < yOffset + height) {
            Raster ras = null;
            if (isPadded) {
                WritableRaster wr = Raster.createWritableRaster(rowSampleModel, new Point(minX, row));
                if (row >= activeMinY && row <= activeMaxY) {
                    Rectangle rect = new Rectangle(activeMinX, row, activeWidth, 1);
                    ras = this.image.getData(rect);
                    wr.setRect(ras);
                }
                ras = wr;
            } else {
                Rectangle rect = new Rectangle(minX, row, width, 1);
                ras = this.image.getData(rect);
            }
            if (this.sourceBands != null) {
                ras = ras.createChild(minX, row, width, 1, minX, row, this.sourceBands);
            }
            if (this.sampleFormat == 3) {
                ras.getPixels(minX, row, width, 1, fsamples);
            } else {
                ras.getPixels(minX, row, width, 1, samples);
                if (this.nativePhotometricInterpretation == 1 && this.photometricInterpretation == 0 || this.nativePhotometricInterpretation == 0 && this.photometricInterpretation == 1) {
                    int bitMask = (1 << this.bitDepth) - 1;
                    int s = 0;
                    while (s < numSamples) {
                        int n = s++;
                        samples[n] = samples[n] ^ bitMask;
                    }
                }
            }
            if (this.colorConverter != null) {
                int idx = 0;
                float[] result = new float[3];
                if (this.sampleFormat == 3) {
                    int i = 0;
                    while (i < width) {
                        float r = fsamples[idx];
                        float g = fsamples[idx + 1];
                        float b = fsamples[idx + 2];
                        this.colorConverter.fromRGB(r, g, b, result);
                        fsamples[idx] = result[0];
                        fsamples[idx + 1] = result[1];
                        fsamples[idx + 2] = result[2];
                        idx += 3;
                        ++i;
                    }
                } else {
                    int i = 0;
                    while (i < width) {
                        float r = samples[idx];
                        float g = samples[idx + 1];
                        float b = samples[idx + 2];
                        this.colorConverter.fromRGB(r, g, b, result);
                        samples[idx] = (int)result[0];
                        samples[idx + 1] = (int)result[1];
                        samples[idx + 2] = (int)result[2];
                        idx += 3;
                        ++i;
                    }
                }
            }
            int tmp = 0;
            int pos = 0;
            switch (this.bitDepth) {
                case 1: 
                case 2: 
                case 4: {
                    int s;
                    if (this.isRescaling) {
                        s = 0;
                        while (s < numSamples) {
                            byte val = this.scale0[samples[s]];
                            tmp = tmp << this.bitDepth | val;
                            if (++pos == samplesPerByte) {
                                currTile[tcount++] = (byte)tmp;
                                tmp = 0;
                                pos = 0;
                            }
                            s += xSkip;
                        }
                    } else {
                        s = 0;
                        while (s < numSamples) {
                            byte val = (byte)samples[s];
                            tmp = tmp << this.bitDepth | val;
                            if (++pos == samplesPerByte) {
                                currTile[tcount++] = (byte)tmp;
                                tmp = 0;
                                pos = 0;
                            }
                            s += xSkip;
                        }
                    }
                    if (pos == 0) break;
                    currTile[tcount++] = (byte)(tmp <<= (8 / this.bitDepth - pos) * this.bitDepth);
                    break;
                }
                case 8: {
                    int s;
                    if (this.numBands == 1) {
                        if (this.isRescaling) {
                            s = 0;
                            while (s < numSamples) {
                                currTile[tcount++] = this.scale0[samples[s]];
                                s += xSkip;
                            }
                        } else {
                            s = 0;
                            while (s < numSamples) {
                                currTile[tcount++] = (byte)samples[s];
                                s += xSkip;
                            }
                        }
                    } else if (this.isRescaling) {
                        s = 0;
                        while (s < numSamples) {
                            int b = 0;
                            while (b < this.numBands) {
                                currTile[tcount++] = this.scale[b][samples[s + b]];
                                ++b;
                            }
                            s += xSkip;
                        }
                    } else {
                        s = 0;
                        while (s < numSamples) {
                            int b = 0;
                            while (b < this.numBands) {
                                currTile[tcount++] = (byte)samples[s + b];
                                ++b;
                            }
                            s += xSkip;
                        }
                    }
                    break;
                }
                case 16: {
                    int s;
                    if (this.isRescaling) {
                        if (this.stream.getByteOrder() == ByteOrder.BIG_ENDIAN) {
                            s = 0;
                            while (s < numSamples) {
                                int b = 0;
                                while (b < this.numBands) {
                                    int sample = samples[s + b];
                                    currTile[tcount++] = this.scaleh[b][sample];
                                    currTile[tcount++] = this.scalel[b][sample];
                                    ++b;
                                }
                                s += xSkip;
                            }
                        } else {
                            s = 0;
                            while (s < numSamples) {
                                int b = 0;
                                while (b < this.numBands) {
                                    int sample = samples[s + b];
                                    currTile[tcount++] = this.scalel[b][sample];
                                    currTile[tcount++] = this.scaleh[b][sample];
                                    ++b;
                                }
                                s += xSkip;
                            }
                        }
                    } else if (this.stream.getByteOrder() == ByteOrder.BIG_ENDIAN) {
                        s = 0;
                        while (s < numSamples) {
                            int b = 0;
                            while (b < this.numBands) {
                                int sample = samples[s + b];
                                currTile[tcount++] = (byte)(sample >>> 8 & 0xFF);
                                currTile[tcount++] = (byte)(sample & 0xFF);
                                ++b;
                            }
                            s += xSkip;
                        }
                    } else {
                        s = 0;
                        while (s < numSamples) {
                            int b = 0;
                            while (b < this.numBands) {
                                int sample = samples[s + b];
                                currTile[tcount++] = (byte)(sample & 0xFF);
                                currTile[tcount++] = (byte)(sample >>> 8 & 0xFF);
                                ++b;
                            }
                            s += xSkip;
                        }
                    }
                    break;
                }
                case 32: {
                    int s;
                    if (this.sampleFormat == 3) {
                        float fsample;
                        if (this.stream.getByteOrder() == ByteOrder.BIG_ENDIAN) {
                            s = 0;
                            while (s < numSamples) {
                                int b = 0;
                                while (b < this.numBands) {
                                    fsample = fsamples[s + b];
                                    int isample = Float.floatToIntBits(fsample);
                                    currTile[tcount++] = (byte)((isample & 0xFF000000) >> 24);
                                    currTile[tcount++] = (byte)((isample & 0xFF0000) >> 16);
                                    currTile[tcount++] = (byte)((isample & 0xFF00) >> 8);
                                    currTile[tcount++] = (byte)(isample & 0xFF);
                                    ++b;
                                }
                                s += xSkip;
                            }
                        } else {
                            s = 0;
                            while (s < numSamples) {
                                int b = 0;
                                while (b < this.numBands) {
                                    fsample = fsamples[s + b];
                                    int isample = Float.floatToIntBits(fsample);
                                    currTile[tcount++] = (byte)(isample & 0xFF);
                                    currTile[tcount++] = (byte)((isample & 0xFF00) >> 8);
                                    currTile[tcount++] = (byte)((isample & 0xFF0000) >> 16);
                                    currTile[tcount++] = (byte)((isample & 0xFF000000) >> 24);
                                    ++b;
                                }
                                s += xSkip;
                            }
                        }
                    } else if (this.isRescaling) {
                        long sampleOut;
                        int b;
                        int s2;
                        long[] maxIn = new long[this.numBands];
                        long[] halfIn = new long[this.numBands];
                        long maxOut = (1L << (int)((long)this.bitDepth)) - 1L;
                        int b2 = 0;
                        while (b2 < this.numBands) {
                            maxIn[b2] = (1L << (int)((long)this.sampleSize[b2])) - 1L;
                            halfIn[b2] = maxIn[b2] / 2L;
                            ++b2;
                        }
                        if (this.stream.getByteOrder() == ByteOrder.BIG_ENDIAN) {
                            s2 = 0;
                            while (s2 < numSamples) {
                                b = 0;
                                while (b < this.numBands) {
                                    sampleOut = ((long)samples[s2 + b] * maxOut + halfIn[b]) / maxIn[b];
                                    currTile[tcount++] = (byte)((sampleOut & 0xFFFFFFFFFF000000L) >> 24);
                                    currTile[tcount++] = (byte)((sampleOut & 0xFF0000L) >> 16);
                                    currTile[tcount++] = (byte)((sampleOut & 0xFF00L) >> 8);
                                    currTile[tcount++] = (byte)(sampleOut & 0xFFL);
                                    ++b;
                                }
                                s2 += xSkip;
                            }
                        } else {
                            s2 = 0;
                            while (s2 < numSamples) {
                                b = 0;
                                while (b < this.numBands) {
                                    sampleOut = ((long)samples[s2 + b] * maxOut + halfIn[b]) / maxIn[b];
                                    currTile[tcount++] = (byte)(sampleOut & 0xFFL);
                                    currTile[tcount++] = (byte)((sampleOut & 0xFF00L) >> 8);
                                    currTile[tcount++] = (byte)((sampleOut & 0xFF0000L) >> 16);
                                    currTile[tcount++] = (byte)((sampleOut & 0xFFFFFFFFFF000000L) >> 24);
                                    ++b;
                                }
                                s2 += xSkip;
                            }
                        }
                    } else if (this.stream.getByteOrder() == ByteOrder.BIG_ENDIAN) {
                        s = 0;
                        while (s < numSamples) {
                            int b = 0;
                            while (b < this.numBands) {
                                int isample = samples[s + b];
                                currTile[tcount++] = (byte)((isample & 0xFF000000) >> 24);
                                currTile[tcount++] = (byte)((isample & 0xFF0000) >> 16);
                                currTile[tcount++] = (byte)((isample & 0xFF00) >> 8);
                                currTile[tcount++] = (byte)(isample & 0xFF);
                                ++b;
                            }
                            s += xSkip;
                        }
                    } else {
                        s = 0;
                        while (s < numSamples) {
                            int b = 0;
                            while (b < this.numBands) {
                                int isample = samples[s + b];
                                currTile[tcount++] = (byte)(isample & 0xFF);
                                currTile[tcount++] = (byte)((isample & 0xFF00) >> 8);
                                currTile[tcount++] = (byte)((isample & 0xFF0000) >> 16);
                                currTile[tcount++] = (byte)((isample & 0xFF000000) >> 24);
                                ++b;
                            }
                            s += xSkip;
                        }
                    }
                    break;
                }
            }
            row += ySkip;
        }
        int[] bitsPerSample = new int[this.numBands];
        int i = 0;
        while (i < bitsPerSample.length) {
            bitsPerSample[i] = this.bitDepth;
            ++i;
        }
        int byteCount = compressor.encode(currTile, 0, hpixels, vpixels, bitsPerSample, bytesPerRow);
        return byteCount;
    }

    private boolean equals(int[] s0, int[] s1) {
        if (s0 == null || s1 == null) {
            return false;
        }
        if (s0.length != s1.length) {
            return false;
        }
        int i = 0;
        while (i < s0.length) {
            if (s0[i] != s1[i]) {
                return false;
            }
            ++i;
        }
        return true;
    }

    private void initializeScaleTables(int[] sampleSize) {
        if (this.bitDepth == this.scalingBitDepth && this.equals(sampleSize, this.sampleSize)) {
            return;
        }
        if (this.bitDepth <= 16) {
            int b = 0;
            while (b < this.numBands) {
                if (sampleSize[b] != this.bitDepth) {
                    this.isRescaling = true;
                    break;
                }
                ++b;
            }
        } else {
            this.isRescaling = false;
        }
        if (!this.isRescaling) {
            this.sampleSize = sampleSize;
            return;
        }
        this.sampleSize = sampleSize;
        this.scalingBitDepth = this.bitDepth;
        int maxOutSample = (1 << this.bitDepth) - 1;
        if (this.bitDepth <= 8) {
            this.scale = new byte[this.numBands][];
            int b = 0;
            while (b < this.numBands) {
                int maxInSample = (1 << sampleSize[b]) - 1;
                int halfMaxInSample = maxInSample / 2;
                this.scale[b] = new byte[maxInSample + 1];
                int s = 0;
                while (s <= maxInSample) {
                    this.scale[b][s] = (byte)((s * maxOutSample + halfMaxInSample) / maxInSample);
                    ++s;
                }
                ++b;
            }
            this.scale0 = this.scale[0];
            this.scalel = null;
            this.scaleh = null;
        } else if (this.bitDepth <= 16) {
            this.scaleh = new byte[this.numBands][];
            this.scalel = new byte[this.numBands][];
            int b = 0;
            while (b < this.numBands) {
                int maxInSample = (1 << sampleSize[b]) - 1;
                int halfMaxInSample = maxInSample / 2;
                this.scaleh[b] = new byte[maxInSample + 1];
                this.scalel[b] = new byte[maxInSample + 1];
                int s = 0;
                while (s <= maxInSample) {
                    int val = (s * maxOutSample + halfMaxInSample) / maxInSample;
                    this.scaleh[b][s] = (byte)(val >> 8);
                    this.scalel[b][s] = (byte)(val & 0xFF);
                    ++s;
                }
                ++b;
            }
            this.scale = null;
            this.scale0 = null;
        }
    }

    public void write(IIOMetadata sm, IIOImage iioimage, ImageWriteParam p) throws IOException {
        this.write(sm, iioimage, p, true);
    }

    private void writeHeader() throws IOException {
        this.byteOrder = this.streamMetadata != null ? this.streamMetadata.byteOrder : ByteOrder.BIG_ENDIAN;
        this.stream.setByteOrder(this.byteOrder);
        if (this.byteOrder == ByteOrder.BIG_ENDIAN) {
            this.stream.writeShort(19789);
        } else {
            this.stream.writeShort(18761);
        }
        this.stream.writeShort(42);
        this.stream.writeInt((int)(this.headerPosition + 8L));
    }

    private void write(IIOMetadata sm, IIOImage iioimage, ImageWriteParam p, boolean writeHeader) throws IOException {
        if (this.stream == null) {
            throw new IllegalStateException("output == null!");
        }
        if (iioimage == null) {
            throw new IllegalArgumentException("image == null!");
        }
        this.image = iioimage.getRenderedImage();
        SampleModel sampleModel = this.image.getSampleModel();
        ColorModel colorModel = this.image.getColorModel();
        this.numBands = sampleModel.getNumBands();
        this.imageType = new ImageTypeSpecifier(this.image);
        ImageUtil.canEncodeImage(this, this.imageType);
        this.sourceXOffset = this.image.getMinX();
        this.sourceYOffset = this.image.getMinY();
        this.sourceWidth = this.image.getWidth();
        this.sourceHeight = this.image.getHeight();
        Rectangle imageBounds = new Rectangle(this.sourceXOffset, this.sourceYOffset, this.sourceWidth, this.sourceHeight);
        if (p == null) {
            this.param = this.getDefaultWriteParam();
            this.sourceBands = null;
            this.periodX = 1;
            this.periodY = 1;
        } else {
            this.param = p;
            Rectangle sourceRegion = this.param.getSourceRegion();
            if (sourceRegion != null) {
                sourceRegion = sourceRegion.intersection(imageBounds);
                this.sourceXOffset = sourceRegion.x;
                this.sourceYOffset = sourceRegion.y;
                this.sourceWidth = sourceRegion.width;
                this.sourceHeight = sourceRegion.height;
            }
            int gridX = this.param.getSubsamplingXOffset();
            int gridY = this.param.getSubsamplingYOffset();
            this.sourceXOffset += gridX;
            this.sourceYOffset += gridY;
            this.sourceWidth -= gridX;
            this.sourceHeight -= gridY;
            this.periodX = this.param.getSourceXSubsampling();
            this.periodY = this.param.getSourceYSubsampling();
            int[] sBands = this.param.getSourceBands();
            if (sBands != null) {
                this.sourceBands = sBands;
                this.numBands = this.sourceBands.length;
            }
        }
        int destWidth = (this.sourceWidth + this.periodX - 1) / this.periodX;
        int destHeight = (this.sourceHeight + this.periodY - 1) / this.periodY;
        if (destWidth <= 0 || destHeight <= 0) {
            throw new IllegalArgumentException("Empty source region!");
        }
        this.clearAbortRequest();
        this.processImageStarted(0);
        sm = this.convertStreamMetadata(sm, this.param);
        this.streamMetadata = sm instanceof TIFFStreamMetadata ? (TIFFStreamMetadata)sm : (TIFFStreamMetadata)this.getDefaultStreamMetadata(this.param);
        if (writeHeader) {
            this.writeHeader();
        }
        IIOMetadata im = iioimage.getMetadata();
        this.imageMetadata = (im = this.convertImageMetadata(im, this.imageType, this.param)) instanceof TIFFImageMetadata ? ((TIFFImageMetadata)im).getShallowClone() : (TIFFImageMetadata)this.getDefaultImageMetadata(this.imageType, this.param);
        this.setupMetadata(destWidth, destHeight);
        this.compressor.setWriter(this);
        this.compressor.setMetadata(this.imageMetadata);
        this.compressor.setStream(this.stream);
        int[] sampleSize = sampleModel.getSampleSize();
        this.initializeScaleTables(colorModel == null || colorModel instanceof IndexColorModel ? sampleModel.getSampleSize() : colorModel.getComponentSize());
        this.isBilevel = ImageUtil.isBinary(this.image.getSampleModel());
        this.isInverted = this.nativePhotometricInterpretation == 1 && this.photometricInterpretation == 0 || this.nativePhotometricInterpretation == 0 && this.photometricInterpretation == 1;
        this.isImageSimple = (this.isBilevel || !this.isInverted && ImageUtil.imageIsContiguous(this.image)) && !this.isRescaling && this.sourceBands == null && this.periodX == 1 && this.periodY == 1 && this.colorConverter == null;
        TIFFIFD rootIFD = this.imageMetadata.getRootIFD();
        rootIFD.writeToStream(this.stream);
        this.nextIFDPointerPos = this.stream.getStreamPosition();
        this.stream.writeInt(0);
        this.stream.seek(rootIFD.getLastPosition());
        int stripOrTileByteCountsPosition = rootIFD.getStripOrTileByteCountsPosition();
        int stripOrTileOffsetsPosition = rootIFD.getStripOrTileOffsetsPosition();
        this.totalPixels = this.tileWidth * this.tileLength * this.tilesDown * this.tilesAcross;
        this.pixelsDone = 0;
        int tj = 0;
        while (tj < this.tilesDown) {
            int ti = 0;
            while (ti < this.tilesAcross) {
                long pos = this.stream.getStreamPosition();
                Rectangle tileRect = new Rectangle(this.sourceXOffset + ti * this.tileWidth * this.periodX, this.sourceYOffset + tj * this.tileLength * this.periodY, this.tileWidth * this.periodX, this.tileLength * this.periodY);
                try {
                    int byteCount = this.writeTile(tileRect, this.compressor);
                    this.pixelsDone += tileRect.width * tileRect.height;
                    this.processImageProgress(100.0f * (float)this.pixelsDone / (float)this.totalPixels);
                    this.stream.mark();
                    this.stream.seek(stripOrTileOffsetsPosition);
                    this.stream.writeInt((int)pos);
                    stripOrTileOffsetsPosition += 4;
                    this.stream.seek(stripOrTileByteCountsPosition);
                    this.stream.writeInt(byteCount);
                    stripOrTileByteCountsPosition += 4;
                    this.stream.reset();
                }
                catch (IOException e) {
                    throw new IIOException("I/O error writing TIFF file!", e);
                }
                if (this.abortRequested()) {
                    this.processWriteAborted();
                }
                ++ti;
            }
            ++tj;
        }
        this.processImageComplete();
    }

    public boolean canWriteSequence() {
        return true;
    }

    public void prepareWriteSequence(IIOMetadata streamMetadata) throws IOException {
        if (streamMetadata != null && streamMetadata instanceof TIFFStreamMetadata) {
            this.streamMetadata = (TIFFStreamMetadata)streamMetadata;
        }
        this.writeHeader();
    }

    public void writeToSequence(IIOImage image, ImageWriteParam param) throws IOException {
        this.writeInsert(-1, image, param);
    }

    public void endWriteSequence() throws IOException {
    }

    public boolean canInsertImage(int imageIndex) throws IOException {
        if (this.getOutput() == null) {
            throw new IllegalStateException("getOutput() == null!");
        }
        return true;
    }

    private void locateIFD(int imageIndex, long[] ifdpos, long[] ifd) throws IOException {
        this.stream.seek(this.headerPosition);
        int byteOrder = this.stream.readUnsignedShort();
        if (byteOrder == 19789) {
            this.stream.setByteOrder(ByteOrder.BIG_ENDIAN);
        } else if (byteOrder == 18761) {
            this.stream.setByteOrder(ByteOrder.LITTLE_ENDIAN);
        }
        if (this.stream.readUnsignedShort() != 42) {
            // empty if block
        }
        ifdpos[0] = this.stream.getStreamPosition();
        ifd[0] = this.stream.readUnsignedInt();
        this.stream.seek(ifd[0]);
        int i = 0;
        while (imageIndex == -1 || i < imageIndex) {
            short numFields;
            try {
                numFields = this.stream.readShort();
            }
            catch (EOFException eof) {
                ifd[0] = 0L;
                return;
            }
            this.stream.skipBytes(12 * numFields);
            ifdpos[0] = this.stream.getStreamPosition();
            ifd[0] = this.stream.readUnsignedInt();
            if (ifd[0] == 0L) {
                if (imageIndex == -1 || i >= imageIndex - 1) break;
                throw new IndexOutOfBoundsException("imageIndex is greater than the largest available index!");
            }
            this.stream.seek(ifd[0]);
            ++i;
        }
    }

    public void writeInsert(int imageIndex, IIOImage image, ImageWriteParam param) throws IOException {
        if (this.stream == null) {
            throw new IllegalStateException("Output not set!");
        }
        if (image == null) {
            throw new IllegalArgumentException("image == null!");
        }
        if (imageIndex < -1) {
            throw new IllegalArgumentException("imageIndex < -1!");
        }
        this.stream.mark();
        long[] ifdpos = new long[1];
        long[] ifd = new long[1];
        this.locateIFD(imageIndex, ifdpos, ifd);
        long streamLength = this.stream.length();
        this.stream.seek(ifdpos[0]);
        this.stream.writeInt((int)streamLength);
        this.stream.seek(streamLength);
        this.write(null, image, param, false);
        this.stream.seek(this.nextIFDPointerPos);
        this.stream.writeInt((int)ifd[0]);
        this.stream.reset();
    }

    private TIFFIFD readIFD(int imageIndex) throws IOException {
        if (this.stream == null) {
            throw new IllegalStateException("Output not set!");
        }
        if (imageIndex < 0) {
            throw new IndexOutOfBoundsException("imageIndex < 0!");
        }
        this.stream.mark();
        long[] ifdpos = new long[1];
        long[] ifd = new long[1];
        this.locateIFD(imageIndex, ifdpos, ifd);
        if (ifd[0] == 0L) {
            throw new IndexOutOfBoundsException("imageIndex out of bounds!");
        }
        ArrayList<BaselineTIFFTagSet> tagSets = new ArrayList<BaselineTIFFTagSet>(1);
        tagSets.add(BaselineTIFFTagSet.getInstance());
        TIFFIFD rootIFD = new TIFFIFD(tagSets);
        rootIFD.initialize(this.stream, true);
        this.stream.reset();
        return rootIFD;
    }

    public boolean canReplacePixels(int imageIndex) throws IOException {
        TIFFIFD rootIFD = this.readIFD(imageIndex);
        TIFFField f = rootIFD.getTIFFField(259);
        int compression = f.getAsInt(0);
        return compression == 1;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void prepareReplacePixels(int imageIndex, Rectangle region) throws IOException {
        Object object = this.replacePixelsLock;
        synchronized (object) {
            if (this.stream == null) {
                throw new IllegalStateException("Output not set!");
            }
            if (region == null) {
                throw new IllegalArgumentException("region == null!");
            }
            if (region.getWidth() < 1.0) {
                throw new IllegalArgumentException("region.getWidth() < 1!");
            }
            if (region.getHeight() < 1.0) {
                throw new IllegalArgumentException("region.getHeight() < 1!");
            }
            if (this.inReplacePixelsNest) {
                throw new IllegalStateException("In nested call to prepareReplacePixels!");
            }
            TIFFIFD replacePixelsIFD = this.readIFD(imageIndex);
            TIFFField f = replacePixelsIFD.getTIFFField(259);
            int compression = f.getAsInt(0);
            if (compression != 1) {
                throw new UnsupportedOperationException("canReplacePixels(imageIndex) == false!");
            }
            f = replacePixelsIFD.getTIFFField(256);
            if (f == null) {
                throw new IIOException("Cannot read ImageWidth field.");
            }
            int w = f.getAsInt(0);
            f = replacePixelsIFD.getTIFFField(257);
            if (f == null) {
                throw new IIOException("Cannot read ImageHeight field.");
            }
            int h = f.getAsInt(0);
            Rectangle bounds = new Rectangle(0, 0, w, h);
            if ((region = region.intersection(bounds)).isEmpty()) {
                throw new IIOException("Region does not intersect image bounds");
            }
            this.replacePixelsRegion = region;
            f = replacePixelsIFD.getTIFFField(324);
            if (f == null) {
                f = replacePixelsIFD.getTIFFField(273);
            }
            this.replacePixelsTileOffsets = f.getAsLongs();
            this.replacePixelsMetadata = new TIFFImageMetadata(replacePixelsIFD);
            this.replacePixelsIndex = imageIndex;
            this.inReplacePixelsNest = true;
        }
    }

    private Raster subsample(Raster raster, int[] sourceBands, int subOriginX, int subOriginY, int subPeriodX, int subPeriodY, int dstOffsetX, int dstOffsetY, Rectangle target) {
        int x = raster.getMinX();
        int y = raster.getMinY();
        int w = raster.getWidth();
        int h = raster.getHeight();
        int b = raster.getSampleModel().getNumBands();
        int t = raster.getSampleModel().getDataType();
        int outMinX = TIFFImageWriter.XToTileX(x, subOriginX, subPeriodX) + dstOffsetX;
        int outMinY = TIFFImageWriter.YToTileY(y, subOriginY, subPeriodY) + dstOffsetY;
        int outMaxX = TIFFImageWriter.XToTileX(x + w - 1, subOriginX, subPeriodX) + dstOffsetX;
        int outMaxY = TIFFImageWriter.YToTileY(y + h - 1, subOriginY, subPeriodY) + dstOffsetY;
        int outWidth = outMaxX - outMinX + 1;
        int outHeight = outMaxY - outMinY + 1;
        if (outWidth <= 0 || outHeight <= 0) {
            return null;
        }
        int inMinX = (outMinX - dstOffsetX) * subPeriodX + subOriginX;
        int inMaxX = (outMaxX - dstOffsetX) * subPeriodX + subOriginX;
        int inWidth = inMaxX - inMinX + 1;
        int inMinY = (outMinY - dstOffsetY) * subPeriodY + subOriginY;
        int inMaxY = (outMaxY - dstOffsetY) * subPeriodY + subOriginY;
        int inHeight = inMaxY - inMinY + 1;
        WritableRaster wr = raster.createCompatibleWritableRaster(outMinX, outMinY, outWidth, outHeight);
        int jMax = inMinY + inHeight;
        if (t == 4 || t == 5) {
            float[] fsamples = new float[inWidth];
            float[] fsubsamples = new float[outWidth];
            int k = 0;
            while (k < b) {
                int outY = outMinY;
                int j = inMinY;
                while (j < jMax) {
                    raster.getSamples(inMinX, j, inWidth, 1, k, fsamples);
                    int s = 0;
                    int i = 0;
                    while (i < inWidth) {
                        fsubsamples[s++] = fsamples[i];
                        i += subPeriodX;
                    }
                    wr.setSamples(outMinX, outY++, outWidth, 1, k, fsubsamples);
                    j += subPeriodY;
                }
                ++k;
            }
        } else {
            int[] samples = new int[inWidth];
            int[] subsamples = new int[outWidth];
            int k = 0;
            while (k < b) {
                int outY = outMinY;
                int j = inMinY;
                while (j < jMax) {
                    raster.getSamples(inMinX, j, inWidth, 1, k, samples);
                    int s = 0;
                    int i = 0;
                    while (i < inWidth) {
                        subsamples[s++] = samples[i];
                        i += subPeriodX;
                    }
                    wr.setSamples(outMinX, outY++, outWidth, 1, k, subsamples);
                    j += subPeriodY;
                }
                ++k;
            }
        }
        return wr.createChild(outMinX, outMinY, target.width, target.height, target.x, target.y, sourceBands);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void replacePixels(RenderedImage image, ImageWriteParam param) throws IOException {
        Object object = this.replacePixelsLock;
        synchronized (object) {
            TIFFField f;
            if (this.stream == null) {
                throw new IllegalStateException("stream == null!");
            }
            if (image == null) {
                throw new IllegalArgumentException("image == null!");
            }
            if (!this.inReplacePixelsNest) {
                throw new IllegalStateException("No previous call to prepareReplacePixels!");
            }
            if (param == null) {
                param = this.getDefaultWriteParam();
            }
            if ((f = this.replacePixelsMetadata.getTIFFField(258)) == null) {
                throw new IIOException("Cannot read destination BitsPerSample");
            }
            int[] dstBitsPerSample = f.getAsInts();
            int[] srcBitsPerSample = image.getSampleModel().getSampleSize();
            int[] sourceBands = param.getSourceBands();
            if (sourceBands != null) {
                if (sourceBands.length != dstBitsPerSample.length) {
                    throw new IIOException("Source and destination have different SamplesPerPixel");
                }
                int i = 0;
                while (i < sourceBands.length) {
                    if (dstBitsPerSample[i] != srcBitsPerSample[sourceBands[i]]) {
                        throw new IIOException("Source and destination have different BitsPerSample");
                    }
                    ++i;
                }
            } else {
                int srcNumBands = image.getSampleModel().getNumBands();
                if (srcNumBands != dstBitsPerSample.length) {
                    throw new IIOException("Source and destination have different SamplesPerPixel");
                }
                int i = 0;
                while (i < srcNumBands) {
                    if (dstBitsPerSample[i] != srcBitsPerSample[i]) {
                        throw new IIOException("Source and destination have different BitsPerSample");
                    }
                    ++i;
                }
            }
            Rectangle srcImageBounds = new Rectangle(image.getMinX(), image.getMinY(), image.getWidth(), image.getHeight());
            Rectangle srcRect = param.getSourceRegion();
            if (srcRect == null) {
                srcRect = srcImageBounds;
            }
            int subPeriodX = param.getSourceXSubsampling();
            int subPeriodY = param.getSourceYSubsampling();
            int subOriginX = param.getSubsamplingXOffset() + srcRect.x;
            int subOriginY = param.getSubsamplingYOffset() + srcRect.y;
            if (!srcRect.equals(srcImageBounds) && (srcRect = srcRect.intersection(srcImageBounds)).isEmpty()) {
                throw new IllegalArgumentException("Source region does not intersect source image!");
            }
            Point dstOffset = param.getDestinationOffset();
            int dMinX = TIFFImageWriter.XToTileX(srcRect.x, subOriginX, subPeriodX) + dstOffset.x;
            int dMinY = TIFFImageWriter.YToTileY(srcRect.y, subOriginY, subPeriodY) + dstOffset.y;
            int dMaxX = TIFFImageWriter.XToTileX(srcRect.x + srcRect.width - 1, subOriginX, subPeriodX) + dstOffset.x;
            int dMaxY = TIFFImageWriter.YToTileY(srcRect.y + srcRect.height - 1, subOriginY, subPeriodY) + dstOffset.y;
            Rectangle dstRect = new Rectangle(dstOffset.x, dstOffset.y, dMaxX - dMinX + 1, dMaxY - dMinY + 1);
            if ((dstRect = dstRect.intersection(this.replacePixelsRegion)).isEmpty()) {
                throw new IllegalArgumentException("Forward mapped source region does not intersect destination region!");
            }
            int activeSrcMinX = (dstRect.x - dstOffset.x) * subPeriodX + subOriginX;
            int activeSrcMinY = (dstRect.y - dstOffset.y) * subPeriodY + subOriginY;
            int sxmax = (dstRect.x + dstRect.width - 1 - dstOffset.x) * subPeriodX + subOriginX;
            int activeSrcWidth = sxmax - activeSrcMinX + 1;
            int symax = (dstRect.y + dstRect.height - 1 - dstOffset.y) * subPeriodY + subOriginY;
            int activeSrcHeight = symax - activeSrcMinY + 1;
            Rectangle activeSrcRect = new Rectangle(activeSrcMinX, activeSrcMinY, activeSrcWidth, activeSrcHeight);
            if (activeSrcRect.intersection(srcImageBounds).isEmpty()) {
                throw new IllegalArgumentException("Backward mapped destination region does not intersect source image!");
            }
            if (this.reader == null) {
                this.reader = new TIFFImageReader(new TIFFImageReaderSpi());
            } else {
                this.reader.reset();
            }
            this.stream.mark();
            try {
                this.stream.seek(this.headerPosition);
                this.reader.setInput(this.stream);
                this.imageMetadata = this.replacePixelsMetadata;
                this.param = param;
                SampleModel sm = image.getSampleModel();
                ColorModel cm = image.getColorModel();
                this.numBands = sm.getNumBands();
                this.periodX = param.getSourceXSubsampling();
                this.periodY = param.getSourceYSubsampling();
                this.sourceBands = null;
                int[] sBands = param.getSourceBands();
                if (sBands != null) {
                    this.sourceBands = sBands;
                    this.numBands = sourceBands.length;
                }
                int[] scaleSampleSize = cm == null || cm instanceof IndexColorModel ? sm.getSampleSize() : cm.getComponentSize();
                this.initializeScaleTables(scaleSampleSize);
                this.setupMetadata(this.reader.getWidth(this.replacePixelsIndex), this.reader.getHeight(this.replacePixelsIndex));
                int minTileX = TIFFImageWriter.XToTileX(dstRect.x, 0, this.tileWidth);
                int minTileY = TIFFImageWriter.YToTileY(dstRect.y, 0, this.tileLength);
                int maxTileX = TIFFImageWriter.XToTileX(dstRect.x + dstRect.width - 1, 0, this.tileWidth);
                int maxTileY = TIFFImageWriter.YToTileY(dstRect.y + dstRect.height - 1, 0, this.tileLength);
                TIFFNullCompressor encoder = new TIFFNullCompressor();
                encoder.setWriter(this);
                encoder.setStream(this.stream);
                encoder.setMetadata(this.imageMetadata);
                Rectangle tileRect = new Rectangle();
                int ty = minTileY;
                while (ty <= maxTileY) {
                    int tx = minTileX;
                    while (tx <= maxTileX) {
                        block35: {
                            Raster replacementData;
                            WritableRaster raster;
                            block34: {
                                Rectangle replacementRect;
                                block33: {
                                    BufferedImage tileImage = this.reader.readTile(this.replacePixelsIndex, tx, ty);
                                    tileRect.setLocation(tx * this.tileWidth, ty * this.tileLength);
                                    tileRect.setSize(tileImage.getWidth(), tileImage.getHeight());
                                    raster = tileImage.getRaster();
                                    raster = raster.createWritableTranslatedChild(tileRect.x, tileRect.y);
                                    replacementRect = tileRect.intersection(dstRect);
                                    int srcMinX = (replacementRect.x - dstOffset.x) * subPeriodX + subOriginX;
                                    int srcXmax = (replacementRect.x + replacementRect.width - 1 - dstOffset.x) * subPeriodX + subOriginX;
                                    int srcWidth = srcXmax - srcMinX + 1;
                                    int srcMinY = (replacementRect.y - dstOffset.y) * subPeriodY + subOriginY;
                                    int srcYMax = (replacementRect.y + replacementRect.height - 1 - dstOffset.y) * subPeriodY + subOriginY;
                                    int srcHeight = srcYMax - srcMinY + 1;
                                    Rectangle srcTileRect = new Rectangle(srcMinX, srcMinY, srcWidth, srcHeight);
                                    replacementData = image.getData(srcTileRect);
                                    if (subPeriodX != 1 || subPeriodY != 1 || subOriginX != 0 || subOriginY != 0) break block33;
                                    replacementData = replacementData.createChild(srcTileRect.x, srcTileRect.y, srcTileRect.width, srcTileRect.height, replacementRect.x, replacementRect.y, sourceBands);
                                    break block34;
                                }
                                if ((replacementData = this.subsample(replacementData, sourceBands, subOriginX, subOriginY, subPeriodX, subPeriodY, dstOffset.x, dstOffset.y, replacementRect)) == null) break block35;
                            }
                            raster.setRect(replacementData);
                            this.stream.seek(this.replacePixelsTileOffsets[ty * this.tilesAcross + tx]);
                            this.image = new SingleTileRenderedImage(raster, cm);
                            this.writeTile(tileRect, encoder);
                        }
                        ++tx;
                    }
                    ++ty;
                }
                Object var51_53 = null;
            }
            catch (Throwable throwable) {
                Object var51_54 = null;
                this.stream.reset();
                throw throwable;
            }
            this.stream.reset();
        }
    }

    public void replacePixels(Raster raster, ImageWriteParam param) throws IOException {
        if (raster == null) {
            throw new IllegalArgumentException("raster == null!");
        }
        this.replacePixels(new SingleTileRenderedImage(raster, this.image.getColorModel()), param);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void endReplacePixels() throws IOException {
        Object object = this.replacePixelsLock;
        synchronized (object) {
            this.replacePixelsIndex = -1;
            this.replacePixelsMetadata = null;
            this.replacePixelsTileOffsets = null;
            this.replacePixelsRegion = null;
            this.inReplacePixelsNest = false;
        }
    }

    public void reset() {
        super.reset();
        this.stream = null;
        this.image = null;
        this.imageType = null;
        this.byteOrder = null;
        this.param = null;
        this.compressor = null;
        this.colorConverter = null;
        this.streamMetadata = null;
        this.imageMetadata = null;
        this.replacePixelsIndex = -1;
        this.replacePixelsMetadata = null;
        this.replacePixelsTileOffsets = null;
        this.replacePixelsRegion = null;
        this.inReplacePixelsNest = false;
    }

    static {
        DEBUG = false;
        DEFAULT_BYTES_PER_STRIP = 8192;
        TIFFCompressionTypes = new String[]{"CCITT RLE", "CCITT T.4", "CCITT T.6", "JPEG", "ZLib", "PackBits", "Deflate"};
        compressionTypes = new String[]{"CCITT RLE", "CCITT T.4", "CCITT T.6", "LZW", "Old JPEG", "JPEG", "ZLib", "PackBits", "Deflate"};
        isCompressionLossless = new boolean[]{true, true, true, true, false, false, true, true, true};
        compressionNumbers = new int[]{2, 3, 4, 5, 6, 7, 8, 32773, 32946};
    }
}

