/*
 * Decompiled with CFR 0.152.
 */
package com.sun.media.jai.operator;

import com.sun.media.jai.operator.I18N;
import com.sun.media.jai.operator.ImageReadPropertyGenerator;
import java.awt.RenderingHints;
import java.awt.image.renderable.ParameterBlock;
import java.io.File;
import java.net.Socket;
import java.util.Collection;
import java.util.EventListener;
import java.util.Locale;
import javax.imageio.ImageReadParam;
import javax.imageio.ImageReader;
import javax.imageio.stream.ImageInputStream;
import javax.media.jai.JAI;
import javax.media.jai.OperationDescriptor;
import javax.media.jai.OperationDescriptorImpl;
import javax.media.jai.PropertyGenerator;
import javax.media.jai.RenderableOp;
import javax.media.jai.RenderedOp;

public class ImageReadDescriptor
extends OperationDescriptorImpl {
    public static final String PROPERTY_NAME_IMAGE_READ_PARAM = "JAI.ImageReadParam";
    public static final String PROPERTY_NAME_IMAGE_READER = "JAI.ImageReader";
    public static final String PROPERTY_NAME_METADATA_IMAGE = "JAI.ImageMetadata";
    public static final String PROPERTY_NAME_METADATA_STREAM = "JAI.StreamMetadata";
    public static final String PROPERTY_NAME_THUMBNAILS = "JAI.Thumbnails";
    public static final String PROPERTY_NAME_RENDERABLE_INPUT = "JAI.RenderableInput";
    private static final String OPERATION_NAME = "ImageRead";
    private static final String[][] resources;
    private static final String[] paramNames;
    private static final Class[] renderedParamClasses;
    private static final Object[] renderedParamDefaults;
    private static final Class[] renderableParamClasses;
    private static final Object[] renderableParamDefaults;
    private static final Class[] collectionParamClasses;
    private static final Object[] collectionParamDefaults;
    static /* synthetic */ Class class$java$lang$Object;
    static /* synthetic */ Class class$java$lang$Integer;
    static /* synthetic */ Class class$java$lang$Boolean;
    static /* synthetic */ Class array$Ljava$util$EventListener;
    static /* synthetic */ Class class$java$util$Locale;
    static /* synthetic */ Class class$javax$imageio$ImageReadParam;
    static /* synthetic */ Class class$javax$imageio$ImageReader;
    static /* synthetic */ Class array$I;

    public ImageReadDescriptor() {
        super(resources, new String[]{"rendered", "renderable", "collection"}, null, (Class[][])new Class[][]{null, null, null}, paramNames, (Class[][])new Class[][]{renderedParamClasses, renderableParamClasses, collectionParamClasses}, (Object[][])new Object[][]{renderedParamDefaults, renderableParamDefaults, collectionParamDefaults}, (Object[][])new Object[][]{null, null, null});
    }

    public static RenderedOp create(ImageInputStream input, Integer imageChoice, Boolean readMetadata, Boolean readThumbnails, Boolean verifyInput, EventListener[] listeners, Locale locale, ImageReadParam readParam, ImageReader reader, RenderingHints hints) {
        ParameterBlock args = new ParameterBlock();
        args.add(input);
        args.add(imageChoice);
        args.add(readMetadata);
        args.add(readThumbnails);
        args.add(verifyInput);
        args.add(listeners);
        args.add(locale);
        args.add(readParam);
        args.add(reader);
        return JAI.create((String)OPERATION_NAME, (ParameterBlock)args, (RenderingHints)hints);
    }

    public static Collection createCollection(ImageInputStream input, int[] imageChoice, Boolean readMetadata, Boolean readThumbnails, Boolean verifyInput, EventListener[] listeners, Locale locale, ImageReadParam readParam, ImageReader reader, RenderingHints hints) {
        ParameterBlock args = new ParameterBlock();
        args.add(input);
        args.add(imageChoice);
        args.add(readMetadata);
        args.add(readThumbnails);
        args.add(verifyInput);
        args.add(listeners);
        args.add(locale);
        args.add(readParam);
        args.add(reader);
        return JAI.createCollection((String)OPERATION_NAME, (ParameterBlock)args, (RenderingHints)hints);
    }

    public static RenderableOp createRenderable(ImageInputStream input, int[] imageChoice, Boolean readMetadata, Boolean readThumbnails, Boolean verifyInput, EventListener[] listeners, Locale locale, ImageReadParam readParam, ImageReader reader, RenderingHints hints) {
        ParameterBlock args = new ParameterBlock();
        args.add(input);
        args.add(imageChoice);
        args.add(readMetadata);
        args.add(readThumbnails);
        args.add(verifyInput);
        args.add(listeners);
        args.add(locale);
        args.add(readParam);
        args.add(reader);
        return JAI.createRenderable((String)OPERATION_NAME, (ParameterBlock)args, (RenderingHints)hints);
    }

    public PropertyGenerator[] getPropertyGenerators(String modeName) {
        PropertyGenerator[] propertyGeneratorArray;
        if (modeName.equalsIgnoreCase("renderable")) {
            PropertyGenerator[] propertyGeneratorArray2 = new PropertyGenerator[1];
            propertyGeneratorArray = propertyGeneratorArray2;
            propertyGeneratorArray2[0] = new ImageReadPropertyGenerator();
        } else {
            propertyGeneratorArray = null;
        }
        return propertyGeneratorArray;
    }

    protected boolean validateParameters(String modeName, ParameterBlock args, StringBuffer msg) {
        Boolean verifyInput;
        if (!super.validateParameters(modeName, args, msg)) {
            return false;
        }
        if (modeName.equalsIgnoreCase("rendered")) {
            if (args.getIntParameter(1) < 0) {
                msg.append(I18N.getString("ImageReadDescriptor10"));
                return false;
            }
        } else {
            int[] imageIndices = (int[])args.getObjectParameter(1);
            if (imageIndices != null) {
                int i = 0;
                while (i < imageIndices.length) {
                    if (imageIndices[i] < 0) {
                        msg.append(I18N.getString("ImageReadDescriptor10"));
                        return false;
                    }
                    ++i;
                }
            }
        }
        if ((verifyInput = (Boolean)args.getObjectParameter(4)).booleanValue()) {
            Object input = args.getObjectParameter(0);
            if (input instanceof File || input instanceof String) {
                File file = null;
                String path = null;
                if (input instanceof File) {
                    file = (File)input;
                    path = file.getPath();
                } else if (input instanceof String) {
                    path = (String)input;
                    file = new File(path);
                }
                if (file != null) {
                    if (!file.exists()) {
                        msg.append("\"" + path + "\": " + I18N.getString("ImageReadDescriptor11"));
                        return false;
                    }
                    if (!file.canRead()) {
                        msg.append("\"" + path + "\": " + I18N.getString("ImageReadDescriptor12"));
                        return false;
                    }
                }
            } else if (input instanceof Socket) {
                Socket socket = (Socket)input;
                if (socket.isInputShutdown()) {
                    msg.append("\"" + socket + "\": " + I18N.getString("ImageReadDescriptor13"));
                    return false;
                }
                if (socket.isClosed()) {
                    msg.append("\"" + socket + "\": " + I18N.getString("ImageReadDescriptor14"));
                    return false;
                }
                if (!socket.isBound()) {
                    msg.append("\"" + socket + "\": " + I18N.getString("ImageReadDescriptor15"));
                    return false;
                }
                if (!socket.isConnected()) {
                    msg.append("\"" + socket + "\": " + I18N.getString("ImageReadDescriptor16"));
                    return false;
                }
            }
        }
        return true;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static {
        PROPERTY_NAME_IMAGE_READ_PARAM = PROPERTY_NAME_IMAGE_READ_PARAM;
        PROPERTY_NAME_IMAGE_READER = PROPERTY_NAME_IMAGE_READER;
        PROPERTY_NAME_METADATA_IMAGE = PROPERTY_NAME_METADATA_IMAGE;
        PROPERTY_NAME_METADATA_STREAM = PROPERTY_NAME_METADATA_STREAM;
        PROPERTY_NAME_THUMBNAILS = PROPERTY_NAME_THUMBNAILS;
        PROPERTY_NAME_RENDERABLE_INPUT = PROPERTY_NAME_RENDERABLE_INPUT;
        OPERATION_NAME = OPERATION_NAME;
        resources = new String[][]{{"GlobalName", OPERATION_NAME}, {"LocalName", OPERATION_NAME}, {"Vendor", "com.sun.media.jai"}, {"Description", I18N.getString("ImageReadDescriptor0")}, {"DocURL", "http://java.sun.com/products/java-media/jai/forDevelopers/jai-apidocs/javax/media/jai/operator/ImageReadDescriptor.html"}, {"Version", I18N.getString("DescriptorVersion")}, {"arg0Desc", I18N.getString("ImageReadDescriptor1")}, {"arg1Desc", I18N.getString("ImageReadDescriptor2")}, {"arg2Desc", I18N.getString("ImageReadDescriptor3")}, {"arg3Desc", I18N.getString("ImageReadDescriptor4")}, {"arg4Desc", I18N.getString("ImageReadDescriptor5")}, {"arg5Desc", I18N.getString("ImageReadDescriptor6")}, {"arg6Desc", I18N.getString("ImageReadDescriptor7")}, {"arg7Desc", I18N.getString("ImageReadDescriptor8")}, {"arg8Desc", I18N.getString("ImageReadDescriptor9")}};
        paramNames = new String[]{"Input", "ImageChoice", "ReadMetadata", "ReadThumbnails", "VerifyInput", "Listeners", "Locale", "ReadParam", "Reader"};
        renderedParamClasses = new Class[]{class$java$lang$Object == null ? (class$java$lang$Object = ImageReadDescriptor.class$("java.lang.Object")) : class$java$lang$Object, class$java$lang$Integer == null ? (class$java$lang$Integer = ImageReadDescriptor.class$("java.lang.Integer")) : class$java$lang$Integer, class$java$lang$Boolean == null ? (class$java$lang$Boolean = ImageReadDescriptor.class$("java.lang.Boolean")) : class$java$lang$Boolean, class$java$lang$Boolean == null ? (class$java$lang$Boolean = ImageReadDescriptor.class$("java.lang.Boolean")) : class$java$lang$Boolean, class$java$lang$Boolean == null ? (class$java$lang$Boolean = ImageReadDescriptor.class$("java.lang.Boolean")) : class$java$lang$Boolean, array$Ljava$util$EventListener == null ? (array$Ljava$util$EventListener = ImageReadDescriptor.class$("[Ljava.util.EventListener;")) : array$Ljava$util$EventListener, class$java$util$Locale == null ? (class$java$util$Locale = ImageReadDescriptor.class$("java.util.Locale")) : class$java$util$Locale, class$javax$imageio$ImageReadParam == null ? (class$javax$imageio$ImageReadParam = ImageReadDescriptor.class$("javax.imageio.ImageReadParam")) : class$javax$imageio$ImageReadParam, class$javax$imageio$ImageReader == null ? (class$javax$imageio$ImageReader = ImageReadDescriptor.class$("javax.imageio.ImageReader")) : class$javax$imageio$ImageReader};
        renderedParamDefaults = new Object[]{OperationDescriptor.NO_PARAMETER_DEFAULT, new Integer(0), Boolean.TRUE, Boolean.TRUE, Boolean.TRUE, null, null, null, null};
        renderableParamClasses = new Class[]{class$java$lang$Object == null ? (class$java$lang$Object = ImageReadDescriptor.class$("java.lang.Object")) : class$java$lang$Object, array$I == null ? (array$I = ImageReadDescriptor.class$("[I")) : array$I, class$java$lang$Boolean == null ? (class$java$lang$Boolean = ImageReadDescriptor.class$("java.lang.Boolean")) : class$java$lang$Boolean, class$java$lang$Boolean == null ? (class$java$lang$Boolean = ImageReadDescriptor.class$("java.lang.Boolean")) : class$java$lang$Boolean, class$java$lang$Boolean == null ? (class$java$lang$Boolean = ImageReadDescriptor.class$("java.lang.Boolean")) : class$java$lang$Boolean, array$Ljava$util$EventListener == null ? (array$Ljava$util$EventListener = ImageReadDescriptor.class$("[Ljava.util.EventListener;")) : array$Ljava$util$EventListener, class$java$util$Locale == null ? (class$java$util$Locale = ImageReadDescriptor.class$("java.util.Locale")) : class$java$util$Locale, class$javax$imageio$ImageReadParam == null ? (class$javax$imageio$ImageReadParam = ImageReadDescriptor.class$("javax.imageio.ImageReadParam")) : class$javax$imageio$ImageReadParam, class$javax$imageio$ImageReader == null ? (class$javax$imageio$ImageReader = ImageReadDescriptor.class$("javax.imageio.ImageReader")) : class$javax$imageio$ImageReader};
        renderableParamDefaults = new Object[]{OperationDescriptor.NO_PARAMETER_DEFAULT, null, Boolean.TRUE, Boolean.TRUE, Boolean.TRUE, null, null, null, null};
        collectionParamClasses = renderableParamClasses;
        collectionParamDefaults = renderableParamDefaults;
    }
}

