/*
 * Decompiled with CFR 0.152.
 */
package jj2000.j2k.codestream.writer;

import jj2000.j2k.util.ArrayUtil;

public class BitOutputBuffer {
    byte[] buf = new byte[32];
    int curbyte;
    int avbits = 8;
    public static final int SZ_INCR = 16;
    public static final int SZ_INIT = 32;

    public void reset() {
        this.curbyte = 0;
        this.avbits = 8;
        ArrayUtil.byteArraySet(this.buf, (byte)0);
    }

    public final void writeBit(int bit) {
        int n = this.curbyte;
        this.buf[n] = (byte)(this.buf[n] | bit << --this.avbits);
        if (this.avbits > 0) {
            return;
        }
        this.avbits = this.buf[this.curbyte] != -1 ? 8 : 7;
        ++this.curbyte;
        if (this.curbyte == this.buf.length) {
            byte[] oldbuf = this.buf;
            this.buf = new byte[oldbuf.length + 16];
            System.arraycopy(oldbuf, 0, this.buf, 0, oldbuf.length);
        }
    }

    public final void writeBits(int bits, int n) {
        if ((this.buf.length - this.curbyte << 3) - 8 + this.avbits <= n + 2) {
            byte[] oldbuf = this.buf;
            this.buf = new byte[oldbuf.length + 16];
            System.arraycopy(oldbuf, 0, this.buf, 0, oldbuf.length);
        }
        if (n >= this.avbits) {
            int n2 = this.curbyte;
            this.buf[n2] = (byte)(this.buf[n2] | bits >> (n -= this.avbits));
            this.avbits = this.buf[this.curbyte] != -1 ? 8 : 7;
            ++this.curbyte;
            while (n >= this.avbits) {
                int n3 = this.curbyte;
                this.buf[n3] = (byte)(this.buf[n3] | bits >> (n -= this.avbits) & ~(1 << this.avbits));
                this.avbits = this.buf[this.curbyte] != -1 ? 8 : 7;
                ++this.curbyte;
            }
        }
        if (n > 0) {
            this.avbits -= n;
            int n4 = this.curbyte;
            this.buf[n4] = (byte)(this.buf[n4] | (bits & (1 << n) - 1) << this.avbits);
        }
        if (this.avbits == 0) {
            this.avbits = this.buf[this.curbyte] != -1 ? 8 : 7;
            ++this.curbyte;
        }
    }

    public final int getLength() {
        if (this.avbits == 8) {
            return this.curbyte;
        }
        return this.curbyte + 1;
    }

    public final byte[] getBuffer() {
        return this.buf;
    }

    public byte[] toByteArray(byte[] data) {
        if (data == null) {
            data = new byte[this.avbits == 8 ? this.curbyte : this.curbyte + 1];
        }
        System.arraycopy(this.buf, 0, data, 0, this.avbits == 8 ? this.curbyte : this.curbyte + 1);
        return data;
    }

    public String toString() {
        return "bits written = " + (this.curbyte * 8 + (8 - this.avbits)) + ", curbyte = " + this.curbyte + ", avbits = " + this.avbits;
    }

    static {
        SZ_INCR = 16;
        SZ_INIT = 32;
    }
}

