/*
 * Decompiled with CFR 0.152.
 */
package com.jgoodies.animation;

import com.jgoodies.animation.Animation;
import com.jgoodies.animation.AnimationEvent;
import com.jgoodies.animation.AnimationListener;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;

public abstract class AbstractAnimation
implements Animation {
    private final long duration;
    private final boolean freezed;
    private final List listenerList = new LinkedList();
    private boolean active = false;

    protected AbstractAnimation(long duration) {
        this(duration, false);
    }

    protected AbstractAnimation(long duration, boolean freezed) {
        this.duration = duration;
        this.freezed = freezed;
    }

    public final long duration() {
        return this.duration;
    }

    public final boolean isFreezed() {
        return this.freezed;
    }

    protected abstract void applyEffect(long var1);

    public void animate(long time) {
        if (time >= this.duration) {
            if (this.active) {
                this.applyEffect(this.isFreezed() ? this.duration - 1L : 0L);
                this.fireAnimationStopped(time);
                this.active = false;
            }
            return;
        }
        if (!this.active) {
            this.active = true;
            this.fireAnimationStarted(time);
        }
        this.applyEffect(time);
    }

    public final void addAnimationListener(AnimationListener listener) {
        this.listenerList.add(listener);
    }

    public final void removeAnimationListener(AnimationListener listener) {
        this.listenerList.remove(listener);
    }

    protected final void fireAnimationStarted(long time) {
        AnimationEvent e = new AnimationEvent(this, AnimationEvent.STARTED, time);
        Iterator i = this.listenerList.iterator();
        while (i.hasNext()) {
            AnimationListener listener = (AnimationListener)i.next();
            listener.animationStarted(e);
        }
    }

    protected final void fireAnimationStopped(long time) {
        AnimationEvent e = new AnimationEvent(this, AnimationEvent.STOPPED, time);
        Iterator i = this.listenerList.iterator();
        while (i.hasNext()) {
            AnimationListener listener = (AnimationListener)i.next();
            listener.animationStopped(e);
        }
    }

    public String toString() {
        return "[" + this.getClass().getName() + "; duration=" + this.duration + "; active=" + this.active + 93;
    }
}

