/*
 * Decompiled with CFR 0.152.
 */
package com.jgoodies.animation.animations;

import com.jgoodies.animation.AbstractAnimation;
import com.jgoodies.animation.AnimationFunction;
import com.jgoodies.animation.AnimationFunctions;
import com.jgoodies.animation.components.BasicTextLabel;
import java.awt.Color;

public final class BasicTextAnimation
extends AbstractAnimation {
    private final BasicTextLabel label;
    private final String text;
    private final AnimationFunction colorFunction;
    private final AnimationFunctions.FloatFunction offsetFunction;
    private final AnimationFunctions.FloatFunction scaleXFunction;
    private final AnimationFunctions.FloatFunction scaleYFunction;
    private final AnimationFunctions.FloatFunction spaceFunction;
    private boolean offsetEnabled = false;

    public BasicTextAnimation(BasicTextLabel label, long duration, String text, AnimationFunction colorFunction, AnimationFunction scaleXFunction, AnimationFunction scaleYFunction, AnimationFunction spaceFunction) {
        super(duration);
        this.label = label;
        this.text = text;
        this.colorFunction = colorFunction != null ? colorFunction : BasicTextAnimation.defaultFadeColorFunction(duration, Color.darkGray);
        this.scaleXFunction = AnimationFunctions.asFloat(scaleXFunction != null ? scaleXFunction : AnimationFunctions.ONE);
        this.scaleYFunction = AnimationFunctions.asFloat(scaleYFunction != null ? scaleYFunction : AnimationFunctions.ONE);
        this.spaceFunction = AnimationFunctions.asFloat(spaceFunction != null ? spaceFunction : AnimationFunctions.ZERO);
        this.offsetFunction = AnimationFunctions.asFloat(BasicTextAnimation.defaultOffsetFunction());
    }

    public static BasicTextAnimation defaultFade(BasicTextLabel label, long duration, String text, Color baseColor) {
        return new BasicTextAnimation(label, duration, text, BasicTextAnimation.cinemaFadeColorFunction(duration, baseColor), null, null, null);
    }

    public static BasicTextAnimation defaultScale(BasicTextLabel label, long duration, String text, Color baseColor) {
        return new BasicTextAnimation(label, duration, text, BasicTextAnimation.defaultScaleColorFunction(duration, baseColor), BasicTextAnimation.defaultScaleFunction(duration), BasicTextAnimation.defaultScaleFunction(duration), null);
    }

    public static BasicTextAnimation defaultSpace(BasicTextLabel label, long duration, String text, Color baseColor) {
        return new BasicTextAnimation(label, duration, text, BasicTextAnimation.defaultSpaceColorFunction(duration, baseColor), null, null, BasicTextAnimation.defaultSpaceFunction(duration));
    }

    public static AnimationFunction defaultFadeColorFunction(long duration, Color baseColor) {
        return AnimationFunctions.alphaColor(AnimationFunctions.linear(duration, new Integer[]{new Integer(0), new Integer(255), new Integer(255), new Integer(0)}, new float[]{0.0f, 0.3f, 0.7f, 1.0f}), baseColor);
    }

    public static AnimationFunction cinemaFadeColorFunction(long duration, Color baseColor) {
        return AnimationFunctions.alphaColor(AnimationFunctions.linear(duration, new Integer[]{new Integer(0), new Integer(255), new Integer(255), new Integer(0)}, new float[]{0.0f, 0.3f, 0.85f, 1.0f}), baseColor);
    }

    public static AnimationFunction defaultScaleColorFunction(long duration, Color baseColor) {
        return AnimationFunctions.alphaColor(AnimationFunctions.linear(duration, new Integer[]{new Integer(0), new Integer(255), new Integer(255), new Integer(0)}, new float[]{0.0f, 0.2f, 0.85f, 1.0f}), baseColor);
    }

    public static AnimationFunction defaultSpaceColorFunction(long duration, Color baseColor) {
        return AnimationFunctions.alphaColor(AnimationFunctions.linear(duration, new Integer[]{new Integer(0), new Integer(255), new Integer(255), new Integer(0)}, new float[]{0.0f, 0.2f, 0.8f, 1.0f}), baseColor);
    }

    public static AnimationFunction defaultOffsetFunction() {
        return AnimationFunctions.random(-2, 2, 0.5f);
    }

    public static AnimationFunction defaultScaleFunction(long duration) {
        return AnimationFunctions.linear(duration, new Float[]{new Float(1.0f), new Float(1.0f), new Float(1.8f)}, new float[]{0.0f, 0.85f, 1.0f});
    }

    public static AnimationFunction defaultSpaceFunction(long duration) {
        return AnimationFunctions.fromTo(duration, 0.0f, 10.0f);
    }

    protected void applyEffect(long time) {
        this.label.setText(time == 0L ? " " : this.text);
        this.label.setColor((Color)this.colorFunction.valueAt(time));
        this.label.setScaleX(this.scaleXFunction.valueAt(time));
        this.label.setScaleY(this.scaleYFunction.valueAt(time));
        this.label.setSpace(this.spaceFunction.valueAt(time));
        if (this.isOffsetEnabled()) {
            this.label.setOffsetX(this.offsetFunction.valueAt(time));
            this.label.setOffsetY(this.offsetFunction.valueAt(time));
        }
    }

    public boolean isOffsetEnabled() {
        return this.offsetEnabled;
    }

    public void setOffsetEnabled(boolean b) {
        this.offsetEnabled = b;
    }
}

