/*
 * Decompiled with CFR 0.152.
 */
package com.jgoodies.animation.components;

import com.jgoodies.animation.renderer.FanRenderer;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.RenderingHints;
import java.awt.geom.Point2D;
import javax.swing.JComponent;

public final class FanComponent
extends JComponent {
    private final FanRenderer renderer;

    public FanComponent(int triangleCount, Color baseColor) {
        this.renderer = new FanRenderer(triangleCount, baseColor);
    }

    public Point2D getOrigin() {
        return this.renderer.getOrigin();
    }

    public double getRotation() {
        return this.renderer.getRotation();
    }

    public void setOrigin(Point2D origin) {
        this.renderer.setOrigin(origin);
        this.repaint();
    }

    public void setRotation(double rotation) {
        this.renderer.setRotation(rotation);
        this.repaint();
    }

    public void paintComponent(Graphics g) {
        Graphics2D g2 = (Graphics2D)g;
        g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        g2.setRenderingHint(RenderingHints.KEY_RENDERING, RenderingHints.VALUE_RENDER_QUALITY);
        Insets insets = this.getInsets();
        int x = insets.left;
        int y = insets.top;
        int w = this.getWidth() - x - insets.right;
        int h = this.getHeight() - y - insets.bottom;
        g2.translate(x, y);
        this.renderer.render(g2, w, h);
        g2.translate(-x, -y);
    }
}

