/*
 * Decompiled with CFR 0.152.
 */
package org.apache.batik.css.engine.value.css2;

import org.apache.batik.css.engine.CSSContext;
import org.apache.batik.css.engine.CSSEngine;
import org.apache.batik.css.engine.CSSStylableElement;
import org.apache.batik.css.engine.StyleMap;
import org.apache.batik.css.engine.value.IdentifierManager;
import org.apache.batik.css.engine.value.StringMap;
import org.apache.batik.css.engine.value.Value;
import org.apache.batik.css.engine.value.ValueConstants;
import org.w3c.css.sac.LexicalUnit;
import org.w3c.dom.DOMException;

public class FontWeightManager
extends IdentifierManager {
    protected static final StringMap values = new StringMap();

    public boolean isInheritedProperty() {
        return true;
    }

    public String getPropertyName() {
        return "font-weight";
    }

    public Value getDefaultValue() {
        return ValueConstants.NORMAL_VALUE;
    }

    public Value createValue(LexicalUnit lexicalUnit, CSSEngine cSSEngine) throws DOMException {
        if (lexicalUnit.getLexicalUnitType() == 13) {
            int n = lexicalUnit.getIntegerValue();
            switch (n) {
                case 100: {
                    return ValueConstants.NUMBER_100;
                }
                case 200: {
                    return ValueConstants.NUMBER_200;
                }
                case 300: {
                    return ValueConstants.NUMBER_300;
                }
                case 400: {
                    return ValueConstants.NUMBER_400;
                }
                case 500: {
                    return ValueConstants.NUMBER_500;
                }
                case 600: {
                    return ValueConstants.NUMBER_600;
                }
                case 700: {
                    return ValueConstants.NUMBER_700;
                }
                case 800: {
                    return ValueConstants.NUMBER_800;
                }
                case 900: {
                    return ValueConstants.NUMBER_900;
                }
            }
            throw this.createInvalidFloatValueDOMException(n);
        }
        return super.createValue(lexicalUnit, cSSEngine);
    }

    public Value createFloatValue(short s, float f) throws DOMException {
        int n;
        if (s == 1 && f == (float)(n = (int)f)) {
            switch (n) {
                case 100: {
                    return ValueConstants.NUMBER_100;
                }
                case 200: {
                    return ValueConstants.NUMBER_200;
                }
                case 300: {
                    return ValueConstants.NUMBER_300;
                }
                case 400: {
                    return ValueConstants.NUMBER_400;
                }
                case 500: {
                    return ValueConstants.NUMBER_500;
                }
                case 600: {
                    return ValueConstants.NUMBER_600;
                }
                case 700: {
                    return ValueConstants.NUMBER_700;
                }
                case 800: {
                    return ValueConstants.NUMBER_800;
                }
                case 900: {
                    return ValueConstants.NUMBER_900;
                }
            }
        }
        throw this.createInvalidFloatValueDOMException(f);
    }

    public Value computeValue(CSSStylableElement cSSStylableElement, String string, CSSEngine cSSEngine, int n, StyleMap styleMap, Value value) {
        if (value == ValueConstants.BOLDER_VALUE) {
            float f;
            styleMap.putParentRelative(n, true);
            CSSContext cSSContext = cSSEngine.getCSSContext();
            CSSStylableElement cSSStylableElement2 = CSSEngine.getParentCSSStylableElement(cSSStylableElement);
            if (cSSStylableElement2 == null) {
                f = 400.0f;
            } else {
                Value value2 = cSSEngine.getComputedStyle(cSSStylableElement2, string, n);
                f = value2.getFloatValue();
            }
            return this.createFontWeight(cSSContext.getBolderFontWeight(f));
        }
        if (value == ValueConstants.LIGHTER_VALUE) {
            float f;
            styleMap.putParentRelative(n, true);
            CSSContext cSSContext = cSSEngine.getCSSContext();
            CSSStylableElement cSSStylableElement3 = CSSEngine.getParentCSSStylableElement(cSSStylableElement);
            if (cSSStylableElement3 == null) {
                f = 400.0f;
            } else {
                Value value3 = cSSEngine.getComputedStyle(cSSStylableElement3, string, n);
                f = value3.getFloatValue();
            }
            return this.createFontWeight(cSSContext.getLighterFontWeight(f));
        }
        if (value == ValueConstants.NORMAL_VALUE) {
            return ValueConstants.NUMBER_400;
        }
        if (value == ValueConstants.BOLD_VALUE) {
            return ValueConstants.NUMBER_700;
        }
        return value;
    }

    protected Value createFontWeight(float f) {
        switch ((int)f) {
            case 100: {
                return ValueConstants.NUMBER_100;
            }
            case 200: {
                return ValueConstants.NUMBER_200;
            }
            case 300: {
                return ValueConstants.NUMBER_300;
            }
            case 400: {
                return ValueConstants.NUMBER_400;
            }
            case 500: {
                return ValueConstants.NUMBER_500;
            }
            case 600: {
                return ValueConstants.NUMBER_600;
            }
            case 700: {
                return ValueConstants.NUMBER_700;
            }
            case 800: {
                return ValueConstants.NUMBER_800;
            }
        }
        return ValueConstants.NUMBER_900;
    }

    protected StringMap getIdentifiers() {
        return values;
    }

    static {
        values.put("all", ValueConstants.ALL_VALUE);
        values.put("bold", ValueConstants.BOLD_VALUE);
        values.put("bolder", ValueConstants.BOLDER_VALUE);
        values.put("lighter", ValueConstants.LIGHTER_VALUE);
        values.put("normal", ValueConstants.NORMAL_VALUE);
    }
}

