/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.editor;

import java.awt.Rectangle;
import java.beans.PropertyChangeListener;
import java.text.MessageFormat;
import java.util.HashMap;
import java.util.Map;
import javax.swing.text.BadLocationException;
import javax.swing.text.Caret;
import javax.swing.text.JTextComponent;
import org.netbeans.editor.BaseCaret;
import org.netbeans.editor.BaseDocument;
import org.netbeans.editor.BaseTextUI;
import org.netbeans.editor.DrawLayerFactory;
import org.netbeans.editor.EditorUI;
import org.netbeans.editor.Finder;
import org.netbeans.editor.FinderFactory;
import org.netbeans.editor.GuardedException;
import org.netbeans.editor.InvalidMarkException;
import org.netbeans.editor.JumpList;
import org.netbeans.editor.LocaleSupport;
import org.netbeans.editor.Mark;
import org.netbeans.editor.Settings;
import org.netbeans.editor.Utilities;
import org.netbeans.editor.WeakPropertyChangeSupport;

public class FindSupport {
    private static final String FOUND_LOCALE = "find-found";
    private static final String NOT_FOUND_LOCALE = "find-not-found";
    private static final String WRAP_START_LOCALE = "find-wrap-start";
    private static final String WRAP_END_LOCALE = "find-wrap-end";
    private static final String ITEMS_REPLACED_LOCALE = "find-items-replaced";
    public static final String REVERT_MAP = "revert-map";
    static FindSupport findSupport;
    private Map findProps;
    WeakPropertyChangeSupport changeSupport = new WeakPropertyChangeSupport();
    FinderCreator finderCreator;
    static /* synthetic */ Class class$org$netbeans$editor$BaseKit;

    private FindSupport() {
    }

    public static FindSupport getFindSupport() {
        if (findSupport == null) {
            findSupport = new FindSupport();
        }
        return findSupport;
    }

    public FinderCreator getFinderCreator() {
        if (this.finderCreator == null) {
            this.finderCreator = new DefaultFinderCreator();
        }
        return this.finderCreator;
    }

    public void setFinderCreator(FinderCreator finderCreator) {
        this.finderCreator = finderCreator;
        this.firePropertyChange(null, null, null);
    }

    public Map getDefaultFindProperties() {
        HashMap<String, Object> props = new HashMap<String, Object>();
        Class kitClass = class$org$netbeans$editor$BaseKit == null ? (class$org$netbeans$editor$BaseKit = FindSupport.class$("org.netbeans.editor.BaseKit")) : class$org$netbeans$editor$BaseKit;
        props.put("find-what", Settings.getValue(kitClass, "find-what"));
        props.put("find-replace-with", Settings.getValue(kitClass, "find-replace-with"));
        props.put("find-highlight-search", Settings.getValue(kitClass, "find-highlight-search"));
        props.put("find-inc-search", Settings.getValue(kitClass, "find-inc-search"));
        props.put("find-backward-search", Settings.getValue(kitClass, "find-backward-search"));
        props.put("find-wrap-search", Settings.getValue(kitClass, "find-wrap-search"));
        props.put("find-match-case", Settings.getValue(kitClass, "find-match-case"));
        props.put("find-whole-words", Settings.getValue(kitClass, "find-whole-words"));
        props.put("find-reg-exp", Settings.getValue(kitClass, "find-reg-exp"));
        props.put("find-history", Settings.getValue(kitClass, "find-history"));
        return props;
    }

    public Map getFindProperties() {
        if (this.findProps == null) {
            this.findProps = this.getDefaultFindProperties();
        }
        return this.findProps;
    }

    public Object getFindProperty(String name) {
        return this.getFindProperties().get(name);
    }

    private Map getValidFindProperties(Map props) {
        return props != null ? props : this.getFindProperties();
    }

    public FinderFactory.StringFinder getStringFinder(BaseDocument doc, Map props) {
        FinderFactory.StringFinder stringFinder = (FinderFactory.StringFinder)doc.getProperty("string-finder");
        if (stringFinder == null) {
            stringFinder = this.getFinderCreator().createFinder(doc, this.getValidFindProperties(props));
            doc.putProperty("string-finder", stringFinder);
        }
        return stringFinder;
    }

    public FinderFactory.StringFinder getStringBwdFinder(BaseDocument doc, Map props) {
        FinderFactory.StringFinder stringBwdFinder = (FinderFactory.StringFinder)doc.getProperty("string-bwd-finder");
        if (stringBwdFinder == null) {
            stringBwdFinder = this.getFinderCreator().createBwdFinder(doc, this.getValidFindProperties(props));
            doc.putProperty("string-bwd-finder", stringBwdFinder);
        }
        return stringBwdFinder;
    }

    public FinderFactory.BlocksFinder getBlocksFinder(BaseDocument doc, Map props) {
        FinderFactory.BlocksFinder blocksFinder = (FinderFactory.BlocksFinder)doc.getProperty("blocks-finder");
        if (blocksFinder == null) {
            blocksFinder = this.getFinderCreator().createBlocksFinder(doc, this.getValidFindProperties(props));
        }
        return blocksFinder;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    int[] getBlocks(int[] blocks, BaseDocument doc, int startPos, int endPos) throws BadLocationException {
        FinderFactory.BlocksFinder ppf = this.getBlocksFinder(doc, null);
        if (ppf == null) {
            return blocks;
        }
        FinderFactory.BlocksFinder blocksFinder = ppf;
        synchronized (blocksFinder) {
            ppf.setBlocks(blocks);
            doc.find(ppf, startPos, endPos);
            return ppf.getBlocks();
        }
    }

    Object getPropertyNoInit(String name) {
        if (this.findProps == null) {
            return null;
        }
        return this.getFindProperty(name);
    }

    public void putFindProperty(String name, Object newValue) {
        Object oldValue = this.getFindProperty(name);
        if (oldValue == null && newValue == null || oldValue != null && oldValue.equals(newValue)) {
            return;
        }
        if (newValue != null) {
            this.getFindProperties().put(name, newValue);
        } else {
            this.getFindProperties().remove(name);
        }
        this.firePropertyChange(name, oldValue, newValue);
    }

    public void putFindProperties(Map propsToAdd) {
        if (!((Object)this.getFindProperties()).equals(propsToAdd)) {
            this.getFindProperties().putAll(propsToAdd);
            this.firePropertyChange(null, null, null);
        }
    }

    public boolean incSearch(Map props) {
        Boolean b = (Boolean)(props = this.getValidFindProperties(props)).get("find-inc-search");
        if (b != null && b.booleanValue()) {
            JTextComponent c = Utilities.getLastActiveComponent();
            if (c != null) {
                DrawLayerFactory.IncSearchLayer incLayer;
                EditorUI editorUI;
                BaseTextUI ui;
                int pos;
                Caret caret;
                block17: {
                    caret = c.getCaret();
                    BaseDocument doc = (BaseDocument)c.getDocument();
                    int dot = caret.getDot();
                    FinderFactory.StringFinder finder = this.getFinderCreator().createFinder(doc, props);
                    try {
                        boolean back;
                        b = (Boolean)props.get("find-backward-search");
                        boolean bl = back = b != null && b != false;
                        pos = back ? doc.find(finder, dot, 0) : doc.find(finder, dot, -1);
                    }
                    catch (BadLocationException e) {
                        if (Boolean.getBoolean("netbeans.debug.exceptions")) {
                            e.printStackTrace();
                        }
                        return false;
                    }
                    ui = (BaseTextUI)c.getUI();
                    editorUI = ui.getEditorUI();
                    incLayer = (DrawLayerFactory.IncSearchLayer)editorUI.findLayer("inc-search-layer");
                    if (incLayer == null) {
                        incLayer = new DrawLayerFactory.IncSearchLayer();
                        if (!editorUI.addLayer(incLayer, 9500)) {
                            return false;
                        }
                    } else if (incLayer.isEnabled()) {
                        incLayer.setEnabled(false);
                        try {
                            editorUI.repaintOffset(incLayer.getOffset());
                        }
                        catch (BadLocationException e) {
                            if (!Boolean.getBoolean("netbeans.debug.exceptions")) break block17;
                            e.printStackTrace();
                        }
                    }
                }
                if (pos >= 0) {
                    int len;
                    String s = (String)props.get("find-what");
                    int n = len = s != null ? s.length() : 0;
                    if (len > 0) {
                        block18: {
                            incLayer.setEnabled(true);
                            incLayer.setArea(pos, len);
                            try {
                                Rectangle r0 = ui.modelToView(c, pos, null);
                                Rectangle r = ui.modelToView(c, pos + len, null);
                                r.add(r0);
                                editorUI.repaintOffset(pos);
                                if (caret instanceof BaseCaret) {
                                    BaseCaret bCaret = (BaseCaret)caret;
                                    bCaret.setDot(pos, bCaret, 3, false);
                                }
                            }
                            catch (BadLocationException e) {
                                if (!Boolean.getBoolean("netbeans.debug.exceptions")) break block18;
                                e.printStackTrace();
                                return false;
                            }
                        }
                        return true;
                    }
                }
            }
        } else {
            this.incSearchReset();
        }
        return false;
    }

    public void incSearchReset() {
        block4: {
            JTextComponent c = Utilities.getLastActiveComponent();
            if (c == null) {
                return;
            }
            EditorUI editorUI = ((BaseTextUI)c.getUI()).getEditorUI();
            DrawLayerFactory.IncSearchLayer incLayer = (DrawLayerFactory.IncSearchLayer)editorUI.findLayer("inc-search-layer");
            if (incLayer != null && incLayer.isEnabled()) {
                incLayer.setEnabled(false);
                try {
                    editorUI.repaintOffset(incLayer.getOffset());
                }
                catch (BadLocationException e) {
                    if (!Boolean.getBoolean("netbeans.debug.exceptions")) break block4;
                    e.printStackTrace();
                }
            }
        }
    }

    private boolean isBackSearch(Map props, boolean oppositeDir) {
        boolean back;
        Boolean b = (Boolean)props.get("find-backward-search");
        boolean bl = back = b != null && b != false;
        if (oppositeDir) {
            back = !back;
        }
        return back;
    }

    public boolean find(Map props, boolean oppositeDir) {
        block13: {
            this.incSearchReset();
            props = this.getValidFindProperties(props);
            boolean back = this.isBackSearch(props, oppositeDir);
            JTextComponent c = Utilities.getLastActiveComponent();
            Object findWhat = props.get("find-what");
            if (findWhat == null) {
                return true;
            }
            String exp = "'" + findWhat + "' ";
            if (c != null) {
                Utilities.clearStatusText(c);
                Caret caret = c.getCaret();
                int dotPos = caret.getDot();
                try {
                    int[] blk = this.findInBlock(c, dotPos, 0, -1, props, oppositeDir);
                    if (blk != null) {
                        if (caret instanceof BaseCaret) {
                            BaseCaret bCaret = (BaseCaret)caret;
                            if (back) {
                                bCaret.setDot(blk[1], bCaret, 3);
                                bCaret.moveDot(blk[0], bCaret, 3);
                            } else {
                                bCaret.setDot(blk[0], bCaret, 3);
                                bCaret.moveDot(blk[1], bCaret, 3);
                            }
                        } else if (back) {
                            caret.setDot(blk[1]);
                            caret.moveDot(blk[0]);
                        } else {
                            caret.setDot(blk[0]);
                            caret.moveDot(blk[1]);
                        }
                        JumpList.checkAddEntry();
                        String msg = exp + LocaleSupport.getString(FOUND_LOCALE) + ' ' + Utilities.debugPosition((BaseDocument)c.getDocument(), blk[0]);
                        if (blk[2] == 1) {
                            msg = msg + "; ";
                            msg = msg + (back ? LocaleSupport.getString(WRAP_END_LOCALE) : LocaleSupport.getString(WRAP_START_LOCALE));
                            Utilities.setStatusBoldText(c, msg);
                        } else {
                            Utilities.setStatusText(c, msg);
                        }
                        return true;
                    }
                    Utilities.setStatusBoldText(c, exp + LocaleSupport.getString(NOT_FOUND_LOCALE));
                    c.getCaret().setDot(c.getCaret().getDot());
                }
                catch (BadLocationException e) {
                    if (!Boolean.getBoolean("netbeans.debug.exceptions")) break block13;
                    e.printStackTrace();
                }
            }
        }
        return false;
    }

    public int[] findInBlock(JTextComponent c, int startPos, int blockStartPos, int blockEndPos, Map props, boolean oppositeDir) throws BadLocationException {
        if (c != null) {
            props = this.getValidFindProperties(props);
            BaseDocument doc = (BaseDocument)c.getDocument();
            FinderFactory.StringFinder sf = oppositeDir ? this.getStringBwdFinder(doc, props) : this.getStringFinder(doc, props);
            int pos = -1;
            boolean wrapDone = false;
            boolean back = this.isBackSearch(props, oppositeDir);
            Boolean b = (Boolean)props.get("find-wrap-search");
            boolean wrap = b != null && b != false;
            int docLen = doc.getLength();
            if (blockEndPos == -1) {
                blockEndPos = docLen;
            }
            while ((pos = doc.find(sf, startPos, back ? blockStartPos : blockEndPos)) == -1 && wrap) {
                startPos = back ? blockEndPos : blockStartPos;
                wrapDone = true;
                wrap = false;
            }
            if (pos != -1) {
                int[] ret = new int[]{pos, pos + sf.getFoundLength(), wrapDone ? 1 : 0};
                return ret;
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean replace(Map props, boolean oppositeDir) throws BadLocationException {
        JTextComponent c;
        boolean back;
        this.incSearchReset();
        props = this.getValidFindProperties(props);
        Boolean b = (Boolean)props.get("find-backward-search");
        boolean bl = back = b != null && b != false;
        if (oppositeDir) {
            boolean bl2 = back = !back;
        }
        if ((c = Utilities.getLastActiveComponent()) != null) {
            Caret caret = c.getCaret();
            if (!caret.isSelectionVisible() && !this.find(props, oppositeDir)) {
                return false;
            }
            BaseDocument doc = (BaseDocument)c.getDocument();
            int startPos = c.getSelectionStart();
            int len = c.getSelectionEnd() - startPos;
            doc.atomicLock();
            try {
                String s;
                if (len > 0) {
                    doc.remove(startPos, len);
                }
                if ((s = (String)props.get("find-replace-with")) != null && s.length() > 0) {
                    doc.insertString(startPos, s, null);
                }
            }
            finally {
                doc.atomicUnlock();
            }
            if (back) {
                if (caret instanceof BaseCaret) {
                    ((BaseCaret)caret).setDot(startPos, (BaseCaret)caret, 3);
                } else {
                    caret.setDot(startPos);
                }
            }
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void replaceAll(Map props) {
        this.incSearchReset();
        JTextComponent c = Utilities.getLastActiveComponent();
        BaseDocument doc = (BaseDocument)c.getDocument();
        int maxCnt = doc.getLength();
        int replacedCnt = 0;
        int totalCnt = 0;
        props = this.getValidFindProperties(props);
        props = new HashMap<String, Boolean>(props);
        props.put("find-wrap-search", Boolean.FALSE);
        props.put("find-backward-search", Boolean.FALSE);
        this.firePropertyChange(null, null, null);
        String replaceWith = (String)props.get("find-replace-with");
        if (c != null) {
            doc.atomicLock();
            try {
                int[] blk;
                int pos = 0;
                while ((blk = this.findInBlock(c, pos, 0, -1, props, false)) != null) {
                    ++totalCnt;
                    int len = blk[1] - blk[0];
                    boolean skip = false;
                    try {
                        doc.remove(blk[0], len);
                    }
                    catch (GuardedException e) {
                        skip = true;
                    }
                    if (skip) {
                        pos = blk[0] + len;
                        continue;
                    }
                    if (replaceWith != null && replaceWith.length() > 0) {
                        doc.insertString(blk[0], replaceWith, null);
                    }
                    pos = blk[0] + (replaceWith != null ? replaceWith.length() : 0);
                    ++replacedCnt;
                }
                MessageFormat fmt = new MessageFormat(LocaleSupport.getString(ITEMS_REPLACED_LOCALE));
                String msg = fmt.format(new Object[]{new Integer(replacedCnt), new Integer(totalCnt)});
                Utilities.setStatusText(c, msg);
            }
            catch (BadLocationException e) {
                e.printStackTrace();
            }
            finally {
                doc.atomicUnlock();
            }
        }
    }

    public int getWrapSearchMarkPos(BaseDocument doc) {
        Mark mark = (Mark)doc.getProperty("wrap-search-mark");
        try {
            return mark != null ? mark.getOffset() : doc.getLength();
        }
        catch (InvalidMarkException e) {
            throw new RuntimeException();
        }
    }

    public void setWrapSearchMarkPos(BaseDocument doc, int pos) {
    }

    public void addPropertyChangeListener(PropertyChangeListener l) {
        this.changeSupport.addPropertyChangeListener(l);
    }

    public synchronized void addPropertyChangeListener(String findPropertyName, PropertyChangeListener l) {
        this.changeSupport.addPropertyChangeListener(findPropertyName, l);
    }

    public void removePropertyChangeListener(PropertyChangeListener l) {
        this.changeSupport.removePropertyChangeListener(l);
    }

    void firePropertyChange(String settingName, Object oldValue, Object newValue) {
        this.changeSupport.firePropertyChange(this, settingName, oldValue, newValue);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    public static class DefaultFinderCreator
    implements FinderCreator {
        protected Finder createFinder(BaseDocument doc, Map searchProps, boolean oppositeDir, boolean blocksFinder) {
            boolean wholeWords;
            boolean bwdSearch;
            String text = (String)searchProps.get("find-what");
            if (text == null || text.length() == 0) {
                if (blocksFinder) {
                    return new FinderFactory.FalseBlocksFinder();
                }
                return new FinderFactory.FalseFinder();
            }
            Boolean b = (Boolean)searchProps.get("find-backward-search");
            boolean bl = bwdSearch = b != null && b != false;
            if (oppositeDir) {
                bwdSearch = !bwdSearch;
            }
            boolean matchCase = (b = (Boolean)searchProps.get("find-match-case")) != null && b != false;
            b = (Boolean)searchProps.get("find-smart-case");
            boolean smartCase = b != null && b != false;
            b = (Boolean)searchProps.get("find-whole-words");
            boolean bl2 = wholeWords = b != null && b != false;
            if (smartCase && !matchCase) {
                int cnt = text.length();
                for (int i = 0; i < cnt; ++i) {
                    if (!Character.isUpperCase(text.charAt(i))) continue;
                    matchCase = true;
                }
            }
            if (blocksFinder) {
                if (wholeWords) {
                    return new FinderFactory.WholeWordsBlocksFinder(doc, text, matchCase);
                }
                return new FinderFactory.StringBlocksFinder(text, matchCase);
            }
            if (wholeWords) {
                if (bwdSearch) {
                    return new FinderFactory.WholeWordsBwdFinder(doc, text, matchCase);
                }
                return new FinderFactory.WholeWordsFwdFinder(doc, text, matchCase);
            }
            if (bwdSearch) {
                return new FinderFactory.StringBwdFinder(text, matchCase);
            }
            return new FinderFactory.StringFwdFinder(text, matchCase);
        }

        public FinderFactory.StringFinder createFinder(BaseDocument doc, Map searchProps) {
            return (FinderFactory.StringFinder)this.createFinder(doc, searchProps, false, false);
        }

        public FinderFactory.StringFinder createBwdFinder(BaseDocument doc, Map searchProps) {
            return (FinderFactory.StringFinder)this.createFinder(doc, searchProps, true, false);
        }

        public FinderFactory.BlocksFinder createBlocksFinder(BaseDocument doc, Map searchProps) {
            return (FinderFactory.BlocksFinder)this.createFinder(doc, searchProps, false, true);
        }
    }

    public static interface FinderCreator {
        public FinderFactory.StringFinder createFinder(BaseDocument var1, Map var2);

        public FinderFactory.StringFinder createBwdFinder(BaseDocument var1, Map var2);

        public FinderFactory.BlocksFinder createBlocksFinder(BaseDocument var1, Map var2);
    }
}

