/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.editor;

import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.KeyEvent;
import javax.swing.Action;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.plaf.TextUI;
import javax.swing.text.BadLocationException;
import javax.swing.text.Caret;
import javax.swing.text.Document;
import javax.swing.text.EditorKit;
import javax.swing.text.Element;
import javax.swing.text.JTextComponent;
import javax.swing.text.TextAction;
import javax.swing.text.View;
import org.netbeans.editor.Analyzer;
import org.netbeans.editor.BaseAction;
import org.netbeans.editor.BaseDocument;
import org.netbeans.editor.BaseKit;
import org.netbeans.editor.BaseTextUI;
import org.netbeans.editor.Coloring;
import org.netbeans.editor.EditorUI;
import org.netbeans.editor.Finder;
import org.netbeans.editor.FinderFactory;
import org.netbeans.editor.Formatter;
import org.netbeans.editor.ImplementationProvider;
import org.netbeans.editor.InvalidMarkException;
import org.netbeans.editor.LocaleSupport;
import org.netbeans.editor.Mark;
import org.netbeans.editor.Registry;
import org.netbeans.editor.StatusBar;
import org.netbeans.editor.SyntaxSupport;

public class Utilities {
    private static final String WRONG_POSITION_LOCALE = "wrong_position";
    public static final int CASE_UPPER = 0;
    public static final int CASE_LOWER = 1;
    public static final int CASE_SWITCH = 2;
    private static TextAction focusedComponentAction;
    static /* synthetic */ Class class$org$netbeans$editor$DrawEngineDocView;

    private Utilities() {
    }

    public static int getRowStart(JTextComponent c, int offset) throws BadLocationException {
        return Utilities.getRowStart((BaseDocument)c.getDocument(), offset, 0);
    }

    public static int getRowStart(BaseDocument doc, int offset) throws BadLocationException {
        return Utilities.getRowStart(doc, offset, 0);
    }

    public static int getRowStart(BaseDocument doc, int offset, int lineShift) throws BadLocationException {
        Utilities.checkOffsetValid(doc, offset);
        if (lineShift != 0) {
            Element lineRoot = doc.getParagraphElement(0).getParentElement();
            int line = lineRoot.getElementIndex(offset);
            if ((line += lineShift) < 0 || line >= lineRoot.getElementCount()) {
                return -1;
            }
            return lineRoot.getElement(line).getStartOffset();
        }
        return doc.getParagraphElement(offset).getStartOffset();
    }

    public static int getRowFirstNonWhite(BaseDocument doc, int offset) throws BadLocationException {
        Utilities.checkOffsetValid(doc, offset);
        Element lineElement = doc.getParagraphElement(offset);
        return Utilities.getFirstNonWhiteFwd(doc, lineElement.getStartOffset(), lineElement.getEndOffset() - 1);
    }

    public static int getRowLastNonWhite(BaseDocument doc, int offset) throws BadLocationException {
        Utilities.checkOffsetValid(doc, offset);
        Element lineElement = doc.getParagraphElement(offset);
        return Utilities.getFirstNonWhiteBwd(doc, lineElement.getEndOffset() - 1, lineElement.getStartOffset());
    }

    public static int getRowIndent(BaseDocument doc, int offset) throws BadLocationException {
        if ((offset = Utilities.getRowFirstNonWhite(doc, offset)) == -1) {
            return -1;
        }
        return doc.getVisColFromPos(offset);
    }

    public static int getRowIndent(BaseDocument doc, int offset, boolean downDir) throws BadLocationException {
        int p = Utilities.getRowFirstNonWhite(doc, offset);
        if (p == -1) {
            p = Utilities.getFirstNonWhiteRow(doc, offset, downDir);
            if (p == -1) {
                return -1;
            }
            if ((p = Utilities.getRowFirstNonWhite(doc, p)) == -1) {
                return -1;
            }
        }
        return doc.getVisColFromPos(p);
    }

    public static int getRowEnd(JTextComponent c, int offset) throws BadLocationException {
        return javax.swing.text.Utilities.getRowEnd(c, offset);
    }

    public static int getRowEnd(BaseDocument doc, int offset) throws BadLocationException {
        Utilities.checkOffsetValid(doc, offset);
        return doc.getParagraphElement(offset).getEndOffset() - 1;
    }

    public static int getPositionAbove(JTextComponent c, int offset, int x) throws BadLocationException {
        return javax.swing.text.Utilities.getPositionAbove(c, offset, x);
    }

    public static int getPositionBelow(JTextComponent c, int offset, int x) throws BadLocationException {
        return javax.swing.text.Utilities.getPositionBelow(c, offset, x);
    }

    public static int getWordStart(JTextComponent c, int offset) throws BadLocationException {
        return Utilities.getWordStart((BaseDocument)c.getDocument(), offset);
    }

    public static int getWordStart(BaseDocument doc, int offset) throws BadLocationException {
        return doc.find(new FinderFactory.PreviousWordBwdFinder(doc, false, true), offset, 0);
    }

    public static int getWordEnd(JTextComponent c, int offset) throws BadLocationException {
        return Utilities.getWordEnd((BaseDocument)c.getDocument(), offset);
    }

    public static int getWordEnd(BaseDocument doc, int offset) throws BadLocationException {
        int ret = doc.find(new FinderFactory.NextWordFwdFinder(doc, false, true), offset, -1);
        return ret > 0 ? ret : doc.getLength();
    }

    public static int getNextWord(JTextComponent c, int offset) throws BadLocationException {
        int nextWordOffset = Utilities.getNextWord((BaseDocument)c.getDocument(), offset);
        int nextVisualPosition = c.getUI().getNextVisualPositionFrom(c, nextWordOffset, null, 3, null);
        return nextVisualPosition - 1 == nextWordOffset ? nextWordOffset : nextVisualPosition - 1;
    }

    public static int getNextWord(BaseDocument doc, int offset) throws BadLocationException {
        Finder nextWordFinder = (Finder)doc.getProperty("next-word-finder");
        offset = doc.find(nextWordFinder, offset, -1);
        if (offset < 0) {
            offset = doc.getLength();
        }
        return offset;
    }

    public static int getPreviousWord(JTextComponent c, int offset) throws BadLocationException {
        int prevWordOffset = Utilities.getPreviousWord((BaseDocument)c.getDocument(), offset);
        int nextVisualPosition = c.getUI().getNextVisualPositionFrom(c, prevWordOffset, null, 7, null);
        return nextVisualPosition + 1 == prevWordOffset ? prevWordOffset : nextVisualPosition + 1;
    }

    public static int getPreviousWord(BaseDocument doc, int offset) throws BadLocationException {
        Finder prevWordFinder = (Finder)doc.getProperty("previous-word-finder");
        offset = doc.find(prevWordFinder, offset, 0);
        if (offset < 0) {
            offset = 0;
        }
        return offset;
    }

    public static int getFirstWhiteFwd(BaseDocument doc, int offset) throws BadLocationException {
        return Utilities.getFirstWhiteFwd(doc, offset, -1);
    }

    public static int getFirstWhiteFwd(BaseDocument doc, int offset, int limitPos) throws BadLocationException {
        return doc.find(new FinderFactory.WhiteFwdFinder(doc), offset, limitPos);
    }

    public static int getFirstNonWhiteFwd(BaseDocument doc, int offset) throws BadLocationException {
        return Utilities.getFirstNonWhiteFwd(doc, offset, -1);
    }

    public static int getFirstNonWhiteFwd(BaseDocument doc, int offset, int limitPos) throws BadLocationException {
        return doc.find(new FinderFactory.NonWhiteFwdFinder(doc), offset, limitPos);
    }

    public static int getFirstWhiteBwd(BaseDocument doc, int offset) throws BadLocationException {
        return Utilities.getFirstWhiteBwd(doc, offset, 0);
    }

    public static int getFirstWhiteBwd(BaseDocument doc, int offset, int limitPos) throws BadLocationException {
        return doc.find(new FinderFactory.WhiteBwdFinder(doc), offset, limitPos);
    }

    public static int getFirstNonWhiteBwd(BaseDocument doc, int offset) throws BadLocationException {
        return Utilities.getFirstNonWhiteBwd(doc, offset, 0);
    }

    public static int getFirstNonWhiteBwd(BaseDocument doc, int offset, int limitPos) throws BadLocationException {
        return doc.find(new FinderFactory.NonWhiteBwdFinder(doc), offset, limitPos);
    }

    public static int getLineOffset(BaseDocument doc, int offset) throws BadLocationException {
        Utilities.checkOffsetValid(offset, doc.getLength() + 1);
        Element lineRoot = doc.getParagraphElement(0).getParentElement();
        return lineRoot.getElementIndex(offset);
    }

    public static int getRowStartFromLineOffset(BaseDocument doc, int lineIndex) {
        Element lineRoot = doc.getParagraphElement(0).getParentElement();
        if (lineIndex < 0 || lineIndex >= lineRoot.getElementCount()) {
            return -1;
        }
        return lineRoot.getElement(lineIndex).getStartOffset();
    }

    public static int getVisualColumn(BaseDocument doc, int offset) throws BadLocationException {
        int docLen = doc.getLength();
        if (offset == docLen + 1) {
            offset = docLen;
        }
        return doc.getVisColFromPos(offset);
    }

    public static String getIdentifier(BaseDocument doc, int offset) throws BadLocationException {
        int[] blk = Utilities.getIdentifierBlock(doc, offset);
        return blk != null ? doc.getText(blk[0], blk[1] - blk[0]) : null;
    }

    public static int[] getIdentifierBlock(JTextComponent c, int offset) throws BadLocationException {
        int idEnd;
        String id = null;
        int[] ret = null;
        Document doc = c.getDocument();
        int idStart = javax.swing.text.Utilities.getWordStart(c, offset);
        if (idStart >= 0 && (idEnd = javax.swing.text.Utilities.getWordEnd(c, idStart)) >= 0) {
            id = doc.getText(idStart, idEnd - idStart);
            ret = new int[]{idStart, idEnd};
            String trim = id.trim();
            if (trim.length() == 0 || trim.length() == 1 && !Character.isJavaIdentifierPart(trim.charAt(0))) {
                int prevWordStart = javax.swing.text.Utilities.getPreviousWord(c, offset);
                if (offset == javax.swing.text.Utilities.getWordEnd(c, prevWordStart)) {
                    ret = new int[]{prevWordStart, offset};
                }
            } else if (id != null && id.length() != 0 && id.indexOf(".") != -1) {
                int index = offset - idStart;
                int begin = id.substring(0, index).lastIndexOf(".");
                begin = begin == -1 ? 0 : begin + 1;
                int end = id.indexOf(".", index);
                end = end == -1 ? id.length() : end;
                ret = new int[]{idStart + begin, idStart + end};
            }
        }
        return ret;
    }

    public static int[] getIdentifierBlock(BaseDocument doc, int offset) throws BadLocationException {
        int idEnd;
        int[] ret = null;
        int idStart = Utilities.getWordStart(doc, offset);
        if (idStart >= 0 && (idEnd = Utilities.getWordEnd(doc, idStart)) >= 0) {
            String id = doc.getText(idStart, idEnd - idStart);
            if (doc.getSyntaxSupport().isIdentifier(id)) {
                ret = new int[]{idStart, idEnd};
            } else {
                id = Utilities.getWord(doc, offset);
                if (doc.getSyntaxSupport().isIdentifier(id)) {
                    ret = new int[]{offset, offset + id.length()};
                }
            }
        }
        return ret;
    }

    public static String getWord(JTextComponent c, int offset) throws BadLocationException {
        int[] blk = Utilities.getIdentifierBlock(c, offset);
        Document doc = c.getDocument();
        return blk != null ? doc.getText(blk[0], blk[1] - blk[0]) : null;
    }

    public static int[] getSelectionOrIdentifierBlock(JTextComponent c, int offset) throws BadLocationException {
        Document doc = c.getDocument();
        Caret caret = c.getCaret();
        int[] ret = caret.isSelectionVisible() ? new int[]{c.getSelectionStart(), c.getSelectionEnd()} : (doc instanceof BaseDocument ? Utilities.getIdentifierBlock((BaseDocument)doc, caret.getDot()) : Utilities.getIdentifierBlock(c, offset));
        return ret;
    }

    public static int[] getSelectionOrIdentifierBlock(JTextComponent c) {
        try {
            return Utilities.getSelectionOrIdentifierBlock(c, c.getCaret().getDot());
        }
        catch (BadLocationException e) {
            return null;
        }
    }

    public static String getIdentifierBefore(BaseDocument doc, int offset) throws BadLocationException {
        int wordStart = Utilities.getWordStart(doc, offset);
        if (wordStart != -1) {
            String word = new String(doc.getChars(wordStart, offset - wordStart), 0, offset - wordStart);
            if (doc.getSyntaxSupport().isIdentifier(word)) {
                return word;
            }
        }
        return null;
    }

    public static String getSelectionOrIdentifier(JTextComponent c, int offset) throws BadLocationException {
        String ret;
        Document doc = c.getDocument();
        Caret caret = c.getCaret();
        if (caret.isSelectionVisible() && (ret = c.getSelectedText()) != null) {
            return ret;
        }
        ret = doc instanceof BaseDocument ? Utilities.getIdentifier((BaseDocument)doc, caret.getDot()) : Utilities.getWord(c, offset);
        return ret;
    }

    public static String getSelectionOrIdentifier(JTextComponent c) {
        try {
            return Utilities.getSelectionOrIdentifier(c, c.getCaret().getDot());
        }
        catch (BadLocationException e) {
            return null;
        }
    }

    public static String getWord(BaseDocument doc, int offset) throws BadLocationException {
        int wordEnd = Utilities.getWordEnd(doc, offset);
        if (wordEnd != -1) {
            return new String(doc.getChars(offset, wordEnd - offset), 0, wordEnd - offset);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean changeCase(BaseDocument doc, int offset, int len, int type) throws BadLocationException {
        int i;
        char[] orig = doc.getChars(offset, len);
        char[] changed = (char[])orig.clone();
        block8: for (i = 0; i < orig.length; ++i) {
            switch (type) {
                case 0: {
                    changed[i] = Character.toUpperCase(orig[i]);
                    continue block8;
                }
                case 1: {
                    changed[i] = Character.toLowerCase(orig[i]);
                    continue block8;
                }
                case 2: {
                    if (Character.isUpperCase(orig[i])) {
                        changed[i] = Character.toLowerCase(orig[i]);
                        continue block8;
                    }
                    if (!Character.isLowerCase(orig[i])) continue block8;
                    changed[i] = Character.toUpperCase(orig[i]);
                }
            }
        }
        for (i = 0; i < orig.length; ++i) {
            if (orig[i] == changed[i]) continue;
            doc.atomicLock();
            try {
                doc.remove(offset, orig.length);
                doc.insertString(offset, new String(changed), null);
            }
            finally {
                doc.atomicUnlock();
            }
            return true;
        }
        return false;
    }

    public static boolean isRowEmpty(BaseDocument doc, int offset) throws BadLocationException {
        Element lineElement = doc.getParagraphElement(offset);
        return lineElement.getStartOffset() + 1 == lineElement.getEndOffset();
    }

    public static int getFirstNonEmptyRow(BaseDocument doc, int offset, boolean downDir) throws BadLocationException {
        while (offset != -1 && Utilities.isRowEmpty(doc, offset)) {
            offset = Utilities.getRowStart(doc, offset, downDir ? 1 : -1);
        }
        return offset;
    }

    public static boolean isRowWhite(BaseDocument doc, int offset) throws BadLocationException {
        Element lineElement = doc.getParagraphElement(offset);
        return (offset = doc.find(new FinderFactory.NonWhiteFwdFinder(doc), lineElement.getStartOffset(), lineElement.getEndOffset() - 1)) == -1;
    }

    public static int getFirstNonWhiteRow(BaseDocument doc, int offset, boolean downDir) throws BadLocationException {
        if (Utilities.isRowWhite(doc, offset)) {
            offset = downDir ? Utilities.getFirstNonWhiteFwd(doc, offset) : Utilities.getFirstNonWhiteBwd(doc, offset);
        }
        return offset;
    }

    public static int reformat(BaseDocument doc, int startOffset, int endOffset) throws BadLocationException {
        return doc.getFormatter().reformat(doc, startOffset, endOffset);
    }

    public static void reformatLine(BaseDocument doc, int pos) throws BadLocationException {
        int lineStart = Utilities.getRowStart(doc, pos);
        int lineEnd = Utilities.getRowEnd(doc, pos);
        Utilities.reformat(doc, lineStart, lineEnd);
    }

    public static int getRowCount(BaseDocument doc, int startPos, int endPos) throws BadLocationException {
        if (startPos > endPos) {
            return 0;
        }
        Element lineRoot = doc.getParagraphElement(0).getParentElement();
        return lineRoot.getElementIndex(endPos) - lineRoot.getElementIndex(startPos) + 1;
    }

    public static int getRowCount(BaseDocument doc) {
        return doc.getParagraphElement(0).getParentElement().getElementCount();
    }

    public static String getTabInsertString(BaseDocument doc, int offset) throws BadLocationException {
        int col = Utilities.getVisualColumn(doc, offset);
        Formatter f = doc.getFormatter();
        boolean expandTabs = f.expandTabs();
        if (expandTabs) {
            int spacesPerTab = f.getSpacesPerTab();
            int len = (col + spacesPerTab) / spacesPerTab * spacesPerTab - col;
            return new String(Analyzer.getSpacesBuffer(len), 0, len);
        }
        return "\t";
    }

    public static int getNextTabColumn(BaseDocument doc, int offset) throws BadLocationException {
        int col = Utilities.getVisualColumn(doc, offset);
        int tabSize = doc.getFormatter().getSpacesPerTab();
        return (col + tabSize) / tabSize * tabSize;
    }

    public static void setStatusText(JTextComponent c, String text) {
        StatusBar sb = Utilities.getEditorUI(c).getStatusBar();
        if (sb != null) {
            sb.setText("main", text);
        }
    }

    public static void setStatusText(JTextComponent c, String text, Coloring extraColoring) {
        StatusBar sb = Utilities.getEditorUI(c).getStatusBar();
        if (sb != null) {
            sb.setText("main", text, extraColoring);
        }
    }

    public static void setStatusBoldText(JTextComponent c, String text) {
        StatusBar sb = Utilities.getEditorUI(c).getStatusBar();
        if (sb != null) {
            sb.setBoldText("main", text);
        }
    }

    public static String getStatusText(JTextComponent c) {
        StatusBar sb = Utilities.getEditorUI(c).getStatusBar();
        return sb != null ? sb.getText("main") : null;
    }

    public static void clearStatusText(JTextComponent c) {
        Utilities.setStatusText(c, "");
    }

    public static void insertMark(BaseDocument doc, Mark mark, int offset) throws BadLocationException, InvalidMarkException {
        mark.insert(doc, offset);
    }

    public static void moveMark(BaseDocument doc, Mark mark, int newOffset) throws BadLocationException, InvalidMarkException {
        mark.move(doc, newOffset);
    }

    public static void returnFocus() {
        JTextComponent c = Utilities.getLastActiveComponent();
        if (c != null) {
            Utilities.requestFocus(c);
        }
    }

    public static void requestFocus(JTextComponent c) {
        if (c != null && !ImplementationProvider.getDefault().activateComponent(c)) {
            Frame f = EditorUI.getParentFrame(c);
            if (f != null) {
                f.requestFocus();
            }
            c.requestFocus();
        }
    }

    public static void runInEventDispatchThread(Runnable r) {
        if (SwingUtilities.isEventDispatchThread()) {
            r.run();
        } else {
            SwingUtilities.invokeLater(r);
        }
    }

    public static String debugPosition(BaseDocument doc, int offset) {
        String ret;
        if (offset >= 0) {
            try {
                int line = Utilities.getLineOffset(doc, offset) + 1;
                int col = Utilities.getVisualColumn(doc, offset) + 1;
                ret = String.valueOf(line) + ":" + String.valueOf(col);
            }
            catch (BadLocationException e) {
                ret = LocaleSupport.getString(WRONG_POSITION_LOCALE) + ' ' + offset + " > " + doc.getLength();
            }
        } else {
            ret = String.valueOf(offset);
        }
        return ret;
    }

    public static String offsetToLineColumnString(BaseDocument doc, int offset) {
        return String.valueOf(offset) + "[" + Utilities.debugPosition(doc, offset) + "]";
    }

    public static String debugDocument(Document doc) {
        return "<" + System.identityHashCode(doc) + ", title='" + doc.getProperty("title") + "', stream='" + doc.getProperty("stream") + ", " + doc.toString() + ">";
    }

    public static void performAction(Action a, ActionEvent evt, JTextComponent target) {
        if (a instanceof BaseAction) {
            ((BaseAction)a).actionPerformed(evt, target);
        } else {
            a.actionPerformed(evt);
        }
    }

    public static JTextComponent getLastActiveComponent() {
        return Registry.getMostActiveComponent();
    }

    public static JTextComponent getFocusedComponent() {
        class FocusedComponentAction
        extends TextAction {
            FocusedComponentAction() {
                super("focused-component");
            }

            JTextComponent getFocusedComponent2() {
                return this.getFocusedComponent();
            }

            public void actionPerformed(ActionEvent evt) {
            }
        }
        if (focusedComponentAction == null) {
            focusedComponentAction = new FocusedComponentAction();
        }
        return ((FocusedComponentAction)focusedComponentAction).getFocusedComponent2();
    }

    public static EditorUI getEditorUI(JTextComponent target) {
        TextUI ui = target.getUI();
        return ui instanceof BaseTextUI ? ((BaseTextUI)ui).getEditorUI() : null;
    }

    public static BaseKit getKit(JTextComponent target) {
        if (target == null) {
            return null;
        }
        EditorKit ekit = target.getUI().getEditorKit(target);
        return ekit instanceof BaseKit ? (BaseKit)ekit : null;
    }

    public static Class getKitClass(JTextComponent target) {
        return target != null ? target.getUI().getEditorKit(target).getClass() : null;
    }

    public static BaseDocument getDocument(JTextComponent target) {
        Document doc = target.getDocument();
        return doc instanceof BaseDocument ? (BaseDocument)doc : null;
    }

    public static SyntaxSupport getSyntaxSupport(JTextComponent target) {
        Document doc = target.getDocument();
        return doc instanceof BaseDocument ? ((BaseDocument)doc).getSyntaxSupport() : null;
    }

    public static View getRootView(JTextComponent component, Class rootViewClass) {
        View view = null;
        TextUI textUI = component.getUI();
        if (textUI != null) {
            for (view = textUI.getRootView(component); view != null && !rootViewClass.isInstance(view) && view.getViewCount() == 1; view = view.getView(0)) {
            }
        }
        return view;
    }

    public static View getDocumentView(JTextComponent component) {
        return Utilities.getRootView(component, class$org$netbeans$editor$DrawEngineDocView == null ? (class$org$netbeans$editor$DrawEngineDocView = Utilities.class$("org.netbeans.editor.DrawEngineDocView")) : class$org$netbeans$editor$DrawEngineDocView);
    }

    public static String keySequenceToString(KeyStroke[] seq) {
        StringBuffer sb = new StringBuffer();
        for (int i = 0; i < seq.length; ++i) {
            if (i > 0) {
                sb.append(' ');
            }
            sb.append(Utilities.keyStrokeToString(seq[i]));
        }
        return sb.toString();
    }

    public static String keyStrokeToString(KeyStroke stroke) {
        String keyText;
        String modifText = KeyEvent.getKeyModifiersText(stroke.getModifiers());
        String string = keyText = stroke.getKeyCode() == 0 ? String.valueOf(stroke.getKeyChar()) : Utilities.getKeyText(stroke.getKeyCode());
        if (modifText.length() > 0) {
            return modifText + '+' + keyText;
        }
        return keyText;
    }

    private static String getKeyText(int keyCode) {
        String ret = KeyEvent.getKeyText(keyCode);
        if (ret != null) {
            switch (keyCode) {
                case 225: {
                    ret = Utilities.prefixNumpad(ret, 40);
                    break;
                }
                case 226: {
                    ret = Utilities.prefixNumpad(ret, 37);
                    break;
                }
                case 227: {
                    ret = Utilities.prefixNumpad(ret, 39);
                    break;
                }
                case 224: {
                    ret = Utilities.prefixNumpad(ret, 38);
                }
            }
        }
        return ret;
    }

    private static String prefixNumpad(String key, int testKeyCode) {
        if (key.equals(KeyEvent.getKeyText(testKeyCode))) {
            key = LocaleSupport.getString("key-prefix-numpad") + key;
        }
        return key;
    }

    private static void checkOffsetValid(Document doc, int offset) throws BadLocationException {
        Utilities.checkOffsetValid(offset, doc.getLength());
    }

    private static void checkOffsetValid(int offset, int limitOffset) throws BadLocationException {
        if (offset < 0 || offset > limitOffset) {
            throw new BadLocationException("Invalid offset=" + offset + " not within <0, " + limitOffset + ">", offset);
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

