/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.editor.ext;

import java.awt.Color;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.StringTokenizer;
import javax.swing.JList;
import javax.swing.SwingUtilities;
import javax.swing.Timer;
import javax.swing.event.CaretEvent;
import javax.swing.event.CaretListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.text.JTextComponent;
import org.netbeans.editor.LocaleSupport;
import org.netbeans.editor.Settings;
import org.netbeans.editor.SettingsChangeEvent;
import org.netbeans.editor.SettingsChangeListener;
import org.netbeans.editor.SettingsUtil;
import org.netbeans.editor.Utilities;
import org.netbeans.editor.WeakTimerListener;
import org.netbeans.editor.ext.Completion;
import org.netbeans.editor.ext.CompletionJavaDoc;
import org.netbeans.editor.ext.ExtEditorUI;
import org.netbeans.editor.ext.ExtSettingsDefaults;
import org.netbeans.editor.ext.HTMLJavaDocView;
import org.netbeans.editor.ext.JDCPopupPanel;
import org.netbeans.editor.ext.JavaDocPane;
import org.netbeans.editor.ext.JavaDocView;
import org.netbeans.editor.ext.ScrollJavaDocPane;
import org.netbeans.editor.ext.java.JCClass;
import org.netbeans.editor.ext.java.JavaCompletion;

public class CompletionJavaDoc
implements ActionListener,
SettingsChangeListener,
PropertyChangeListener {
    protected ExtEditorUI extEditorUI;
    private List history = new ArrayList(5);
    private int curHistoryItem = -1;
    private JavaDocPane pane;
    private JavaDocView view;
    private int javaDocDelay;
    private Timer timer;
    protected Object currentContent;
    protected boolean addToHistory;
    private ListSelectionListener completionListener;
    private boolean javaDocAutoPopup;
    private CaretListener caretL;
    public static final String BUNDLE_PREFIX = "javadoc-tag-";
    public static final String LOADING = "javadoc-loading";
    private static ArrayList omittedTags = new ArrayList();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CompletionJavaDoc(ExtEditorUI extEditorUI) {
        this.extEditorUI = extEditorUI;
        this.timer = new Timer(0, new WeakTimerListener(this));
        this.timer.setRepeats(false);
        Settings.addSettingsChangeListener(this);
        this.javaDocDelay = this.getJavaDocDelay();
        this.javaDocAutoPopup = this.getJavaDocAutoPopup();
        ExtEditorUI extUI = extEditorUI;
        class SelectionObserver
        implements ListSelectionListener {
            private final /* synthetic */ ExtEditorUI val$extUI;

            SelectionObserver(ExtEditorUI val$extUI) {
                this.val$extUI = val$extUI;
            }

            public void valueChanged(ListSelectionEvent e) {
                class ClearTask
                implements Runnable {
                    private final /* synthetic */ ExtEditorUI val$extUI;
                    private final /* synthetic */ CompletionJavaDoc this$0;

                    ClearTask(CompletionJavaDoc this$0, ExtEditorUI val$extUI) {
                        this.this$0 = this$0;
                        this.val$extUI = val$extUI;
                    }

                    public void run() {
                        CompletionJavaDoc completionJavaDoc;
                        Completion com = this.val$extUI.getCompletion();
                        if (com != null && com.isPaneVisible() && (completionJavaDoc = this.val$extUI.getCompletionJavaDoc()) != null) {
                            if (completionJavaDoc.autoPopup()) {
                                if (this.this$0.currentContent != null && !"javadoc-loading".equals(this.this$0.currentContent) && this.this$0.currentContent.equals(com.getSelectedValue())) {
                                    if (!this.this$0.isVisible()) {
                                        this.this$0.setJavaDocVisible(true);
                                    }
                                    return;
                                }
                                if (!"javadoc-loading".equals(this.this$0.currentContent)) {
                                    completionJavaDoc.setContent(LocaleSupport.getString("javadoc-loading"));
                                }
                                this.this$0.clearHistory();
                                completionJavaDoc.setContent(com.getSelectedValue());
                                this.this$0.addToHistory(com.getSelectedValue());
                            } else {
                                completionJavaDoc.setContent(null);
                            }
                        }
                    }
                }
                SwingUtilities.invokeLater(new ClearTask(CompletionJavaDoc.this, this.val$extUI));
            }
        }
        this.completionListener = new SelectionObserver(extUI);
        Completion completion = extEditorUI.getCompletion();
        if (completion != null && completion.getView() instanceof JList) {
            JList completionList = (JList)((Object)completion.getView());
            completionList.addListSelectionListener(this.completionListener);
        }
        class MyCaretListener
        implements CaretListener {
            private final /* synthetic */ ExtEditorUI val$extUI;

            MyCaretListener(ExtEditorUI val$extUI) {
                this.val$extUI = val$extUI;
            }

            public void caretUpdate(CaretEvent e) {
                Completion com = this.val$extUI.getCompletion();
                if (com == null) {
                    return;
                }
                JDCPopupPanel panel = com.getJDCPopupPanelIfExists();
                if (panel == null) {
                    return;
                }
                if (panel.isVisible() && !com.isPaneVisible()) {
                    CompletionJavaDoc.this.setJavaDocVisible(false);
                }
            }
        }
        this.caretL = new MyCaretListener(extUI);
        Object object = extEditorUI.getComponentLock();
        synchronized (object) {
            JTextComponent component = extEditorUI.getComponent();
            if (component != null) {
                this.propertyChange(new PropertyChangeEvent(extEditorUI, "component", null, component));
            }
            extEditorUI.addPropertyChangeListener(this);
        }
    }

    public void propertyChange(PropertyChangeEvent evt) {
        String propName = evt.getPropertyName();
        if ("component".equals(propName)) {
            JTextComponent component = (JTextComponent)evt.getNewValue();
            if (component != null) {
                component.addCaretListener(this.caretL);
            } else {
                this.cancelPerformingThread();
                component = (JTextComponent)evt.getOldValue();
                if (component != null) {
                    component.removeCaretListener(this.caretL);
                }
            }
        }
    }

    private JDCPopupPanel getJDCPopupPanel() {
        Completion completion = this.extEditorUI.getCompletion();
        if (completion != null) {
            return completion.getJDCPopupPanelIfExists();
        }
        return null;
    }

    public JavaDocPane getJavaDocPane() {
        Completion completion = this.extEditorUI.getCompletion();
        if (completion != null) {
            return completion.getJDCPopupPanel().getJavaDocPane();
        }
        if (this.pane == null) {
            this.pane = new ScrollJavaDocPane(this.extEditorUI);
        }
        return this.pane;
    }

    public JavaDocView getJavaDocView() {
        if (this.view == null) {
            this.view = new HTMLJavaDocView(this.getJavaDocBGColor());
        }
        return this.view;
    }

    public void setJavaDocVisible(final boolean visible) {
        final JDCPopupPanel jdc = this.getJDCPopupPanel();
        if (jdc != null) {
            this.getJavaDocPane().setShowWebEnabled(this.isExternalJavaDocMounted());
            if (!SwingUtilities.isEventDispatchThread()) {
                SwingUtilities.invokeLater(new Runnable(){

                    public void run() {
                        jdc.setJavaDocVisible(visible);
                    }
                });
            } else {
                jdc.setJavaDocVisible(visible);
            }
        }
    }

    public synchronized void addToHistory(Object url) {
        int histSize = this.history.size();
        for (int i = this.curHistoryItem + 1; i < histSize; ++i) {
            this.history.remove(this.history.size() - 1);
        }
        this.history.add(url);
        this.curHistoryItem = this.history.size() - 1;
        if (this.curHistoryItem > 0) {
            this.getJavaDocPane().setBackEnabled(true);
        }
        this.getJavaDocPane().setForwardEnabled(false);
    }

    public synchronized void backHistory() {
        if (this.curHistoryItem > 0) {
            --this.curHistoryItem;
            this.setContent(this.history.get(this.curHistoryItem), false, false);
            if (this.curHistoryItem == 0) {
                this.getJavaDocPane().setBackEnabled(false);
            }
            this.getJavaDocPane().setForwardEnabled(true);
        }
    }

    public synchronized void forwardHistory() {
        if (this.curHistoryItem < this.history.size() - 1) {
            ++this.curHistoryItem;
            this.setContent(this.history.get(this.curHistoryItem), false, false);
            if (this.curHistoryItem == this.history.size() - 1) {
                this.getJavaDocPane().setForwardEnabled(false);
            }
            this.getJavaDocPane().setBackEnabled(true);
        }
    }

    public synchronized void clearHistory() {
        this.curHistoryItem = -1;
        this.history.clear();
        this.getJavaDocPane().setBackEnabled(false);
        this.getJavaDocPane().setForwardEnabled(false);
    }

    public boolean isVisible() {
        return this.getJavaDocPane().getComponent().isVisible();
    }

    public void cancelPerformingThread() {
        this.timer.stop();
    }

    public synchronized void setContent(Object content, boolean postRequest, boolean addToHistory) {
        this.timer.stop();
        if (content == null) {
            this.setJavaDocVisible(false);
            this.currentContent = null;
            return;
        }
        this.currentContent = content;
        this.addToHistory = addToHistory;
        if (postRequest) {
            this.timer.setInitialDelay(this.javaDocDelay);
            this.timer.setDelay(this.javaDocDelay);
            this.timer.start();
        } else {
            this.actionPerformed(null);
        }
    }

    public synchronized void setContent(Object content, boolean postRequest) {
        this.setContent(content, postRequest, true);
    }

    public void setContent(Object content) {
        this.setContent(content, true);
    }

    public void setContent(String content) {
        if (content == null) {
            this.setJavaDocVisible(false);
            return;
        }
        this.getJavaDocView().setContent(content);
    }

    public synchronized void actionPerformed(ActionEvent e) {
    }

    private Color getJavaDocBGColor() {
        Class kitClass = Utilities.getKitClass(this.extEditorUI.getComponent());
        if (kitClass != null) {
            return (Color)SettingsUtil.getValue(kitClass, "javadoc-bg-color", ExtSettingsDefaults.defaultJavaDocBGColor);
        }
        return ExtSettingsDefaults.defaultJavaDocBGColor;
    }

    private int getJavaDocDelay() {
        Class kitClass = Utilities.getKitClass(this.extEditorUI.getComponent());
        if (kitClass != null) {
            return (Integer)SettingsUtil.getValue(kitClass, "javadoc-auto-popup-delay", ExtSettingsDefaults.defaultJavaDocAutoPopupDelay);
        }
        return ExtSettingsDefaults.defaultJavaDocAutoPopupDelay;
    }

    private boolean getJavaDocAutoPopup() {
        Class kitClass = Utilities.getKitClass(this.extEditorUI.getComponent());
        if (kitClass != null) {
            return (Boolean)SettingsUtil.getValue(kitClass, "javadoc-auto-popup", ExtSettingsDefaults.defaultJavaDocAutoPopup);
        }
        return ExtSettingsDefaults.defaultJavaDocAutoPopup;
    }

    public boolean autoPopup() {
        return this.javaDocAutoPopup;
    }

    public void settingsChange(SettingsChangeEvent evt) {
        if ("javadoc-bg-color".equals(evt.getSettingName())) {
            this.getJavaDocView().setBGColor(this.getJavaDocBGColor());
        }
        if ("javadoc-auto-popup-delay".equals(evt.getSettingName())) {
            this.javaDocDelay = this.getJavaDocDelay();
        }
        if ("javadoc-auto-popup".equals(evt.getSettingName())) {
            this.javaDocAutoPopup = this.getJavaDocAutoPopup();
        }
    }

    public String prepareJavaDocContent(JCClass cls, String member, String content) {
        return this.prepareJavaDocContent(cls, member, content, null);
    }

    public boolean isOmittedJavaDocTag(String tag) {
        return omittedTags.contains(tag);
    }

    public Object parseLink(String link, JCClass cls) {
        return null;
    }

    protected boolean isNotFullyQualifiedInnerClass(String inner, JCClass cls) {
        if (inner.indexOf(".") != inner.lastIndexOf(".")) {
            return false;
        }
        String pkgName = cls.getPackageName();
        return JavaCompletion.getFinder().getExactClass(pkgName.length() > 0 ? pkgName + "." + inner : inner) != null;
    }

    protected String findProperClass(String name, JCClass cls) {
        if (cls == null) {
            return null;
        }
        String ret = null;
        JCClass retClass = cls.getPackageName() != null && cls.getPackageName().length() > 0 ? JavaCompletion.getFinder().getExactClass(cls.getPackageName() + "." + name) : JavaCompletion.getFinder().getExactClass(name);
        if (retClass != null) {
            return retClass.getFullName();
        }
        List classes = JavaCompletion.getFinder().findClasses(null, name, true);
        if (classes.size() > 0) {
            ret = ((JCClass)classes.get(0)).getFullName();
        }
        return ret;
    }

    public String createAnchor(String prm, JCClass cls) {
        StringBuffer ret = new StringBuffer(prm.length() + 50);
        String label = "";
        int lastParenthesisOccurence = prm.lastIndexOf(")");
        boolean linkedObjectExists = this.parseLink(prm, cls) != null;
        int indexOfSpaceAfterLastParenthesis = prm.indexOf(" ", lastParenthesisOccurence);
        if (indexOfSpaceAfterLastParenthesis > 0) {
            label = prm.substring(indexOfSpaceAfterLastParenthesis + 1);
        }
        if (prm.length() > 0 && prm.charAt(0) == '#') {
            if (linkedObjectExists) {
                ret.append("<a href='").append(cls.getFullName()).append(label.length() > 0 ? prm.substring(0, indexOfSpaceAfterLastParenthesis) : prm).append("'><code>").append(label.length() > 0 ? label : prm.substring(1)).append("</code></a>");
            } else {
                ret.append("<code>").append(label.length() > 0 ? label : prm.substring(1)).append("</code>");
            }
        } else if (linkedObjectExists) {
            String href;
            String string = href = label.length() > 0 ? prm.substring(0, indexOfSpaceAfterLastParenthesis) : prm;
            if (href.indexOf(".") < 0 || this.isNotFullyQualifiedInnerClass(href, cls)) {
                String refCls = href.indexOf("#") > 0 ? href.substring(0, href.indexOf("#")) : href;
                String refMember = href.indexOf("#") > 0 ? href.substring(href.indexOf("#") + 1) : "";
                String fullClassName = this.findProperClass(refCls, cls);
                if (fullClassName != null) {
                    href = refMember.length() > 0 ? fullClassName + "#" + refMember : fullClassName;
                } else {
                    return "<a href='" + href + "'><code>" + (label.length() > 0 ? label : prm.replace('#', '.')) + "</code></a>";
                }
            }
            ret.append("<a href='").append(href).append("'><code>").append(label.length() > 0 ? label : prm.replace('#', '.')).append("</code></a>");
        } else {
            ret.append("<code>").append(label.length() > 0 ? label : prm.replace('#', '.')).append("</code>");
        }
        return ret.toString();
    }

    public String createLinks(String content, JCClass cls) {
        StringBuffer ret = new StringBuffer(content.length());
        StringTokenizer strTok = new StringTokenizer(content, "{");
        String next = "";
        boolean linkAppended = false;
        boolean useOriginalContent = true;
        while (strTok.hasMoreTokens()) {
            next = strTok.nextToken("{");
            if (linkAppended && next.length() > 0 && next.charAt(0) == '}') {
                next = next.substring(1);
            }
            linkAppended = false;
            if (strTok.hasMoreTokens()) {
                String link = strTok.nextToken("}");
                int indexOfLink = link.indexOf("@link");
                if (indexOfLink > 0 && link.length() > 6 && Character.isWhitespace(link.charAt(link.indexOf("@link") + 5))) {
                    useOriginalContent = false;
                    int linkPos = indexOfLink + 6;
                    if (next.length() > 0 && next.charAt(0) == '}') {
                        next = next.substring(1);
                    }
                    link = this.createAnchor(link.substring(linkPos).trim(), cls);
                    linkAppended = true;
                }
                ret.append(next);
                ret.append(link);
                continue;
            }
            ret.append(next);
        }
        return useOriginalContent ? content : ret.toString();
    }

    public String prepareJavaDocContent(JCClass cls, String member, String content, JavaDocTagItem[] tags) {
        content = content != null ? this.createLinks(content, cls) : "";
        StringBuffer sb = new StringBuffer(512);
        sb.append("<font size='+0'><b>").append(this.createAnchor(cls.getFullName(), cls)).append("</b></font>");
        if (member.length() > 0) {
            sb.append("<pre>").append(member).append("</pre>");
        }
        sb.append("<blockquote>").append(content).append("</blockquote>");
        if (tags != null) {
            Arrays.sort(tags);
            String curParam = "";
            int curItem = 0;
            for (int i = 0; i < tags.length; ++i) {
                if (!curParam.equals(tags[i].getName())) {
                    if (this.isOmittedJavaDocTag(tags[i].getName())) continue;
                    if (!curParam.equals("")) {
                        sb.append("</blockquote>");
                    }
                    sb.append("<b>").append(LocaleSupport.getString(BUNDLE_PREFIX + tags[i].getName(), tags[i].getName())).append("</b><blockquote>");
                    curParam = tags[i].getName();
                    curItem = 0;
                }
                if (curItem > 0) {
                    sb.append("<br>");
                }
                if (curParam.equals("@param")) {
                    String prm = tags[i].getText();
                    int spacePos = prm.indexOf(" ");
                    if (spacePos > 0) {
                        String anchoredText = this.createLinks(prm.substring(spacePos), cls);
                        sb.append("<code>").append(prm.substring(0, spacePos)).append("</code> - ").append(anchoredText);
                    } else {
                        sb.append(prm);
                    }
                } else if (curParam.equals("@see")) {
                    char first;
                    String txt = tags[i].getText();
                    char c = first = txt.length() > 0 ? txt.charAt(0) : (char)'\u0000';
                    if (first == '\"') {
                        txt = txt.length() > 1 && txt.charAt(txt.length() - 1) == '\"' ? txt.substring(1, txt.length() - 1) : txt.substring(1, txt.length());
                        sb.append(txt);
                    } else if (first == '<') {
                        sb.append(txt);
                    } else {
                        sb.append(this.createAnchor(txt, cls));
                    }
                } else {
                    sb.append(this.createLinks(tags[i].getText(), cls));
                }
                ++curItem;
            }
            if (!curParam.equals("")) {
                sb.append("</blockquote>");
            }
        }
        return sb.toString();
    }

    public void goToSource() {
    }

    public void openInExternalBrowser() {
    }

    public boolean isExternalJavaDocMounted() {
        return false;
    }

    static {
        omittedTags.add("@serial");
        omittedTags.add("@serialField");
        omittedTags.add("@serialData");
        omittedTags.add("@author");
        omittedTags.add("@version");
        omittedTags.add("@beaninfo");
    }

    public static interface JavaDocTagItem
    extends Comparable {
        public String getName();

        public String getText();
    }
}

