/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.editor.ext;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JTextArea;
import javax.swing.JToolTip;
import javax.swing.JViewport;
import javax.swing.SwingUtilities;
import javax.swing.Timer;
import javax.swing.ToolTipManager;
import javax.swing.UIManager;
import javax.swing.text.BadLocationException;
import javax.swing.text.JTextComponent;
import org.netbeans.editor.BaseDocument;
import org.netbeans.editor.BaseKit;
import org.netbeans.editor.BaseTextUI;
import org.netbeans.editor.GlyphGutter;
import org.netbeans.editor.PopupManager;
import org.netbeans.editor.Settings;
import org.netbeans.editor.SettingsChangeEvent;
import org.netbeans.editor.SettingsChangeListener;
import org.netbeans.editor.Utilities;
import org.netbeans.editor.WeakTimerListener;
import org.netbeans.editor.ext.ExtEditorUI;

public class ToolTipSupport
extends MouseAdapter
implements MouseMotionListener,
ActionListener,
PropertyChangeListener,
SettingsChangeListener,
FocusListener {
    public static final String PROP_TOOL_TIP = "toolTip";
    public static final String PROP_TOOL_TIP_TEXT = "toolTipText";
    public static final String PROP_STATUS = "status";
    public static final String PROP_ENABLED = "enabled";
    public static final String PROP_INITIAL_DELAY = "initialDelay";
    public static final String PROP_DISMISS_DELAY = "dismissDelay";
    private static final String UI_PREFIX = "ToolTip";
    public static final int INITIAL_DELAY = 1000;
    public static final int DISMISS_DELAY = 60000;
    public static final int STATUS_HIDDEN = 0;
    public static final int STATUS_VISIBILITY_ENABLED = 1;
    public static final int STATUS_TEXT_VISIBLE = 2;
    public static final int STATUS_COMPONENT_VISIBLE = 3;
    private static final int MOUSE_EXTRA_HEIGHT = 5;
    private ExtEditorUI extEditorUI;
    private JComponent toolTip;
    private String toolTipText;
    private Timer enterTimer;
    private Timer exitTimer;
    private boolean enabled;
    private int status;
    private MouseEvent lastMouseEvent;
    private PropertyChangeSupport pcs;
    private PopupManager.HorizontalBounds horizontalBounds = PopupManager.ViewPortBounds;
    private PopupManager.Placement placement = PopupManager.AbovePreferred;
    private int verticalAdjustment;
    private int horizontalAdjustment;
    private boolean glyphListenerAdded = false;
    static /* synthetic */ Class class$org$netbeans$editor$PopupManager$Placement;
    static /* synthetic */ Class class$java$lang$String;

    public ToolTipSupport(ExtEditorUI extEditorUI) {
        this.extEditorUI = extEditorUI;
        this.enterTimer = new Timer(1000, new WeakTimerListener(this));
        this.enterTimer.setRepeats(false);
        this.exitTimer = new Timer(60000, new WeakTimerListener(this));
        this.exitTimer.setRepeats(false);
        Settings.addSettingsChangeListener(this);
        extEditorUI.addPropertyChangeListener(this);
        this.setEnabled(true);
    }

    public final JComponent getToolTip() {
        if (this.toolTip == null) {
            this.setToolTip(this.createDefaultToolTip());
        }
        return this.toolTip;
    }

    public void setToolTip(JComponent toolTip) {
        this.setToolTip(toolTip, PopupManager.ViewPortBounds, PopupManager.AbovePreferred);
    }

    public void setToolTip(JComponent toolTip, PopupManager.HorizontalBounds horizontalBounds, PopupManager.Placement placement) {
        this.setToolTip(toolTip, PopupManager.ViewPortBounds, PopupManager.AbovePreferred, 0, 0);
    }

    public void setToolTip(JComponent toolTip, PopupManager.HorizontalBounds horizontalBounds, PopupManager.Placement placement, int horizontalAdjustment, int verticalAdjustment) {
        JComponent oldToolTip = this.toolTip;
        this.toolTip = toolTip;
        this.horizontalBounds = horizontalBounds;
        this.placement = placement;
        this.horizontalAdjustment = horizontalAdjustment;
        this.verticalAdjustment = verticalAdjustment;
        if (this.status >= 1) {
            this.ensureVisibility();
        }
        this.firePropertyChange(PROP_TOOL_TIP, oldToolTip, this.toolTip);
    }

    protected JComponent createDefaultToolTip() {
        return this.createTextToolTip();
    }

    private JTextArea createTextToolTip() {
        JTextArea tt = new JTextArea(){

            public void setSize(int width, int height) {
                int docLen = this.getDocument().getLength();
                if (docLen > 0) {
                    this.setLineWrap(false);
                    Dimension prefSize = this.getPreferredSize();
                    if (width > prefSize.width) {
                        width = prefSize.width;
                        height = height >= prefSize.height ? prefSize.height : -1;
                    } else {
                        this.setLineWrap(true);
                        super.setSize(width, 100000);
                        try {
                            Rectangle r = this.modelToView(docLen - 1);
                            int prefHeight = r.y + r.height;
                            height = prefHeight < height ? prefHeight : -1;
                        }
                        catch (BadLocationException e) {
                            // empty catch block
                        }
                    }
                }
                if (height >= 0) {
                    super.setSize(width, height);
                } else {
                    this.putClientProperty(class$org$netbeans$editor$PopupManager$Placement == null ? (class$org$netbeans$editor$PopupManager$Placement = ToolTipSupport.class$("org.netbeans.editor.PopupManager$Placement")) : class$org$netbeans$editor$PopupManager$Placement, null);
                }
            }
        };
        Font font = UIManager.getFont("ToolTip.font");
        Color backColor = UIManager.getColor("ToolTip.background");
        Color foreColor = UIManager.getColor("ToolTip.foreground");
        if (font != null) {
            tt.setFont(font);
        }
        if (foreColor != null) {
            tt.setForeground(foreColor);
        }
        if (backColor != null) {
            tt.setBackground(backColor);
        }
        tt.setOpaque(true);
        tt.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createLineBorder(tt.getForeground()), BorderFactory.createEmptyBorder(0, 3, 0, 3)));
        return tt;
    }

    public void settingsChange(SettingsChangeEvent evt) {
    }

    public void propertyChange(PropertyChangeEvent evt) {
        JComponent component;
        String propName = evt.getPropertyName();
        if ("component".equals(propName)) {
            component = (JTextComponent)evt.getNewValue();
            if (component != null) {
                component.addPropertyChangeListener(this);
                this.disableSwingToolTip(component);
                component.addFocusListener(this);
                if (component.hasFocus()) {
                    this.focusGained(new FocusEvent(component, 1004));
                }
                component.addMouseListener(this);
                component.addMouseMotionListener(this);
                GlyphGutter gg = this.extEditorUI.getGlyphGutter();
                if (gg != null && !this.glyphListenerAdded) {
                    this.glyphListenerAdded = true;
                    gg.addMouseListener(this);
                    gg.addMouseMotionListener(this);
                }
            } else {
                component = (JTextComponent)evt.getOldValue();
                component.removeFocusListener(this);
                component.removePropertyChangeListener(this);
                component.removeMouseListener(this);
                component.removeMouseMotionListener(this);
                GlyphGutter gg = this.extEditorUI.getGlyphGutter();
                if (gg != null) {
                    gg.removeMouseListener(this);
                    gg.removeMouseMotionListener(this);
                }
                this.setToolTipVisible(false);
            }
        }
        if ("ToolTipText".equals(propName)) {
            component = (JComponent)evt.getSource();
            this.disableSwingToolTip(component);
            this.componentToolTipTextChanged(evt);
        }
    }

    private void disableSwingToolTip(final JComponent component) {
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                ToolTipManager.sharedInstance().unregisterComponent(component);
                GlyphGutter gg = ToolTipSupport.this.extEditorUI.getGlyphGutter();
                if (gg != null) {
                    ToolTipManager.sharedInstance().unregisterComponent(gg);
                }
            }
        });
    }

    protected void updateToolTip() {
        ExtEditorUI ui = this.extEditorUI;
        if (ui == null) {
            return;
        }
        JTextComponent comp = ui.getComponent();
        if (comp == null) {
            return;
        }
        if (this.isGlyphGutterMouseEvent(this.lastMouseEvent)) {
            this.setToolTipText(this.extEditorUI.getGlyphGutter().getToolTipText(this.lastMouseEvent));
        } else {
            Action a;
            BaseKit kit = Utilities.getKit(comp);
            if (kit != null && (a = kit.getActionByName("build-tool-tip")) != null) {
                a.actionPerformed(new ActionEvent(comp, 0, ""));
            }
        }
    }

    protected void setToolTipVisible(boolean visible) {
        if (!visible) {
            this.enterTimer.stop();
            this.exitTimer.stop();
        }
        if (visible && this.status < 1 || !visible && this.status >= 1) {
            if (visible) {
                if (this.enabled) {
                    this.setStatus(1);
                    this.updateToolTip();
                }
            } else {
                if (this.toolTip != null && this.toolTip.isVisible()) {
                    this.toolTip.setVisible(false);
                    PopupManager pm = this.extEditorUI.getPopupManager();
                    if (pm != null) {
                        pm.uninstall(this.toolTip);
                    }
                }
                this.setStatus(0);
            }
        }
    }

    public boolean isToolTipVisible() {
        return this.status > 1;
    }

    public final int getStatus() {
        return this.status;
    }

    private void setStatus(int status) {
        if (this.status != status) {
            int oldStatus = this.status;
            this.status = status;
            this.firePropertyChange(PROP_STATUS, new Integer(oldStatus), new Integer(this.status));
        }
    }

    public String getToolTipText() {
        return this.toolTipText;
    }

    public void setToolTipText(String text) {
        String oldText = this.toolTipText;
        this.toolTipText = text;
        this.firePropertyChange(PROP_TOOL_TIP_TEXT, oldText, this.toolTipText);
        if (this.toolTipText != null) {
            JTextArea ta = this.createTextToolTip();
            ta.setText(this.toolTipText);
            this.setToolTip(ta);
        } else if (this.status == 2) {
            this.setToolTipVisible(false);
        }
    }

    private void applyToolTipText() {
        JComponent tt = this.getToolTip();
        if (tt != null) {
            if (tt instanceof JLabel) {
                ((JLabel)tt).setText(this.toolTipText);
            } else if (tt instanceof JTextComponent) {
                ((JTextComponent)tt).setText(this.toolTipText);
            } else if (tt instanceof JToolTip) {
                ((JToolTip)tt).setTipText(this.toolTipText);
            } else {
                try {
                    Method m = tt.getClass().getMethod("setText", class$java$lang$String == null ? (class$java$lang$String = ToolTipSupport.class$("java.lang.String")) : class$java$lang$String);
                    if (m != null) {
                        m.invoke((Object)this.toolTip, this.toolTipText);
                    }
                }
                catch (NoSuchMethodException e) {
                }
                catch (IllegalAccessException e) {
                }
                catch (InvocationTargetException invocationTargetException) {
                    // empty catch block
                }
            }
        }
    }

    private boolean isGlyphGutterMouseEvent(MouseEvent evt) {
        return evt != null && evt.getSource() == this.extEditorUI.getGlyphGutter();
    }

    private void ensureVisibility() {
        JTextComponent component = this.extEditorUI.getComponent();
        if (component != null) {
            int pos = component.viewToModel(this.getLastMouseEventPoint());
            Rectangle cursorBounds = null;
            if (pos >= 0) {
                try {
                    cursorBounds = component.modelToView(pos);
                    if (this.horizontalBounds != PopupManager.ScrollBarBounds) {
                        if (this.placement == PopupManager.AbovePreferred || this.placement == PopupManager.Above) {
                            cursorBounds.y -= 5;
                            cursorBounds.height += 10;
                        } else if (this.placement == PopupManager.BelowPreferred || this.placement == PopupManager.Below) {
                            cursorBounds.y = cursorBounds.y + cursorBounds.height + 5 + 1;
                            cursorBounds.height += 5;
                        }
                    }
                }
                catch (BadLocationException e) {
                    // empty catch block
                }
            }
            if (cursorBounds == null) {
                cursorBounds = new Rectangle(this.getLastMouseEventPoint(), new Dimension(1, 1));
            }
            PopupManager pm = this.extEditorUI.getPopupManager();
            pm.install(this.toolTip, cursorBounds, this.placement, this.horizontalBounds, this.horizontalAdjustment, this.verticalAdjustment);
        }
        this.exitTimer.restart();
    }

    public String getIdentifierUnderCursor() {
        String word = null;
        if (!this.isGlyphGutterMouseEvent(this.lastMouseEvent)) {
            try {
                JTextComponent component = this.extEditorUI.getComponent();
                BaseTextUI ui = (BaseTextUI)component.getUI();
                Point lmePoint = this.getLastMouseEventPoint();
                int pos = ui.viewToModel(component, lmePoint);
                if (pos >= 0) {
                    BaseDocument doc = (BaseDocument)component.getDocument();
                    int eolPos = Utilities.getRowEnd(doc, pos);
                    Rectangle eolRect = ui.modelToView(component, eolPos);
                    int lineHeight = this.extEditorUI.getLineHeight();
                    if (lmePoint.x <= eolRect.x && lmePoint.y <= eolRect.y + lineHeight) {
                        word = Utilities.getIdentifier(doc, pos);
                    }
                }
            }
            catch (BadLocationException badLocationException) {
                // empty catch block
            }
        }
        return word;
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public void setEnabled(boolean enabled) {
        if (enabled != this.enabled) {
            this.enabled = enabled;
            this.firePropertyChange(PROP_ENABLED, enabled ? Boolean.FALSE : Boolean.TRUE, enabled ? Boolean.TRUE : Boolean.FALSE);
            if (!enabled) {
                this.setToolTipVisible(false);
            }
        }
    }

    public int getInitialDelay() {
        return this.enterTimer.getDelay();
    }

    public void setInitialDelay(int delay) {
        if (this.enterTimer.getDelay() != delay) {
            int oldDelay = this.enterTimer.getDelay();
            this.enterTimer.setDelay(delay);
            this.firePropertyChange(PROP_INITIAL_DELAY, new Integer(oldDelay), new Integer(this.enterTimer.getDelay()));
        }
    }

    public int getDismissDelay() {
        return this.exitTimer.getDelay();
    }

    public void setDismissDelay(int delay) {
        if (this.exitTimer.getDelay() != delay) {
            int oldDelay = this.exitTimer.getDelay();
            this.exitTimer.setDelay(delay);
            this.firePropertyChange(PROP_DISMISS_DELAY, new Integer(oldDelay), new Integer(this.exitTimer.getDelay()));
        }
    }

    public void actionPerformed(ActionEvent evt) {
        if (evt.getSource() == this.enterTimer) {
            this.setToolTipVisible(true);
        } else if (evt.getSource() == this.exitTimer) {
            this.setToolTipVisible(false);
        }
    }

    public void mouseClicked(MouseEvent evt) {
        this.lastMouseEvent = evt;
        this.setToolTipVisible(false);
    }

    public void mousePressed(MouseEvent evt) {
        this.lastMouseEvent = evt;
        this.setToolTipVisible(false);
    }

    public void mouseReleased(MouseEvent evt) {
        this.lastMouseEvent = evt;
        this.setToolTipVisible(false);
    }

    public void mouseEntered(MouseEvent evt) {
        this.lastMouseEvent = evt;
    }

    public void mouseExited(MouseEvent evt) {
        this.lastMouseEvent = evt;
        this.setToolTipVisible(false);
    }

    public void mouseDragged(MouseEvent evt) {
        this.lastMouseEvent = evt;
        this.setToolTipVisible(false);
    }

    public void mouseMoved(MouseEvent evt) {
        this.setToolTipVisible(false);
        if (this.enabled) {
            this.enterTimer.restart();
        }
        this.lastMouseEvent = evt;
    }

    public final MouseEvent getLastMouseEvent() {
        return this.lastMouseEvent;
    }

    private Point getLastMouseEventPoint() {
        Point p = null;
        MouseEvent lme = this.lastMouseEvent;
        if (lme != null) {
            JTextComponent c;
            p = lme.getPoint();
            if (lme.getSource() == this.extEditorUI.getGlyphGutter() && (c = this.extEditorUI.getComponent()) != null && c.getParent() instanceof JViewport) {
                JViewport vp = (JViewport)c.getParent();
                p = new Point(vp.getViewPosition().x, p.y);
            }
        }
        return p;
    }

    protected void componentToolTipTextChanged(PropertyChangeEvent evt) {
        JComponent component = (JComponent)evt.getSource();
        this.setToolTipText(component.getToolTipText());
    }

    private PropertyChangeSupport getPCS() {
        if (this.pcs == null) {
            this.pcs = new PropertyChangeSupport(this);
        }
        return this.pcs;
    }

    public void addPropertyChangeListener(PropertyChangeListener listener) {
        this.getPCS().addPropertyChangeListener(listener);
    }

    public void removePropertyChangeListener(PropertyChangeListener listener) {
        this.getPCS().removePropertyChangeListener(listener);
    }

    protected void firePropertyChange(String propertyName, Object oldValue, Object newValue) {
        this.getPCS().firePropertyChange(propertyName, oldValue, newValue);
    }

    public void focusGained(FocusEvent e) {
        GlyphGutter gg = this.extEditorUI.getGlyphGutter();
        if (gg != null && !this.glyphListenerAdded) {
            this.glyphListenerAdded = true;
            gg.addMouseListener(this);
            gg.addMouseMotionListener(this);
        }
    }

    public void focusLost(FocusEvent e) {
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

