/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.editor.ext.html;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Stack;
import javax.swing.text.BadLocationException;
import javax.swing.text.JTextComponent;
import org.netbeans.editor.BaseDocument;
import org.netbeans.editor.TokenID;
import org.netbeans.editor.TokenItem;
import org.netbeans.editor.ext.ExtSyntaxSupport;
import org.netbeans.editor.ext.html.HTMLCompletionQuery;
import org.netbeans.editor.ext.html.HTMLTokenContext;
import org.netbeans.editor.ext.html.SyntaxElement;
import org.netbeans.editor.ext.html.dtd.DTD;
import org.netbeans.editor.ext.html.dtd.InvalidateEvent;
import org.netbeans.editor.ext.html.dtd.InvalidateListener;
import org.netbeans.editor.ext.html.dtd.Registry;

public class HTMLSyntaxSupport
extends ExtSyntaxSupport
implements InvalidateListener {
    private static final String FALLBACK_DOCTYPE = "-//W3C//DTD HTML 4.01 Transitional//EN";
    private DTD dtd;
    private String docType;

    public HTMLSyntaxSupport(BaseDocument doc) {
        super(doc);
    }

    public void dtdInvalidated(InvalidateEvent evt) {
        if (this.dtd != null && evt.isInvalidatedIdentifier(this.docType)) {
            this.dtd = null;
        }
    }

    public DTD getDTD() {
        String type = this.getDocType();
        if (type == null) {
            type = FALLBACK_DOCTYPE;
        }
        if (this.dtd != null && type == this.docType) {
            return this.dtd;
        }
        this.docType = type;
        this.dtd = Registry.getDTD(this.docType, null);
        return this.dtd;
    }

    protected String getDocType() {
        try {
            SyntaxElement elem = this.getElementChain(0);
            if (elem == null) {
                return null;
            }
            int type = elem.getType();
            while (type != 1 && type != 4 && (elem = elem.getNext()) != null) {
                type = elem.getType();
            }
            if (type == 1) {
                return ((SyntaxElement.Declaration)elem).getPublicIdentifier();
            }
            return null;
        }
        catch (BadLocationException e) {
            return null;
        }
    }

    public int[] findMatchingBlock(int offset, boolean simpleSearch) throws BadLocationException {
        block20: {
            TokenItem token = this.getTokenChain(offset, offset + 1);
            if (token.getTokenID().getNumericID() != 4) break block20;
            if (token.getImage().charAt(0) == '>') {
                return null;
            }
            int poss = -1;
            if (token.getImage().length() > 1 && token.getImage().charAt(1) == '/') {
                String tag = token.getImage().substring(2).trim().toLowerCase();
                while (token != null) {
                    if (token.getTokenID().getNumericID() == 4) {
                        if (token.getImage().substring(1).trim().toLowerCase().equals(tag)) {
                            if (poss == 0) {
                                int start = token.getOffset();
                                int end = token.getOffset() + token.getImage().length() + 1;
                                for (token = token.getNext(); token != null && token.getTokenID().getNumericID() != 4; token = token.getNext()) {
                                }
                                if (token != null) {
                                    end = token.getOffset() + 1;
                                }
                                return new int[]{start, end};
                            }
                            --poss;
                        } else if (token.getImage().toLowerCase().indexOf(tag) > -1) {
                            ++poss;
                        }
                    }
                    token = token.getPrevious();
                }
            } else {
                if (token.getImage().charAt(0) == '>') {
                    return null;
                }
                String tag = token.getImage().substring(1).toLowerCase();
                while (token != null) {
                    if (token.getTokenID().getNumericID() == 4 && token.getImage().length() > 1) {
                        if (token.getImage().substring(2).trim().toLowerCase().equals(tag)) {
                            if (poss == 0) {
                                int start = token.getOffset();
                                int end = token.getOffset() + token.getImage().length() + 1;
                                for (token = token.getNext(); token != null && token.getTokenID().getNumericID() != 4; token = token.getNext()) {
                                }
                                if (token != null) {
                                    end = token.getOffset() + 1;
                                }
                                return new int[]{start, end};
                            }
                            --poss;
                        } else if (token.getImage().substring(1).toLowerCase().equals(tag)) {
                            ++poss;
                        }
                    }
                    token = token.getNext();
                }
            }
        }
        return null;
    }

    private final int getTokenEnd(TokenItem item) {
        return item.getOffset() + item.getImage().length();
    }

    public SyntaxElement getElementChain(int offset) throws BadLocationException {
        TokenItem first;
        TokenItem item;
        for (item = first = this.getTokenChain(offset, Math.min(offset + 10, this.getDocument().getLength())); item != null && !item.getTokenContextPath().contains(HTMLTokenContext.contextPath); item = item.getPrevious()) {
        }
        if (item == null) {
            return null;
        }
        TokenID id = item.getTokenID();
        int beginning = item.getOffset();
        if (id == HTMLTokenContext.CHARACTER) {
            while (id != null && id == HTMLTokenContext.CHARACTER) {
                beginning = item.getOffset();
                id = (item = item.getPrevious()) == null ? null : item.getTokenID();
            }
            if (id != HTMLTokenContext.VALUE && id != HTMLTokenContext.TEXT) {
                return this.getNextElement(beginning);
            }
        }
        if (id == HTMLTokenContext.WS || id == HTMLTokenContext.ARGUMENT || id == HTMLTokenContext.OPERATOR || id == HTMLTokenContext.VALUE) {
            while ((id = (item = item.getPrevious()).getTokenID()) != HTMLTokenContext.TAG) {
            }
            return this.getNextElement(item.getOffset());
        }
        if (id == HTMLTokenContext.TEXT) {
            while (id != null && (id == HTMLTokenContext.TEXT || id == HTMLTokenContext.CHARACTER)) {
                beginning = item.getOffset();
                id = (item = item.getPrevious()) == null ? null : item.getTokenID();
            }
            return this.getNextElement(beginning);
        }
        if (id == HTMLTokenContext.TAG) {
            if (item.getImage().startsWith("<")) {
                return this.getNextElement(item.getOffset());
            }
            while ((id = (item = item.getPrevious()).getTokenID()) != HTMLTokenContext.TAG) {
            }
            return this.getNextElement(item.getOffset());
        }
        if (id == HTMLTokenContext.ERROR) {
            return new SyntaxElement(this, item.getOffset(), this.getTokenEnd(item), 2);
        }
        if (id == HTMLTokenContext.BLOCK_COMMENT) {
            while (id == HTMLTokenContext.BLOCK_COMMENT && !item.getImage().startsWith("<!--")) {
                item = item.getPrevious();
                id = item.getTokenID();
            }
            return this.getNextElement(item.getOffset());
        }
        if (id == HTMLTokenContext.DECLARATION || id == HTMLTokenContext.SGML_COMMENT) {
            while (id != HTMLTokenContext.DECLARATION || !item.getImage().startsWith("<!")) {
                item = item.getPrevious();
                id = item.getTokenID();
            }
            return this.getNextElement(item.getOffset());
        }
        return null;
    }

    SyntaxElement getPreviousElement(int offset) throws BadLocationException {
        return offset == 0 ? null : this.getElementChain(offset - 1);
    }

    private static String getQuotedString(StringBuffer data) {
        char stopMark;
        int startIndex = 0;
        if (data == null || data.length() == 0) {
            return null;
        }
        while (data.charAt(startIndex) == ' ') {
            ++startIndex;
        }
        if ((stopMark = data.charAt(startIndex++)) == '\"' || stopMark == '\'') {
            for (int index = startIndex; index < data.length(); ++index) {
                if (data.charAt(index) != stopMark) continue;
                String quoted = data.substring(startIndex, index);
                data.delete(0, index + 1);
                return quoted;
            }
        }
        return null;
    }

    public SyntaxElement getNextElement(int offset) throws BadLocationException {
        TokenItem item = this.getTokenChain(offset, Math.min(offset + 10, this.getDocument().getLength()));
        if (item == null) {
            return null;
        }
        TokenID id = item.getTokenID();
        int lastOffset = this.getTokenEnd(item);
        if (id == HTMLTokenContext.BLOCK_COMMENT) {
            while (id == HTMLTokenContext.BLOCK_COMMENT) {
                lastOffset = this.getTokenEnd(item);
                if ((item = item.getNext()) == null) break;
                id = item.getTokenID();
            }
            return new SyntaxElement(this, offset, lastOffset, 0);
        }
        if (id == HTMLTokenContext.DECLARATION) {
            String si;
            String image;
            StringBuffer sb = new StringBuffer(item.getImage());
            while (id == HTMLTokenContext.DECLARATION || id == HTMLTokenContext.SGML_COMMENT) {
                lastOffset = this.getTokenEnd(item);
                if ((item = item.getNext()) == null) break;
                id = item.getTokenID();
                if (id != HTMLTokenContext.DECLARATION) continue;
                sb.append(item.getImage());
            }
            if (!(image = sb.toString()).startsWith("<!DOCTYPE")) {
                return new SyntaxElement.Declaration(this, offset, lastOffset, null, null, null);
            }
            int index = (image = image.substring(9).trim()).indexOf(32);
            if (index < 0) {
                return new SyntaxElement.Declaration(this, offset, lastOffset, null, null, null);
            }
            String rootElem = image.substring(0, index);
            if ((image = image.substring(index).trim()).startsWith("PUBLIC")) {
                sb = new StringBuffer(image = image.substring(6).trim());
                String pi = HTMLSyntaxSupport.getQuotedString(sb);
                if (pi != null) {
                    String si2 = HTMLSyntaxSupport.getQuotedString(sb);
                    return new SyntaxElement.Declaration(this, offset, lastOffset, rootElem, pi, si2);
                }
            } else if (image.startsWith("SYSTEM") && (si = HTMLSyntaxSupport.getQuotedString(sb = new StringBuffer(image = image.substring(6).trim()))) != null) {
                return new SyntaxElement.Declaration(this, offset, lastOffset, rootElem, null, si);
            }
            return new SyntaxElement.Declaration(this, offset, lastOffset, null, null, null);
        }
        if (id == HTMLTokenContext.ERROR) {
            return new SyntaxElement(this, item.getOffset(), lastOffset, 2);
        }
        if (id == HTMLTokenContext.TEXT || id == HTMLTokenContext.CHARACTER) {
            while (id == HTMLTokenContext.TEXT || id == HTMLTokenContext.CHARACTER) {
                lastOffset = this.getTokenEnd(item);
                if ((item = item.getNext()) == null) break;
                id = item.getTokenID();
            }
            return new SyntaxElement(this, offset, lastOffset, 3);
        }
        String text = item.getImage();
        if (id == HTMLTokenContext.TAG) {
            if (text.startsWith("</")) {
                String name = text.substring(2);
                TokenID tokenID = id = (item = item.getNext()) == null ? null : item.getTokenID();
                while (id == HTMLTokenContext.WS) {
                    lastOffset = this.getTokenEnd(item);
                    id = (item = item.getNext()) == null ? null : item.getTokenID();
                }
                if (id == HTMLTokenContext.TAG && item.getImage().equals(">")) {
                    return new SyntaxElement.Named(this, offset, this.getTokenEnd(item), 5, name);
                }
                return new SyntaxElement.Named(this, offset, lastOffset, 5, name);
            }
            String name = text.substring(1);
            ArrayList<String> attrs = new ArrayList<String>();
            TokenID tokenID = id = (item = item.getNext()) == null ? null : item.getTokenID();
            while (id == HTMLTokenContext.WS || id == HTMLTokenContext.ARGUMENT || id == HTMLTokenContext.OPERATOR || id == HTMLTokenContext.VALUE || id == HTMLTokenContext.CHARACTER) {
                if (id == HTMLTokenContext.ARGUMENT) {
                    attrs.add(item.getImage());
                }
                lastOffset = this.getTokenEnd(item);
                id = (item = item.getNext()) == null ? null : item.getTokenID();
            }
            if (id == HTMLTokenContext.TAG && item.getImage().equals(">")) {
                return new SyntaxElement.Tag(this, offset, this.getTokenEnd(item), name, attrs);
            }
            return new SyntaxElement.Tag(this, offset, lastOffset, name, attrs);
        }
        throw new BadLocationException("Misuse at " + offset, offset);
    }

    public List getPossibleEndTags(int offset, String prefix) throws BadLocationException {
        prefix = prefix.toUpperCase();
        int prefixLen = prefix.length();
        SyntaxElement elem = this.getElementChain(offset);
        Stack<String> stack = new Stack<String>();
        ArrayList<HTMLCompletionQuery.EndTagItem> result = new ArrayList<HTMLCompletionQuery.EndTagItem>();
        HashSet<String> found = new HashSet<String>();
        DTD dtd = this.getDTD();
        if (elem != null) {
            elem = elem.getPrevious();
        } else if (offset - prefix.length() - 3 > 0) {
            elem = this.getElementChain(offset - prefix.length() - 3);
        } else {
            return result;
        }
        while (elem != null) {
            DTD.Element tag;
            if (elem.getType() == 5) {
                stack.push(((SyntaxElement.Named)elem).getName().toUpperCase());
            } else if (elem.getType() == 4 && (tag = dtd.getElement(((SyntaxElement.Tag)elem).getName().toUpperCase())) != null && !tag.isEmpty()) {
                String name = tag.getName();
                if (stack.empty()) {
                    if (name.startsWith(prefix) && !found.contains(name)) {
                        found.add(name);
                        result.add(new HTMLCompletionQuery.EndTagItem(name, offset - 2 - prefixLen, prefixLen + 2));
                    }
                    if (!tag.hasOptionalEnd()) {
                        break;
                    }
                } else if (stack.peek().equals(name)) {
                    stack.pop();
                } else if (!tag.hasOptionalEnd()) break;
            }
            elem = elem.getPrevious();
        }
        return result;
    }

    public int checkCompletion(JTextComponent target, String typedText, boolean visible) {
        if (!visible) {
            int retVal = 1;
            switch (typedText.charAt(typedText.length() - 1)) {
                case '/': {
                    int dotPos = target.getCaret().getDot();
                    BaseDocument doc = (BaseDocument)target.getDocument();
                    if (dotPos < 2) break;
                    try {
                        String txtBeforeSpace = doc.getText(dotPos - 2, 2);
                        if (!txtBeforeSpace.equals("</")) break;
                        retVal = 0;
                    }
                    catch (BadLocationException e) {}
                    break;
                }
                case ' ': 
                case '&': 
                case '<': {
                    retVal = 0;
                }
            }
            return retVal;
        }
        switch (typedText.charAt(0)) {
            case ';': 
            case '>': {
                return 4;
            }
        }
        return 3;
    }
}

