/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.editor.ext.java;

import java.awt.Dialog;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.ArrayList;
import java.util.List;
import java.util.TreeSet;
import javax.swing.JButton;
import javax.swing.JList;
import javax.swing.ListCellRenderer;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.JTextComponent;
import org.netbeans.editor.BaseDocument;
import org.netbeans.editor.DialogSupport;
import org.netbeans.editor.LocaleSupport;
import org.netbeans.editor.SettingsUtil;
import org.netbeans.editor.Utilities;
import org.netbeans.editor.ext.ExtSettingsDefaults;
import org.netbeans.editor.ext.ListCompletionView;
import org.netbeans.editor.ext.java.JCCellRenderer;
import org.netbeans.editor.ext.java.JCClass;
import org.netbeans.editor.ext.java.JCFinder;
import org.netbeans.editor.ext.java.JCPackage;
import org.netbeans.editor.ext.java.JavaCompletion;
import org.netbeans.editor.ext.java.JavaFastImportPanel;
import org.netbeans.editor.ext.java.JavaSyntaxSupport;

public class JavaFastImport
implements ActionListener {
    public static final int IMPORT_CLASS = 0;
    public static final int IMPORT_PACKAGE = 1;
    public static final int IMPORT_FQN = 2;
    protected JTextComponent target;
    private String exp;
    private JavaFastImportPanel panel;
    private ListCellRenderer cellRenderer;
    private JList resultList;
    private Dialog dialog;
    private JButton[] buttons;
    private int[] block;
    private int importType;
    static /* synthetic */ Class class$org$netbeans$editor$ext$java$JavaSyntaxSupport;

    public JavaFastImport(JTextComponent target) {
        this.target = target;
        this.exp = Utilities.getSelectionOrIdentifier(target);
        this.block = Utilities.getSelectionOrIdentifierBlock(target);
        this.importType = this.getPackageImportSetting();
        if (this.exp != null) {
            String untrimmedExp = this.exp;
            this.exp = this.exp.trim();
            int nLeadingSpaces = untrimmedExp.indexOf(this.exp);
            int nTrailingSpaces = untrimmedExp.length() - this.exp.length() - nLeadingSpaces;
            this.block[0] = this.block[0] + nLeadingSpaces;
            this.block[1] = this.block[1] - nTrailingSpaces;
        }
    }

    private int getPackageImportSetting() {
        Class kitClass = Utilities.getKitClass(this.target);
        if (kitClass != null) {
            return SettingsUtil.getInteger(kitClass, "fast-import-selection", ExtSettingsDefaults.defaultFastImportSelection);
        }
        return ExtSettingsDefaults.defaultFastImportSelection;
    }

    public void setDialogVisible(boolean visible) {
        List result = null;
        if (visible) {
            result = this.evaluate();
            if (result == null || result.size() == 0) {
                return;
            }
            this.populate(result);
        }
        if (this.dialog == null) {
            this.dialog = this.createDialog();
        }
        this.getResultList().requestFocus();
        this.dialog.setVisible(visible);
        if (visible) {
            this.getPanel().popupNotify();
        } else {
            this.dialog.dispose();
        }
    }

    protected boolean isAlreadyImported(JCClass cls) {
        BaseDocument doc = Utilities.getDocument(this.target);
        if (doc == null) {
            return false;
        }
        JavaSyntaxSupport sup = (JavaSyntaxSupport)doc.getSyntaxSupport().get(class$org$netbeans$editor$ext$java$JavaSyntaxSupport == null ? (class$org$netbeans$editor$ext$java$JavaSyntaxSupport = JavaFastImport.class$("org.netbeans.editor.ext.java.JavaSyntaxSupport")) : class$org$netbeans$editor$ext$java$JavaSyntaxSupport);
        if (sup == null) {
            return false;
        }
        sup.refreshJavaImport();
        return sup.isImported(cls);
    }

    protected void updateImport(Object item) {
    }

    protected ListCellRenderer createCellRenderer() {
        JCCellRenderer rr = new JCCellRenderer();
        rr.setClassDisplayFullName(true);
        rr.setPackageLastNameOnly(false);
        return rr;
    }

    protected JList createResultList() {
        ListCompletionView list = new ListCompletionView(this.getCellRenderer());
        list.addMouseListener(new MouseAdapter(){

            public void mouseClicked(MouseEvent e) {
                if (e.getClickCount() == 2) {
                    JavaFastImport.this.actionPerformed(new ActionEvent(JavaFastImport.this.getButtons()[0], 0, ""));
                }
            }
        });
        return list;
    }

    private JButton[] getButtons() {
        if (this.buttons == null) {
            this.buttons = new JButton[]{new JButton(LocaleSupport.getString("JFI_import", "Import")), new JButton(LocaleSupport.getString("JFI_cancelButton", "Cancel"))};
            this.buttons[0].getAccessibleContext().setAccessibleDescription(LocaleSupport.getString("ACSD_JFI_import"));
            this.buttons[1].getAccessibleContext().setAccessibleDescription(LocaleSupport.getString("ACSD_JFI_cancelButton"));
        }
        return this.buttons;
    }

    private Dialog createDialog() {
        String title = LocaleSupport.getString("JFI_title", "Import Class");
        Dialog dialog = DialogSupport.createDialog(title, this.getPanel(), true, this.getButtons(), false, 0, 1, this);
        dialog.addWindowListener(new WindowAdapter(){

            public void windowClosed(WindowEvent evt) {
                Utilities.returnFocus();
            }
        });
        return dialog;
    }

    private JavaFastImportPanel getPanel() {
        if (this.panel == null) {
            this.panel = new JavaFastImportPanel(this, this.importType);
        }
        return this.panel;
    }

    ListCellRenderer getCellRenderer() {
        if (this.cellRenderer == null) {
            this.cellRenderer = this.createCellRenderer();
        }
        return this.cellRenderer;
    }

    JList getResultList() {
        if (this.resultList == null) {
            this.resultList = this.createResultList();
        }
        return this.resultList;
    }

    List evaluate() {
        List ret = null;
        TreeSet<JCPackage> ts = new TreeSet<JCPackage>();
        if (this.exp != null && this.exp.length() > 0) {
            JCFinder finder = JavaCompletion.getFinder();
            ret = finder.findClasses(null, this.exp, true);
            if (this.getPanel().getImportType() == 1 && ret != null) {
                for (int i = 0; i < ret.size(); ++i) {
                    JCPackage pkg = finder.getExactPackage(((JCClass)ret.get(i)).getPackageName());
                    if (pkg == null) continue;
                    ts.add(pkg);
                }
            }
        }
        return this.getPanel().getImportType() == 1 ? new ArrayList(ts) : ret;
    }

    void populate(List result) {
        if (result != null && this.getResultList() instanceof ListCompletionView) {
            ((ListCompletionView)this.getResultList()).setResult(result);
        }
    }

    protected void setFastImportSettings(int importType) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void actionPerformed(ActionEvent evt) {
        Object src = evt.getSource();
        if (src == this.buttons[0]) {
            int importType = this.getPanel().getImportType();
            switch (importType) {
                case 0: 
                case 1: {
                    int selIndex = this.getResultList().getSelectedIndex();
                    if (selIndex < 0) break;
                    this.updateImport(this.getResultList().getModel().getElementAt(selIndex));
                    break;
                }
                case 2: {
                    int selIndex = this.getResultList().getSelectedIndex();
                    if (selIndex < 0) {
                        return;
                    }
                    try {
                        Document document = this.target.getDocument();
                        if (document instanceof BaseDocument) {
                            BaseDocument doc = (BaseDocument)document;
                            try {
                                doc.atomicLock();
                                try {
                                    doc.remove(this.block[0], this.block[1] - this.block[0]);
                                    Object item = this.getResultList().getModel().getElementAt(selIndex);
                                    if (item instanceof JCClass) {
                                        doc.insertString(this.block[0], ((JCClass)item).getFullName(), null);
                                        this.target.getCaret().setDot(this.block[0] + ((JCClass)item).getFullName().length());
                                    } else {
                                        doc.insertString(this.block[0], item.toString(), null);
                                        this.target.getCaret().setDot(this.block[0] + item.toString().length());
                                    }
                                }
                                finally {
                                    doc.atomicUnlock();
                                }
                            }
                            catch (BadLocationException ble) {}
                            break;
                        }
                        document.remove(this.block[0], this.block[1] - this.block[0]);
                        Object item = this.getResultList().getModel().getElementAt(selIndex);
                        if (item instanceof JCClass) {
                            document.insertString(this.block[0], ((JCClass)item).getFullName(), null);
                            this.target.getCaret().setDot(this.block[0] + ((JCClass)item).getFullName().length());
                            break;
                        }
                        document.insertString(this.block[0], item.toString(), null);
                        this.target.getCaret().setDot(this.block[0] + item.toString().length());
                        break;
                    }
                    catch (BadLocationException ex) {
                        throw new IllegalStateException();
                    }
                }
            }
            this.setFastImportSettings(importType);
            this.setDialogVisible(false);
        } else if (src == this.buttons[this.buttons.length - 1]) {
            this.setDialogVisible(false);
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

