/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.editor.fold.api;

import java.util.Collections;
import java.util.List;
import javax.swing.text.JTextComponent;
import org.netbeans.editor.fold.api.Fold;
import org.netbeans.editor.fold.api.FoldHierarchyIterator;
import org.netbeans.editor.fold.api.FoldHierarchyListener;
import org.netbeans.editor.fold.api.FoldType;
import org.netbeans.editor.fold.spi.FoldHierarchySpi;
import org.netbeans.lib.editor.fold.FoldUtilitiesImpl;

public final class FoldHierarchy {
    public static final FoldType LANGUAGE_FOLD_TYPE = new FoldType("language-fold");
    private static final SpiProvider spiProvider = new SpiProvider();
    private FoldHierarchySpi spi;
    static /* synthetic */ Class class$org$netbeans$editor$fold$api$FoldHierarchy;

    public static synchronized FoldHierarchy get(JTextComponent component) {
        if (component == null) {
            throw new NullPointerException("component cannot be null");
        }
        FoldHierarchy hierarchy = (FoldHierarchy)component.getClientProperty(class$org$netbeans$editor$fold$api$FoldHierarchy == null ? (class$org$netbeans$editor$fold$api$FoldHierarchy = FoldHierarchy.class$("org.netbeans.editor.fold.api.FoldHierarchy")) : class$org$netbeans$editor$fold$api$FoldHierarchy);
        if (hierarchy == null) {
            hierarchy = new FoldHierarchy(component);
            component.putClientProperty(class$org$netbeans$editor$fold$api$FoldHierarchy == null ? (class$org$netbeans$editor$fold$api$FoldHierarchy = FoldHierarchy.class$("org.netbeans.editor.fold.api.FoldHierarchy")) : class$org$netbeans$editor$fold$api$FoldHierarchy, hierarchy);
        }
        return hierarchy;
    }

    private FoldHierarchy(JTextComponent component) {
        spiProvider.setCreator(this);
        this.spi = FoldHierarchySpi.create(this, component);
        spiProvider.setCreator(null);
    }

    public void lock() {
        this.spi.lock();
    }

    public void unlock() {
        this.spi.unlock();
    }

    public void collapse(Fold f) {
        this.collapse(Collections.singletonList(f));
    }

    public void collapse(List l) {
        this.spi.collapse(l);
    }

    public void expand(Fold f) {
        this.expand(Collections.singletonList(f));
    }

    public void expand(List l) {
        this.spi.expand(l);
    }

    public void toggle(Fold f) {
        if (f.isCollapsed()) {
            this.expand(f);
        } else {
            this.collapse(f);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void render(Runnable r) {
        this.lock();
        try {
            r.run();
        }
        finally {
            this.unlock();
        }
    }

    public JTextComponent getComponent() {
        return this.spi.getComponent();
    }

    public int getRootFoldCount() {
        return this.spi.getRootFoldCount();
    }

    public Fold getRootFold(int index) {
        return this.spi.getRootFold(index);
    }

    public void addFoldHierarchyListener(FoldHierarchyListener l) {
        this.spi.addFoldHierarchyListener(l);
    }

    public void removeFoldHierarchyListener(FoldHierarchyListener l) {
        this.spi.removeFoldHierarchyListener(l);
    }

    public FoldHierarchyIterator foldIterator() {
        return this.foldIterator(0, Integer.MAX_VALUE);
    }

    public FoldHierarchyIterator foldIterator(int startOffset, int endOffset) {
        return this.spi.foldIterator(startOffset, endOffset);
    }

    public FoldHierarchyIterator collapsedFoldIterator() {
        return this.collapsedFoldIterator(0, Integer.MAX_VALUE);
    }

    public FoldHierarchyIterator collapsedFoldIterator(int startOffset, int endOffset) {
        return this.spi.collapsedFoldIterator(startOffset, endOffset);
    }

    private void checkSpi(FoldHierarchySpi spi) {
        if (this.spi != spi) {
            // empty if block
        }
    }

    public String toString() {
        return FoldUtilitiesImpl.foldHierarchyToString(this);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static {
        FoldHierarchySpi.registerProvider(spiProvider);
    }

    private static final class SpiProvider
    implements FoldHierarchySpi.Provider {
        private FoldHierarchy creator;

        private SpiProvider() {
        }

        public FoldHierarchySpi get(FoldHierarchy hierarchy) {
            return hierarchy.spi;
        }

        public void checkCreator(FoldHierarchy hierarchy) {
            if (this.creator == null || this.creator != hierarchy) {
                throw new IllegalStateException("hierarchy for component=" + hierarchy.getComponent() + " did not request creation of SPI");
            }
        }

        void setCreator(FoldHierarchy hierarchy) {
            this.creator = hierarchy;
        }
    }
}

