/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.editor.fold.spi;

import org.netbeans.editor.fold.api.Fold;
import org.netbeans.editor.fold.api.FoldChildrenChange;
import org.netbeans.editor.fold.api.FoldHierarchy;
import org.netbeans.editor.fold.api.FoldType;
import org.netbeans.editor.fold.spi.DefaultFoldStateChange;
import org.netbeans.editor.fold.spi.FoldHierarchySpi;
import org.netbeans.editor.fold.spi.FoldHierarchyTransaction;
import org.netbeans.editor.fold.spi.RootFold;
import org.netbeans.lib.editor.fold.FoldChildren;
import org.netbeans.lib.editor.fold.FoldUtilitiesImpl;

public abstract class AbstractFold
implements Fold {
    private static final AbstractFold[] EMPTY_ABSTRACT_FOLD_ARRAY = new AbstractFold[0];
    private AbstractFold parent;
    private boolean collapsed;
    private FoldChildren children;
    private int rawIndex;

    public AbstractFold() {
        this(false);
    }

    public AbstractFold(boolean collapsed) {
        this.collapsed = collapsed;
    }

    public abstract FoldType getType();

    public abstract int getStartOffset();

    public abstract int getEndOffset();

    public final FoldHierarchy getHierarchy() {
        FoldHierarchySpi fhs = this.getHierarchySpi();
        return fhs != null ? fhs.getHierarchy() : null;
    }

    public FoldHierarchySpi getHierarchySpi() {
        return this.parent != null ? this.parent.getHierarchySpi() : null;
    }

    public final Fold getParent() {
        return this.getParentAbstractFold();
    }

    public final AbstractFold getParentAbstractFold() {
        return this.parent;
    }

    public void setParent(AbstractFold parent) {
        this.parent = parent;
    }

    public RootFold getRootFold() {
        return this.parent != null ? this.parent.getRootFold() : null;
    }

    public int getRootFoldIndex() {
        return this.parent != null ? this.parent.getRootFoldIndex() : -1;
    }

    public boolean isRootFold() {
        return false;
    }

    public boolean isCollapsed() {
        return this.collapsed;
    }

    public String getDescription() {
        return "...";
    }

    public int getFoldCount() {
        return this.children != null ? this.children.getFoldCount() : 0;
    }

    public Fold getFold(int index) {
        if (this.children != null) {
            return this.children.getFold(index);
        }
        throw new IndexOutOfBoundsException("index=" + index + " but no children exist.");
    }

    public int getFoldIndex(Fold fold) {
        if (!(fold instanceof AbstractFold)) {
            return -1;
        }
        return this.children != null ? this.children.getFoldIndex((AbstractFold)fold) : -1;
    }

    public int getFoldIndex(int offset) {
        return this.children != null ? this.children.getFoldIndex(offset) : 0;
    }

    public int getRawIndex() {
        return this.rawIndex;
    }

    public void setRawIndex(int rawIndex) {
        this.rawIndex = rawIndex;
    }

    public void replace(int index, int removeCount, AbstractFold[] insertFolds, FoldHierarchyTransaction transaction) {
        int i;
        Fold[] removedFolds;
        if (transaction == null) {
            throw new NullPointerException("Need valid transaction");
        }
        if (this.children == null) {
            this.children = new FoldChildren();
        }
        if (removeCount > 0) {
            removedFolds = new AbstractFold[removeCount];
            for (i = 0; i < removeCount; ++i) {
                AbstractFold af = this.children.getFold(index + i);
                removedFolds[i] = af;
                af.setParent(null);
            }
            this.children.remove(index, removeCount);
        } else {
            removedFolds = EMPTY_ABSTRACT_FOLD_ARRAY;
        }
        if (insertFolds != null && insertFolds.length > 0) {
            insertFolds = (AbstractFold[])insertFolds.clone();
            FoldUtilitiesImpl.sort(insertFolds);
            this.children.insertAll(index, insertFolds);
            for (i = insertFolds.length - 1; i >= 0; --i) {
                insertFolds[i].setParent(this);
            }
        } else {
            insertFolds = EMPTY_ABSTRACT_FOLD_ARRAY;
        }
        FoldChildrenChange change = new FoldChildrenChange(this, index, removedFolds, insertFolds);
        transaction.addFoldChildrenChange(change);
    }

    public void setCollapsed(boolean collapsed, FoldHierarchyTransaction transaction) {
        boolean oldCollapsed = this.collapsed;
        if (oldCollapsed != collapsed) {
            this.collapsed = collapsed;
            this.getFoldStateChange(transaction).collapsedChanged();
        }
    }

    protected DefaultFoldStateChange getFoldStateChange(FoldHierarchyTransaction transaction) {
        DefaultFoldStateChange change = transaction.getFoldStateChange(this);
        if (change == null) {
            change = this.createFoldStateChange();
            transaction.replaceFoldStateChange(change);
        }
        return change;
    }

    protected DefaultFoldStateChange createFoldStateChange() {
        return new DefaultFoldStateChange(this);
    }

    public String toString() {
        return AbstractFold.foldToString(this);
    }

    public static String foldToString(Fold fold) {
        return FoldUtilitiesImpl.foldToString(fold);
    }

    public static String foldToStringChildren(Fold fold) {
        return FoldUtilitiesImpl.foldToStringChildren(fold, 0);
    }

    public final int hashCode() {
        return super.hashCode();
    }

    public final boolean equals(Object obj) {
        return super.equals(obj);
    }
}

