/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.editor.fold.spi;

import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.Position;
import org.netbeans.editor.fold.api.FoldType;
import org.netbeans.editor.fold.spi.FoldHierarchyTransaction;
import org.netbeans.editor.fold.spi.PositionFold;

public class DescriptionFold
extends PositionFold {
    private FoldType foldType;
    private String description;
    private int startGuardedLength;
    private int endGuardedLength;
    private Position innerEndPos;

    public DescriptionFold(boolean collapsed, Document doc, int startOffset, int endOffset, FoldType foldType, String description, int startGuardedLength, int endGuardedLength) throws BadLocationException {
        super(collapsed, doc, startOffset, endOffset);
        this.foldType = foldType;
        this.description = description;
        this.startGuardedLength = startGuardedLength;
        this.endGuardedLength = endGuardedLength;
        this.innerEndPos = doc.createPosition(endOffset - endGuardedLength);
    }

    public FoldType getType() {
        return this.foldType;
    }

    public String getDescription() {
        return this.description != null ? this.description : super.getDescription();
    }

    public int getStartGuardedLength() {
        return this.startGuardedLength;
    }

    public int getEndGuardedLength() {
        return this.endGuardedLength;
    }

    public int getInnerStartOffset() {
        return this.getStartOffset() + this.startGuardedLength;
    }

    public int getInnerEndOffset() {
        return this.innerEndPos.getOffset();
    }

    public void setDescription(String description, FoldHierarchyTransaction transaction) {
        if (!description.equals(this.description)) {
            this.description = description;
            this.getFoldStateChange(transaction).descriptionChanged();
        }
    }
}

