/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.editor.fold.spi;

import java.util.Collections;
import java.util.List;
import org.netbeans.editor.fold.spi.FoldHierarchySpi;

public abstract class FoldMaintainerFactoryProvider {
    private static FoldMaintainerFactoryProvider defaultProvider;
    private static FoldMaintainerFactoryProvider emptyProvider;

    public static synchronized FoldMaintainerFactoryProvider getDefault() {
        if (defaultProvider == null) {
            defaultProvider = FoldMaintainerFactoryProvider.findDefault();
        }
        return defaultProvider;
    }

    public static synchronized void setDefault(FoldMaintainerFactoryProvider provider) {
        defaultProvider = provider;
    }

    public static FoldMaintainerFactoryProvider getEmpty() {
        if (emptyProvider == null) {
            emptyProvider = new EmptyProvider();
        }
        return emptyProvider;
    }

    private static FoldMaintainerFactoryProvider findDefault() {
        FoldMaintainerFactoryProvider provider = null;
        try {
            Class<?> moduleBuilder = Class.forName("org.netbeans.modules.editor.NbFoldMaintainerFactoryProvider");
            provider = (FoldMaintainerFactoryProvider)moduleBuilder.newInstance();
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (provider == null) {
            provider = new EmptyProvider();
        }
        return provider;
    }

    public abstract List getFactoryList(FoldHierarchySpi var1);

    static final class EmptyProvider
    extends FoldMaintainerFactoryProvider {
        EmptyProvider() {
        }

        public List getFactoryList(FoldHierarchySpi hierarchySpi) {
            return Collections.EMPTY_LIST;
        }
    }
}

