/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.lib.editor.fold;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import javax.swing.text.AbstractDocument;
import org.netbeans.editor.fold.api.Fold;
import org.netbeans.editor.fold.api.FoldChildrenChange;
import org.netbeans.editor.fold.api.FoldHierarchy;
import org.netbeans.editor.fold.api.FoldHierarchyEvent;
import org.netbeans.editor.fold.api.FoldStateChange;
import org.netbeans.editor.fold.api.FoldType;
import org.netbeans.editor.fold.spi.AbstractFold;

public final class FoldUtilitiesImpl {
    private static final FoldComparator foldComparator = new FoldComparator();

    private FoldUtilitiesImpl() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void collapseOrExpand(FoldHierarchy hierarchy, FoldType foldType, boolean collapse) {
        AbstractDocument adoc = (AbstractDocument)hierarchy.getComponent().getDocument();
        adoc.readLock();
        try {
            hierarchy.lock();
            try {
                List foldList = FoldUtilitiesImpl.findRecursive(hierarchy, foldType);
                if (collapse) {
                    hierarchy.collapse(foldList);
                } else {
                    hierarchy.expand(foldList);
                }
            }
            finally {
                hierarchy.unlock();
            }
        }
        finally {
            adoc.readUnlock();
        }
    }

    public static Fold[] childrenToArray(Fold fold, int index, int count) {
        Fold[] folds = new Fold[count];
        while (--count >= 0) {
            folds[index] = fold.getFold(index);
            ++index;
        }
        return folds;
    }

    public static List childrenAsList(Fold fold, int index, int count) {
        ArrayList<Fold> l = new ArrayList<Fold>();
        while (--count >= 0) {
            l.add(fold.getFold(index));
            ++index;
        }
        return l;
    }

    public static List find(Fold fold, FoldType type) {
        ArrayList<Fold> l = new ArrayList<Fold>();
        int foldCount = fold.getFoldCount();
        for (int i = 0; i < foldCount; ++i) {
            Fold child = fold.getFold(i);
            if (child.getType() != type) continue;
            l.add(child);
        }
        return l;
    }

    public static List find(Fold fold, Collection foldTypes) {
        ArrayList<Fold> l = new ArrayList<Fold>();
        int foldCount = fold.getFoldCount();
        for (int i = 0; i < foldCount; ++i) {
            Fold child = fold.getFold(i);
            if (!foldTypes.contains(child.getType())) continue;
            l.add(child);
        }
        return l;
    }

    public static List findRecursive(List l, Fold fold, FoldType type) {
        if (l == null) {
            l = new ArrayList<Fold>();
        }
        int foldCount = fold.getFoldCount();
        for (int i = 0; i < foldCount; ++i) {
            Fold child = fold.getFold(i);
            if (type == null || child.getType() == type) {
                l.add(child);
            }
            FoldUtilitiesImpl.findRecursive(l, child, type);
        }
        return l;
    }

    public static List findRecursive(List l, Fold fold, Collection foldTypes) {
        if (l == null) {
            l = new ArrayList<Fold>();
        }
        int foldCount = fold.getFoldCount();
        for (int i = 0; i < foldCount; ++i) {
            Fold child = fold.getFold(i);
            if (foldTypes.contains(child.getType())) {
                l.add(child);
            }
            FoldUtilitiesImpl.findRecursive(l, child, foldTypes);
        }
        return l;
    }

    public static List findRecursive(FoldHierarchy hierarchy, FoldType foldType) {
        int rootFoldCount = hierarchy.getRootFoldCount();
        ArrayList foldList = new ArrayList();
        for (int i = 0; i < rootFoldCount; ++i) {
            FoldUtilitiesImpl.findRecursive(foldList, hierarchy.getRootFold(i), foldType);
        }
        return foldList;
    }

    public static List findRecursive(FoldHierarchy hierarchy, Collection foldTypes) {
        int rootFoldCount = hierarchy.getRootFoldCount();
        ArrayList foldList = new ArrayList();
        for (int i = 0; i < rootFoldCount; ++i) {
            FoldUtilitiesImpl.findRecursive(foldList, hierarchy.getRootFold(i), foldTypes);
        }
        return foldList;
    }

    public static Fold findFoldAtOffset(FoldHierarchy hierarchy, int offset) {
        Fold rootFold0;
        if (hierarchy.getRootFoldCount() == 0) {
            return null;
        }
        int distance = Integer.MAX_VALUE;
        Fold fold = rootFold0 = hierarchy.getRootFold(0);
        boolean inspectNested = true;
        while (inspectNested) {
            int childCount = fold.getFoldCount();
            int childIndex = fold.getFoldIndex(offset);
            if (childIndex < childCount) {
                Fold wrapFold = fold.getFold(childIndex);
                int startOffset = wrapFold.getStartOffset();
                int endOffset = wrapFold.getEndOffset();
                if (startOffset <= offset && endOffset >= offset) {
                    fold = wrapFold;
                    continue;
                }
                inspectNested = false;
                continue;
            }
            inspectNested = false;
        }
        return fold != rootFold0 ? fold : null;
    }

    public static Fold findNearestFold(FoldHierarchy hierarchy, int offset) {
        if (hierarchy.getRootFoldCount() == 0) {
            return null;
        }
        Fold nearestFold = null;
        int distance = Integer.MAX_VALUE;
        Fold fold = hierarchy.getRootFold(0);
        boolean inspectNested = true;
        while (inspectNested) {
            int childCount = fold.getFoldCount();
            int childIndex = fold.getFoldIndex(offset);
            if (childIndex < childCount) {
                int afterFoldDistance;
                Fold afterFold;
                Fold wrapOrAfterFold = fold.getFold(childIndex);
                int startOffset = wrapOrAfterFold.getStartOffset();
                if (startOffset < offset) {
                    afterFold = ++childIndex < childCount ? fold.getFold(childIndex) : null;
                    fold = wrapOrAfterFold;
                } else {
                    afterFold = wrapOrAfterFold;
                    inspectNested = false;
                }
                if (afterFold == null || (afterFoldDistance = afterFold.getStartOffset() - offset) >= distance) continue;
                distance = afterFoldDistance;
                nearestFold = afterFold;
                continue;
            }
            inspectNested = false;
        }
        return nearestFold;
    }

    public static void sort(Fold[] folds) {
        Arrays.sort(folds, foldComparator);
    }

    public static String foldToString(Fold fold) {
        return "[" + fold.getType() + "] " + (fold.isCollapsed() ? "C" : "E") + ", so=" + fold.getStartOffset() + ", eo=" + fold.getEndOffset();
    }

    public static void appendSpaces(StringBuffer sb, int spaces) {
        while (--spaces >= 0) {
            sb.append(' ');
        }
    }

    public static String foldToStringChildren(Fold fold, int indent) {
        indent += 4;
        StringBuffer sb = new StringBuffer();
        sb.append(FoldUtilitiesImpl.foldToString(fold));
        sb.append('\n');
        int foldCount = fold.getFoldCount();
        for (int i = 0; i < foldCount; ++i) {
            FoldUtilitiesImpl.appendSpaces(sb, indent);
            sb.append('[');
            sb.append(i);
            sb.append("]: ");
            sb.append(FoldUtilitiesImpl.foldToStringChildren(fold.getFold(i), indent));
        }
        return sb.toString();
    }

    public static String foldHierarchyEventToString(FoldHierarchyEvent evt) {
        StringBuffer sb = new StringBuffer();
        int foldChildrenChangeCount = evt.getFoldChildrenChangeCount();
        for (int i = 0; i < foldChildrenChangeCount; ++i) {
            FoldChildrenChange change = evt.getFoldChildrenChange(i);
            sb.append("CC[");
            sb.append(i);
            sb.append("]: ");
            sb.append(change);
            sb.append('\n');
        }
        if (foldChildrenChangeCount == 0) {
            sb.append("No FoldChildrenChange\n");
        }
        int foldStateChangeCount = evt.getFoldStateChangeCount();
        for (int i = 0; i < foldStateChangeCount; ++i) {
            FoldStateChange change = evt.getFoldStateChange(i);
            sb.append("SC[");
            sb.append(i);
            sb.append("]: ");
            sb.append(change);
            sb.append('\n');
        }
        if (foldStateChangeCount == 0) {
            sb.append("No FoldStateChange\n");
        }
        sb.append("affectedSO=");
        sb.append(evt.getAffectedStartOffset());
        sb.append('\n');
        sb.append("affectedEO=");
        sb.append(evt.getAffectedEndOffset());
        sb.append('\n');
        return sb.toString();
    }

    public static String foldChildrenChangeToString(FoldChildrenChange change) {
        StringBuffer sb = new StringBuffer();
        sb.append("fold=");
        sb.append(change.getFold());
        sb.append('\n');
        int addedFoldCount = change.getAddedFoldCount();
        for (int j = 0; j < addedFoldCount; ++j) {
            sb.append("    A[");
            sb.append(j);
            sb.append("]:");
            sb.append(change.getAddedFold(j));
            sb.append('\n');
        }
        int removedFoldCount = change.getRemovedFoldCount();
        for (int j = 0; j < removedFoldCount; ++j) {
            sb.append("    R[");
            sb.append(j);
            sb.append("]:");
            sb.append(change.getRemovedFold(j));
            sb.append('\n');
        }
        return sb.toString();
    }

    public static String foldStateChangeToString(FoldStateChange change) {
        StringBuffer sb = new StringBuffer();
        if (change.isCollapsedChanged()) {
            sb.append("C");
        }
        if (change.isDescriptionChanged()) {
            sb.append("D");
        }
        if (change.isEndOffsetChanged()) {
            sb.append("E");
        }
        sb.append(" fold=");
        sb.append(change.getFold());
        return sb.toString();
    }

    public static String foldHierarchyToString(FoldHierarchy hierarchy) {
        StringBuffer sb = new StringBuffer();
        sb.append("component=");
        sb.append(System.identityHashCode(hierarchy.getComponent()));
        sb.append('\n');
        int rootFoldCount = hierarchy.getRootFoldCount();
        for (int i = 0; i < rootFoldCount; ++i) {
            sb.append("RF[");
            sb.append(i);
            sb.append("]: ");
            sb.append(FoldUtilitiesImpl.foldToStringChildren(hierarchy.getRootFold(i), 4));
            sb.append('\n');
        }
        if (rootFoldCount == 0) {
            sb.append("No root folds");
        }
        return sb.toString();
    }

    private static final class FoldComparator
    implements Comparator {
        private FoldComparator() {
        }

        public int compare(Object o1, Object o2) {
            Fold f1 = (Fold)o1;
            int f1Start = f1.getStartOffset();
            int f1End = f1.getEndOffset();
            Fold f2 = (Fold)o2;
            int f2Start = f2.getStartOffset();
            int f2End = f2.getEndOffset();
            if (f1End <= f2Start) {
                return -1;
            }
            if (f2End <= f1Start) {
                return 1;
            }
            throw new IllegalArgumentException("Fold overlapping: f1=" + AbstractFold.foldToString(f1) + " with f2=" + AbstractFold.foldToString(f2));
        }
    }
}

