/*
 * Decompiled with CFR 0.152.
 */
package core.swing;

import core.swing.Command;
import core.swing.CommandListener;
import java.util.Enumeration;
import java.util.ResourceBundle;
import javax.swing.Action;
import javax.swing.ActionMap;

public class CommandManager
extends ActionMap
implements CommandListener {
    private static CommandManager commandManager;

    public static CommandManager getSystemBundle() {
        if (commandManager == null) {
            commandManager = new CommandManager();
        }
        return commandManager;
    }

    private CommandManager() {
    }

    public void load(ResourceBundle bundle) {
        Enumeration<String> em = bundle.getKeys();
        String key = null;
        String value = null;
        Command cmd = null;
        while (em.hasMoreElements()) {
            try {
                key = em.nextElement().toString().trim();
                value = bundle.getString(key).trim();
                cmd = (Command)Class.forName(value).newInstance();
                cmd.addCommandListener(this);
                super.put(key, cmd);
            }
            catch (Exception e) {
                System.err.println("Error Command : " + key);
            }
        }
    }

    private Command createCommand(String key) {
        try {
            Command cmd = (Command)Class.forName(key).newInstance();
            cmd.addCommandListener(this);
            super.put(key, cmd);
            return cmd;
        }
        catch (Exception e) {
            System.err.println("Error Command : " + key);
            return null;
        }
    }

    public Command getCommand(Object key) {
        try {
            Action a = super.get(key);
            Command c = null;
            c = a == null ? this.createCommand(key.toString().trim()) : (Command)a;
            return c;
        }
        catch (Exception e) {
            return null;
        }
    }

    public void commandStarted(Command c) {
        Object[] keys = super.allKeys();
        Command cmd = null;
        int i = 0;
        while (i < keys.length) {
            cmd = this.getCommand(keys[i]);
            cmd.setExecutable(false);
            ++i;
        }
    }

    public void commandCompleted(Command c) {
        Object[] keys = super.allKeys();
        Command cmd = null;
        int i = 0;
        while (i < keys.length) {
            cmd = this.getCommand(keys[i]);
            cmd.setExecutable(true);
            ++i;
        }
    }
}

