/*
 * Decompiled with CFR 0.152.
 */
package core.swing;

import java.util.Vector;
import javax.swing.AbstractButton;
import javax.swing.ButtonGroup;
import javax.swing.JRadioButton;

public class JButtonGroup
extends ButtonGroup {
    public static final String ITEM = "ITEM";
    private Vector items = new Vector();

    public JButtonGroup() {
    }

    public JButtonGroup(Vector v) {
        this();
        int size = v.size();
        Object item = null;
        int i = 0;
        while (i < size) {
            item = v.get(i);
            this.add(item);
            this.items.add(item);
            ++i;
        }
    }

    public JButtonGroup(Object[] o) {
        this();
        int size = o.length;
        Object item = null;
        int i = 0;
        while (i < size) {
            item = o[i];
            this.add(item);
            this.items.add(item);
            ++i;
        }
    }

    public void add(Object item) {
        this.add(new JRadioButton(item.toString()), item);
    }

    public void add(AbstractButton b, Object item) {
        b.putClientProperty(ITEM, item);
        super.add(b);
        this.items.add(item);
    }

    public void remove(Object item) {
        int size = this.buttons.size();
        AbstractButton b = null;
        Object obj = null;
        int i = 0;
        while (i < size) {
            b = this.buttons.get(i);
            obj = b.getClientProperty(ITEM);
            if (obj.equals(item)) {
                super.remove(b);
                this.items.remove(item);
                break;
            }
            ++i;
        }
    }

    public void setSelectedItem(Object obj) {
        int size = this.buttons.size();
        AbstractButton b = null;
        Object item = null;
        int i = 0;
        while (i < size) {
            b = this.buttons.get(i);
            item = b.getClientProperty(ITEM);
            if (obj.equals(item)) {
                b.setSelected(true);
                return;
            }
            ++i;
        }
    }

    public Object getSelectedItem() {
        int size = this.buttons.size();
        AbstractButton b = null;
        Object item = null;
        int i = 0;
        while (i < size) {
            b = this.buttons.get(i);
            item = b.getClientProperty(ITEM);
            if (b.isSelected()) {
                return b.getClientProperty(ITEM);
            }
            ++i;
        }
        return null;
    }

    public Object[] getAllElements() {
        int size = this.buttons.size();
        Object[] ele = new Object[size];
        this.buttons.toArray(ele);
        return ele;
    }

    public Object[] getAllItems() {
        int size = this.items.size();
        Object[] ele = new Object[size];
        this.items.toArray(ele);
        return ele;
    }
}

