/*
 * Decompiled with CFR 0.152.
 */
package core.swing;

import com.jgoodies.forms.layout.CellConstraints;
import com.jgoodies.forms.layout.FormLayout;
import core.swing.ActionToolBar;
import core.swing.JFormDialog;
import core.swing.ResourceManager;
import core.swing.chooser.ExampleFileFilter;
import core.swing.chooser.FileManager;
import core.swing.tree.filesystem.FileTree;
import core.swing.tree.filesystem.FileTreeNodeList;
import core.swing.tree.filesystem.FolderTreeNodeList;
import java.awt.Component;
import java.awt.LayoutManager;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.io.IOException;
import java.net.URI;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.UIManager;

public class JFileTreeChooser
extends JFormDialog
implements PropertyChangeListener {
    protected static String RESOURCES = "core.swing.resources.FileChooser";
    protected static ResourceManager bundle = ResourceManager.getBundle(RESOURCES);
    protected static URI uri = ResourceManager.getResourceURI(RESOURCES);
    public static final int FILES_ONLY = 0;
    public static final int DIRECTORIES_ONLY = 1;
    public static final int OPEN_DIALOG = 0;
    public static final int SAVE_DIALOG = 1;
    protected ActionToolBar bar;
    protected FileTree tree;
    protected JLabel fileNameLabel;
    protected JTextField fileName;
    protected int dialogType;
    protected int selectionMode = 1;
    protected File rootFile = FileManager.getDefaultDirectory();
    protected ExampleFileFilter filter;

    protected JComponent createContentsPanel() {
        this.fileNameLabel = new JLabel();
        this.fileName = new JTextField();
        this.tree = new FileTree();
        this.tree.addPropertyChangeListener(this);
        this.bar = new ActionToolBar(this.tree.getActionMap());
        this.bar.setDocumentUri(uri);
        this.bar.setFloatable(false);
        JScrollPane treePanel = new JScrollPane();
        treePanel.setViewportView(this.tree);
        treePanel.setColumnHeaderView(this.bar);
        FormLayout layout = new FormLayout("right:pref, 3px , 320px", "p , 3px , p");
        JPanel content = new JPanel((LayoutManager)layout);
        CellConstraints cc = new CellConstraints();
        content.add((Component)treePanel, cc.xyw(1, 1, 3));
        content.add((Component)this.fileNameLabel, cc.xy(1, 3));
        content.add((Component)this.fileName, cc.xy(3, 3));
        return content;
    }

    protected void initializeContents() {
    }

    protected void prepareContents() {
        super.setDialogTitle(this.getDefaultDialogTitle());
        super.setApproveButtonText(this.getDefaultApproveButtonText());
        super.setApproveButtonMnemonic(this.getDefaultApproveButtonMnemonic());
        super.setApproveButtonToolTipText(this.getDefaultApproveButtonToolTipText());
        this.fileNameLabel.setText(this.getDefaultFileNameLabelText());
        this.tree.refresh();
        this.updateFileFieldText();
    }

    public FileTreeNodeList createNewRootNode() {
        if (this.selectionMode == 1) {
            return new FolderTreeNodeList(this.rootFile);
        }
        return new FileTreeNodeList(this.rootFile);
    }

    public void setCurrentDirectory(File rootFile) {
        this.rootFile = rootFile.getAbsoluteFile();
        this.tree.getFileTreeModel().setRoot(this.createNewRootNode());
    }

    public File getCurrentDirectory() {
        return this.rootFile;
    }

    public void setFileSelectionMode(int selectionMode) {
        this.selectionMode = selectionMode;
        this.tree.getFileTreeModel().setRoot(this.createNewRootNode());
    }

    public int getFileSelectionMode() {
        return this.selectionMode;
    }

    public void setDialogType(int dialogType) {
        this.dialogType = dialogType;
    }

    public int getDialogType() {
        return this.dialogType;
    }

    private String getDefaultDialogTitle() {
        if (this.dialogTitle != null) {
            return this.dialogTitle;
        }
        return this.dialogType == 0 ? UIManager.getString("FileChooser.openDialogTitleText") : UIManager.getString("FileChooser.saveDialogTitleText");
    }

    private String getDefaultApproveButtonText() {
        return this.dialogType == 0 ? UIManager.getString("FileChooser.openButtonText") : UIManager.getString("FileChooser.saveButtonText");
    }

    private int getDefaultApproveButtonMnemonic() {
        return this.dialogType == 0 ? UIManager.getInt("FileChooser.openButtonMnemonic") : UIManager.getInt("FileChooser.saveButtonMnemonic");
    }

    private String getDefaultApproveButtonToolTipText() {
        return this.dialogType == 0 ? UIManager.getString("FileChooser.openButtonToolTipText") : UIManager.getString("FileChooser.saveButtonToolTipText");
    }

    private String getDefaultFileNameLabelText() {
        return UIManager.getString("FileChooser.fileNameLabelText");
    }

    public void setExtension(String extension, String discription) {
        this.setExtension(new ExampleFileFilter(extension, discription));
    }

    public void setExtension(String[] extensions, String discription) {
        this.setExtension(new ExampleFileFilter(extensions, discription));
    }

    public void setExtension(ExampleFileFilter filter) {
        this.filter = filter;
    }

    private ExampleFileFilter getFileFilter() {
        return this.filter;
    }

    public File getSelectedFile() {
        File file = this.tree.getSelectedFile();
        String text = this.fileName.getText();
        if (text == null || "".equals(text)) {
            return null;
        }
        String name = FileManager.getSystemDisplayName(file);
        if (name.equals(text)) {
            return file;
        }
        if (file.isDirectory()) {
            return new File(file, text);
        }
        return new File(file.getParentFile(), text);
    }

    public void approveSelection() {
        File file = this.getSelectedFile();
        ExampleFileFilter filter = this.getFileFilter();
        String text = this.fileName.getText();
        if (this.selectionMode == 0 && text != null && !"".equals(text) && filter != null && !filter.accept(file)) {
            String name = String.valueOf(this.fileName.getText()) + "." + filter.getExtension();
            this.fileName.setText(name);
            file = new File(String.valueOf(file.toString()) + "." + filter.getExtension());
        }
        if (file != null) {
            String msg;
            if (this.dialogType == 0) {
                if (file.exists()) {
                    super.approveSelection();
                } else {
                    msg = bundle.getString("NoExistDialog.message", new Object[]{file});
                    String title = this.getDefaultDialogTitle();
                    JOptionPane.showMessageDialog(this, msg, title, 2);
                }
            } else if (file.exists()) {
                String title;
                msg = bundle.getString("OverwriteDialog.message", new Object[]{file});
                int r = JOptionPane.showConfirmDialog(this, msg, title = this.getDefaultDialogTitle(), 0);
                if (r == 0) {
                    super.approveSelection();
                }
            } else {
                super.approveSelection();
            }
        }
    }

    public int showOpenDialog(Component comp) {
        this.setDialogType(0);
        return super.showDialog(comp);
    }

    public int showSaveDialog(Component comp) {
        this.setDialogType(1);
        return super.showDialog(comp);
    }

    private void updateFileFieldText() {
        File f = this.tree.getSelectedFile();
        if (f != null) {
            String name = FileManager.getSystemDisplayName(f);
            if (this.selectionMode == 1) {
                this.fileName.setText(f.isDirectory() ? name : null);
            } else {
                this.fileName.setText(f.isFile() ? name : null);
            }
        }
    }

    public void propertyChange(PropertyChangeEvent evt) {
        if ("leadSelectionPath".equals(evt.getPropertyName())) {
            this.updateFileFieldText();
        }
    }

    public static void main(String[] args) throws IOException, InterruptedException {
        JFrame f = new JFrame();
        f.setDefaultCloseOperation(3);
        f.pack();
        f.show();
        JFileTreeChooser t = new JFileTreeChooser();
        t.setCurrentDirectory(new File("D:/project-imhotep-rc1/user/library"));
        t.setFileSelectionMode(0);
        while (true) {
            int i = t.showOpenDialog(f);
            i = t.showSaveDialog(f);
            System.out.println(String.valueOf(i) + " " + t.getSelectedFile());
        }
    }
}

