/*
 * Decompiled with CFR 0.152.
 */
package core.swing;

import core.text.RectangleFormat;
import java.awt.Rectangle;
import java.net.URI;
import java.net.URL;
import java.text.MessageFormat;
import java.util.Locale;
import java.util.ResourceBundle;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.KeyStroke;

public class ResourceManager {
    private ResourceBundle bundle;

    private ResourceManager(ResourceBundle bundle) {
        this.bundle = bundle;
    }

    public static ResourceManager getBundle(String baseName) {
        return new ResourceManager(ResourceBundle.getBundle(baseName));
    }

    public static ResourceManager getBundle(String baseName, Locale locale) {
        return new ResourceManager(ResourceBundle.getBundle(baseName, locale));
    }

    public static ResourceManager getBundle(String baseName, Locale locale, ClassLoader loader) {
        return new ResourceManager(ResourceBundle.getBundle(baseName, locale, loader));
    }

    public Icon getIcon(String key) {
        String iconValue = this.bundle.getString(key);
        URL iconURL = ClassLoader.getSystemResource(iconValue);
        ImageIcon icon = new ImageIcon(iconURL);
        return icon;
    }

    public Rectangle getRectangle(String key) {
        String rectValue = this.bundle.getString(key);
        Rectangle rect = RectangleFormat.parse(rectValue);
        return rect;
    }

    public KeyStroke getKeyStroke(String key) {
        String keyStrokeValue = this.bundle.getString(key);
        KeyStroke keyStroke = KeyStroke.getKeyStroke(keyStrokeValue);
        return keyStroke;
    }

    public String getString(String key) {
        return this.bundle.getString(key);
    }

    public String getString(String key, Object[] args) {
        String messageValue = this.bundle.getString(key);
        String message = MessageFormat.format(messageValue, args);
        return message;
    }

    public static URI getResourceURI(String baseName) {
        return ResourceManager.getResourceURI(baseName, "xml");
    }

    public static URI getResourceURI(String baseName, String suffix) {
        return ResourceManager.getResourceURI(baseName, suffix, Locale.getDefault());
    }

    public static URI getResourceURI(String baseName, String suffix, Locale locale) {
        try {
            StringBuffer path = new StringBuffer();
            path.append(baseName.replace('.', '/'));
            path.append("_");
            path.append(locale.getLanguage());
            path.append("_");
            path.append(locale.getCountry());
            path.append(".");
            path.append(suffix);
            URL u = ClassLoader.getSystemResource(path.toString());
            return new URI(u.toString());
        }
        catch (Exception e) {
            return null;
        }
    }
}

