/*
 * Decompiled with CFR 0.152.
 */
package core.swing.chooser;

import java.io.File;
import java.io.IOException;
import java.util.Vector;
import javax.swing.Icon;
import javax.swing.filechooser.FileSystemView;
import sun.awt.shell.ShellFolder;

public class FileManager {
    private static FileSystemView fileSystem = FileSystemView.getFileSystemView();

    private FileManager() {
    }

    public static String getSystemDisplayName(File f) {
        return fileSystem.getSystemDisplayName(f);
    }

    public static Icon getSystemIcon(File f) {
        return fileSystem.getSystemIcon(f);
    }

    public static File getHomeDirectory() {
        return fileSystem.getHomeDirectory();
    }

    public static File getDefaultDirectory() {
        return fileSystem.getDefaultDirectory();
    }

    public static Vector getChildFileList(File file, int mode) {
        try {
            Vector<File> acceptsList = new Vector<File>();
            File[] list = fileSystem.getFiles(file, false);
            int i = 0;
            while (i < list.length) {
                acceptsList.addElement(list[i]);
                ++i;
            }
            Vector<File> folderList = new Vector<File>();
            Vector<File> fileList = new Vector<File>();
            File f = null;
            int i2 = 0;
            while (i2 < acceptsList.size()) {
                f = (File)acceptsList.get(i2);
                if (f.isDirectory()) {
                    folderList.addElement(f);
                } else {
                    fileList.addElement(f);
                }
                ++i2;
            }
            ShellFolder.sortFiles(folderList);
            if (mode == 0) {
                ShellFolder.sortFiles(fileList);
                folderList.addAll(fileList);
            }
            return folderList;
        }
        catch (Throwable e) {
            return new Vector();
        }
    }

    public static File newFolder(File parentFile) {
        try {
            File file = fileSystem.createNewFolder(parentFile);
            return file;
        }
        catch (IOException e) {
            return null;
        }
    }

    public static File deleteFile(File f) {
        try {
            return f.delete() ? f : null;
        }
        catch (Exception e) {
            return null;
        }
    }

    public static File renameFile(File f, String fileName) {
        try {
            File renamed = new File(f.getParent(), fileName);
            return f.renameTo(renamed) ? renamed : null;
        }
        catch (Exception e) {
            return null;
        }
    }
}

