/*
 * Decompiled with CFR 0.152.
 */
package core.swing.dnd;

import java.awt.Toolkit;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.ClipboardOwner;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;

public class ExtendedClipboard
extends Clipboard {
    private Clipboard systemClipboard = Toolkit.getDefaultToolkit().getSystemClipboard();
    private static ExtendedClipboard clipboard;

    public static ExtendedClipboard getInstance() {
        if (clipboard == null) {
            clipboard = new ExtendedClipboard();
        }
        return clipboard;
    }

    ExtendedClipboard() {
        super("ExtendedClipboard");
    }

    public synchronized void setContents(Transferable contents, ClipboardOwner owner) {
        this.systemClipboard.setContents(contents, null);
        super.setContents(contents, owner);
    }

    public synchronized Transferable getContents(Object requestor) {
        Transferable t = this.systemClipboard.getContents(null);
        String text = null;
        try {
            text = (String)t.getTransferData(DataFlavor.stringFlavor);
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (text != null && !"".equals(text.trim())) {
            super.setContents(t, null);
        } else if (super.getContents(null) != null) {
            this.systemClipboard.setContents(super.getContents(null), null);
        }
        return super.getContents(requestor);
    }
}

