/*
 * Decompiled with CFR 0.152.
 */
package core.swing.tree;

import core.swing.tree.ObjectTreeModel;
import core.swing.tree.ObjectTreeNode;
import core.swing.tree.ObjectTreeNodeList;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import javax.swing.Icon;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JScrollPane;
import javax.swing.JTree;
import javax.swing.event.TreeExpansionEvent;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.event.TreeWillExpandListener;
import javax.swing.tree.DefaultTreeCellEditor;
import javax.swing.tree.DefaultTreeCellRenderer;
import javax.swing.tree.ExpandVetoException;
import javax.swing.tree.TreePath;

public class ObjectTree
extends JTree
implements TreeWillExpandListener,
TreeSelectionListener,
MouseListener {
    private ObjectTreeCellRenderer renderer = new ObjectTreeCellRenderer();
    private ObjectTreeCellEditor editor = new ObjectTreeCellEditor(this, this.renderer);

    public ObjectTree() {
        this((ObjectTreeNodeList)null);
    }

    public ObjectTree(ObjectTreeNodeList n) {
        this(new ObjectTreeModel(n));
    }

    public ObjectTree(ObjectTreeModel m) {
        super(m);
        super.setEditable(false);
        super.setCellRenderer(this.renderer);
        super.addMouseListener(this);
        super.addTreeWillExpandListener(this);
        super.addTreeSelectionListener(this);
    }

    protected void expandedNode(ObjectTreeNode otn) {
        otn.rebuild();
    }

    protected void selectedNode(ObjectTreeNode otn) {
    }

    protected void singleClickedNode(ObjectTreeNode otn) {
    }

    protected void doubleClickedNode(ObjectTreeNode otn) {
    }

    protected void popupClickedNode(ObjectTreeNode otn, int c, int y) {
    }

    protected String convertNodeToText(ObjectTreeNode otn) {
        return otn.toString();
    }

    protected Icon convertNodeToIcon(ObjectTreeNode otn) {
        return null;
    }

    public String convertValueToText(Object value, boolean selected, boolean expanded, boolean leaf, int row, boolean hasFocus) {
        if (value instanceof ObjectTreeNode) {
            return this.convertNodeToText((ObjectTreeNode)value);
        }
        return value != null ? value.toString() : "Unknown";
    }

    public Icon convertValueToIcon(Object value, boolean selected, boolean expanded, boolean leaf, int row, boolean hasFocus) {
        Icon icon = null;
        if (value instanceof ObjectTreeNode) {
            icon = this.convertNodeToIcon((ObjectTreeNode)value);
        }
        if (icon == null) {
            icon = leaf ? this.renderer.getLeafIcon() : (expanded ? this.renderer.getOpenIcon() : this.renderer.getClosedIcon());
        }
        return icon;
    }

    public void treeWillCollapse(TreeExpansionEvent event) throws ExpandVetoException {
    }

    public void treeWillExpand(TreeExpansionEvent e) throws ExpandVetoException {
        TreePath treepath = e.getPath();
        if (treepath == null) {
            return;
        }
        Object obj = treepath.getLastPathComponent();
        if (obj instanceof ObjectTreeNode) {
            this.expandedNode((ObjectTreeNode)obj);
        }
    }

    public void valueChanged(TreeSelectionEvent e) {
        TreePath treepath = e.getPath();
        if (treepath == null) {
            return;
        }
        Object obj = treepath.getLastPathComponent();
        if (obj instanceof ObjectTreeNode) {
            this.selectedNode((ObjectTreeNode)obj);
        }
    }

    public void mouseClicked(MouseEvent e) {
        TreePath treepath = super.getPathForLocation(e.getX(), e.getY());
        if (treepath == null) {
            return;
        }
        Object obj = treepath.getLastPathComponent();
        if (obj instanceof ObjectTreeNode) {
            if (e.getClickCount() == 1) {
                this.singleClickedNode((ObjectTreeNode)obj);
            } else if (e.getClickCount() == 2) {
                this.doubleClickedNode((ObjectTreeNode)obj);
            }
        }
    }

    public void mouseReleased(MouseEvent e) {
        int y;
        if (!e.isPopupTrigger()) {
            return;
        }
        int x = e.getX();
        TreePath path = super.getPathForLocation(x, y = e.getY());
        if (path != null) {
            super.setSelectionPath(path);
        } else {
            path = super.getSelectionPath();
        }
        if (path == null) {
            return;
        }
        Object obj = path.getLastPathComponent();
        if (obj instanceof ObjectTreeNode) {
            this.popupClickedNode((ObjectTreeNode)obj, x, y);
        }
    }

    public void mouseEntered(MouseEvent e) {
    }

    public void mouseExited(MouseEvent e) {
    }

    public void mousePressed(MouseEvent e) {
    }

    public static void main(String[] arg) throws InterruptedException {
        ObjectTreeNodeList r = new ObjectTreeNodeList("A");
        ObjectTreeNodeList b = new ObjectTreeNodeList("b");
        r.addElement(new ObjectTreeNode("a"));
        r.addElement(b);
        r.addElement(new ObjectTreeNode("c"));
        ObjectTreeModel m = new ObjectTreeModel(r);
        ObjectTree t = new ObjectTree(m);
        JFrame f = new JFrame();
        f.setDefaultCloseOperation(3);
        f.getContentPane().setLayout(new BorderLayout());
        f.getContentPane().add((Component)new JScrollPane(t), "Center");
        f.pack();
        f.show();
        Thread.sleep(3000L);
        System.out.println("Start");
        b.addElement(new ObjectTreeNode("bbb"));
        b.addElement(new ObjectTreeNode("cc"));
        r.addElement(new ObjectTreeNode("d"));
        System.out.println("End" + r.size());
    }

    protected class ObjectTreeCellRenderer
    extends DefaultTreeCellRenderer {
        protected ObjectTreeCellRenderer() {
        }

        public Component getTreeCellRendererComponent(JTree tree, Object value, boolean sel, boolean expanded, boolean leaf, int row, boolean hasFocus) {
            JLabel label = (JLabel)super.getTreeCellRendererComponent(tree, value, sel, expanded, leaf, row, hasFocus);
            String t = tree.convertValueToText(value, sel, expanded, leaf, row, hasFocus);
            Icon icon = ObjectTree.this.convertValueToIcon(value, sel, expanded, leaf, row, hasFocus);
            label.setIcon(icon);
            label.setText(t);
            return label;
        }
    }

    protected class ObjectTreeCellEditor
    extends DefaultTreeCellEditor {
        public ObjectTreeCellEditor(JTree tree, DefaultTreeCellRenderer renderer) {
            super(tree, renderer);
        }

        protected void determineOffset(JTree tree, Object value, boolean isSelected, boolean expanded, boolean leaf, int row) {
            super.determineOffset(tree, value, isSelected, expanded, leaf, row);
            this.editingIcon = ObjectTree.this.convertValueToIcon(value, isSelected, expanded, leaf, row, true);
        }
    }
}

