/*
 * Decompiled with CFR 0.152.
 */
package core.swing.tree;

import core.swing.tree.ObjectTreeModel;
import core.swing.tree.ObjectTreeNode;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.Iterator;

public class ObjectTreeNodeList
extends ObjectTreeNode {
    private static final ArrayList tempList = new ArrayList(100);
    private final ArrayList childList = new ArrayList(10);

    public ObjectTreeNodeList(Object userObject) {
        super(userObject);
    }

    public void setModel(ObjectTreeModel m) {
        super.setModel(m);
        ObjectTreeNode c = null;
        int size = this.childList.size();
        int i = 0;
        while (i < size) {
            c = (ObjectTreeNode)this.childList.get(i);
            c.setModel(m);
            ++i;
        }
    }

    public void addElement(ObjectTreeNode node) {
        ObjectTreeNode child = node;
        child.setParent(this);
        child.setModel(this.treeModel);
        this.childList.add(child);
        if (this.treeModel != null) {
            Object[] path = this.getPath();
            int[] childIndices = new int[]{this.childList.size() - 1};
            Object[] children = new Object[]{child};
            this.treeModel.fireTreeNodesInserted(path, childIndices, children);
        }
    }

    public void removeElement(ObjectTreeNode node) {
        Object child;
        int index = this.childList.indexOf(node);
        Object v0 = child = index >= 0 ? this.childList.remove(index) : null;
        if (this.treeModel != null) {
            Object[] path = super.getPath();
            int[] childIndices = new int[]{index};
            Object[] children = new Object[]{child};
            this.treeModel.fireTreeNodesRemoved(path, childIndices, children);
        }
    }

    public Object elementAt(int i) {
        return this.childList.get(i);
    }

    public Iterator iterator() {
        return ((AbstractList)this.childList).iterator();
    }

    public int indexOf(Object obj) {
        return this.childList.indexOf(obj);
    }

    public boolean contains(Object obj) {
        return this.childList.indexOf(obj) != -1;
    }

    public void clear() {
        this.childList.clear();
    }

    public int size() {
        return this.childList.size();
    }

    protected void updateList(ArrayList newlist) {
        tempList.clear();
        Object obj = null;
        int size = this.childList.size();
        int i = 0;
        while (i < size) {
            obj = this.childList.get(i);
            tempList.add(obj);
            ++i;
        }
        int tempSize = tempList.size();
        int i2 = 0;
        while (i2 < tempSize) {
            if (tempList.get(i2) instanceof ObjectTreeNode) {
                this.removeElement((ObjectTreeNode)tempList.get(i2));
            }
            ++i2;
        }
        int newSize = newlist.size();
        int i3 = 0;
        while (i3 < newSize) {
            obj = newlist.get(i3);
            if (!this.contains(obj) && obj instanceof ObjectTreeNode) {
                this.addElement((ObjectTreeNode)obj);
            }
            ++i3;
        }
        tempList.clear();
    }
}

