/*
 * Decompiled with CFR 0.152.
 */
package core.text;

import java.awt.Color;
import java.util.HashMap;

public class ColorFormat {
    private static HashMap colorMap = new HashMap();

    static {
        colorMap.put("aqua", new Color(0, 255, 255));
        colorMap.put("black", Color.black);
        colorMap.put("blue", Color.blue);
        colorMap.put("fuchsia", new Color(255, 0, 255));
        colorMap.put("gray", new Color(128, 128, 128));
        colorMap.put("green", new Color(0, 128, 0));
        colorMap.put("lime", new Color(0, 255, 0));
        colorMap.put("maroon", new Color(128, 0, 0));
        colorMap.put("navy", new Color(0, 0, 128));
        colorMap.put("olive", new Color(128, 128, 0));
        colorMap.put("purple", new Color(128, 0, 128));
        colorMap.put("red", new Color(255, 0, 0));
        colorMap.put("silver", new Color(192, 192, 192));
        colorMap.put("teal", new Color(0, 128, 128));
        colorMap.put("white", Color.white);
        colorMap.put("yellow", Color.yellow);
    }

    private ColorFormat() {
    }

    public static String format(Color color) {
        if (color != null) {
            return "rgb(" + color.getRed() + "," + color.getGreen() + "," + color.getBlue() + ")";
        }
        return "rgb(0,0,0)";
    }

    public static Color parse(String str) {
        if (str.startsWith("rgb")) {
            int index0 = str.indexOf("(");
            int index1 = str.indexOf(",");
            String txt = str.substring(index0 + 1, index1).trim();
            int red = Integer.parseInt(txt);
            index0 = index1;
            index1 = str.indexOf(",", index0 + 1);
            txt = str.substring(index0 + 1, index1).trim();
            int green = Integer.parseInt(txt);
            index0 = index1;
            index1 = str.indexOf(")", index0 + 1);
            txt = str.substring(index0 + 1, index1).trim();
            int blue = Integer.parseInt(txt);
            return new Color(red, green, blue);
        }
        if (colorMap.containsKey(str)) {
            return (Color)colorMap.get(str);
        }
        return Color.black;
    }
}

