/*
 * Decompiled with CFR 0.152.
 */
package core.util;

import core.util.StreamGobbler;
import java.io.File;
import java.io.IOException;
import java.io.StringWriter;

public class JarLauncher {
    private String jarUri;
    private StringBuffer args;
    private StringWriter outputBuffer;
    private StringWriter errorBuffer;

    public void setJarURI(String jarUri) throws RuntimeException {
        File f = new File(jarUri);
        if (!f.exists()) {
            throw new RuntimeException(String.valueOf(jarUri) + " is not exist");
        }
        this.jarUri = jarUri;
    }

    public void addArgument(String arg) {
        if (this.args == null) {
            this.args = new StringBuffer();
        }
        this.args.append(" ");
        this.args.append(arg);
    }

    public void clearArguments() {
        this.args = null;
    }

    public String toString() {
        StringBuffer cmd = new StringBuffer();
        cmd.append("java -jar ");
        cmd.append(this.jarUri);
        cmd.append(this.args);
        return cmd.toString();
    }

    public int execute() throws IOException, InterruptedException {
        if (this.jarUri == null || this.args == null) {
            throw new RuntimeException(String.valueOf(this.jarUri) + " is Null");
        }
        Runtime rt = Runtime.getRuntime();
        Process proc = rt.exec(this.toString());
        this.outputBuffer = new StringWriter();
        this.errorBuffer = new StringWriter();
        StreamGobbler output = new StreamGobbler("OUTPUT");
        output.setInput(proc.getInputStream());
        output.setOutput(this.outputBuffer);
        StreamGobbler error = new StreamGobbler("OUTPUT");
        error.setInput(proc.getErrorStream());
        error.setOutput(this.errorBuffer);
        output.start();
        error.start();
        int i = proc.waitFor();
        this.outputBuffer.close();
        this.errorBuffer.close();
        return i;
    }

    public String getExecOutputText() {
        if (this.outputBuffer == null) {
            return null;
        }
        return this.outputBuffer.toString();
    }

    public String getExecErrorText() {
        if (this.errorBuffer == null) {
            return null;
        }
        return this.errorBuffer.toString();
    }

    public static void main(String[] arg) throws IOException, InterruptedException {
        JarLauncher launcher = new JarLauncher();
        launcher.setJarURI("imhotepc.jar");
        launcher.addArgument("-t imhotepc.transcoder.dxf.tosvg.DXFTranscoder");
        launcher.addArgument("-w 200");
        launcher.addArgument("-h 200");
        launcher.addArgument("-i temp/DXF.dxf");
        launcher.addArgument("-o temp/out2.svg");
        int r = launcher.execute();
        System.out.println(launcher);
        System.out.println(r);
        System.out.println(launcher.getExecOutputText());
        System.out.println(launcher.getExecErrorText());
    }
}

