/*
 * Decompiled with CFR 0.152.
 */
package core.util;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.io.Reader;
import java.io.Writer;

public class StreamGobbler
extends Thread {
    private BufferedReader input;
    private PrintWriter output;
    private String name;
    private boolean isDebug;

    public StreamGobbler(String name) {
        this(name, false);
    }

    public StreamGobbler(String name, boolean isDebug) {
        this.name = name;
        this.isDebug = isDebug;
    }

    public void setInput(InputStream is) {
        this.input = new BufferedReader(new InputStreamReader(is));
    }

    public void setInput(Reader r) {
        this.input = new BufferedReader(r);
    }

    public void setOutput(OutputStream os) {
        this.output = new PrintWriter(os);
    }

    public void setOutput(Writer w) {
        this.output = new PrintWriter(w);
    }

    public void run() {
        if (this.input == null) {
            return;
        }
        try {
            String line = null;
            while ((line = this.input.readLine()) != null) {
                if (this.output != null) {
                    this.output.println(line);
                }
                if (!this.isDebug) continue;
                System.out.println(String.valueOf(this.name) + ">" + line);
            }
            if (this.output != null) {
                this.output.flush();
            }
        }
        catch (IOException ioe) {
            ioe.printStackTrace();
        }
    }
}

