/*
 * Decompiled with CFR 0.152.
 */
package core.xml;

import java.io.IOException;
import javax.xml.parsers.ParserConfigurationException;
import org.w3c.dom.DOMException;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;

public class DOMBuilderException
extends IOException {
    private int col = 0;
    private int row = 0;
    private String code;

    public DOMBuilderException(ParserConfigurationException e) {
        super(e.getMessage());
    }

    public DOMBuilderException(IOException e) {
        super(e.getMessage());
    }

    public DOMBuilderException(SAXException e) {
        super(e.getMessage());
        if (e instanceof SAXParseException) {
            SAXParseException saxException = (SAXParseException)e;
            this.col = saxException.getColumnNumber();
            this.row = saxException.getLineNumber();
        }
    }

    public DOMBuilderException(DOMException e) {
        super(e.getMessage());
        switch (e.code) {
            case 1: {
                this.code = "INDEX_SIZE_ERR";
                break;
            }
            case 2: {
                this.code = "DOMSTRING_SIZE_ERR";
                break;
            }
            case 3: {
                this.code = "HIERARCHY_REQUEST_ERR";
                break;
            }
            case 4: {
                this.code = "WRONG_DOCUMENT_ERR";
                break;
            }
            case 5: {
                this.code = "INVALID_CHARACTER_ERR";
                break;
            }
            case 6: {
                this.code = "NO_DATA_ALLOWED_ERR";
                break;
            }
            case 7: {
                this.code = "NO_MODIFICATION_ALLOWED_ERR";
                break;
            }
            case 8: {
                this.code = "NOT_FOUND_ERR";
                break;
            }
            case 9: {
                this.code = "NOT_SUPPORTED_ERR";
                break;
            }
            case 10: {
                this.code = "INUSE_ATTRIBUTE_ERR";
                break;
            }
            case 11: {
                this.code = "INVALID_STATE_ERR";
                break;
            }
            case 12: {
                this.code = "SYNTAX_ERR";
                break;
            }
            case 13: {
                this.code = "INVALID_MODIFICATION_ERR";
                break;
            }
            case 14: {
                this.code = "NAMESPACE_ERR";
                break;
            }
            case 15: {
                this.code = "INVALID_ACCESS_ERR";
            }
        }
    }

    public String getCodeDisplay() {
        return this.code;
    }

    public int getColumnNumber() {
        return this.col;
    }

    public int getLineNumber() {
        return this.row;
    }
}

