/*
 * Decompiled with CFR 0.152.
 */
package core.xml;

import core.xml.DOMBuilderException;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.net.URI;
import java.util.ArrayList;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.w3c.dom.DOMImplementation;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.Text;
import org.w3c.dom.traversal.DocumentTraversal;
import org.w3c.dom.traversal.NodeIterator;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class DOMBuilderWrapper {
    protected DOMBuilderWrapper() {
    }

    public static Document create() throws DOMBuilderException {
        try {
            DocumentBuilderFactory builderFactory = DocumentBuilderFactory.newInstance();
            DocumentBuilder builder = builderFactory.newDocumentBuilder();
            Document doc = builder.newDocument();
            return doc;
        }
        catch (ParserConfigurationException e) {
            throw new DOMBuilderException(e);
        }
    }

    public static Document create(String namespaceURI, String qualifiedName) throws DOMBuilderException {
        try {
            DocumentBuilderFactory builderFactory = DocumentBuilderFactory.newInstance();
            DocumentBuilder builder = builderFactory.newDocumentBuilder();
            DOMImplementation impl = builder.getDOMImplementation();
            Document doc = impl.createDocument(namespaceURI, qualifiedName, null);
            return doc;
        }
        catch (ParserConfigurationException e) {
            throw new DOMBuilderException(e);
        }
    }

    private static Document parse(InputSource s) throws DOMBuilderException {
        try {
            DocumentBuilderFactory builderFactory = DocumentBuilderFactory.newInstance();
            DocumentBuilder builder = builderFactory.newDocumentBuilder();
            Document doc = builder.parse(s);
            return doc;
        }
        catch (ParserConfigurationException e) {
            throw new DOMBuilderException(e);
        }
        catch (SAXException e) {
            throw new DOMBuilderException(e);
        }
        catch (IOException e) {
            throw new DOMBuilderException(e);
        }
    }

    public static Document parse(String uri) throws DOMBuilderException {
        InputSource i = new InputSource(uri);
        return DOMBuilderWrapper.parse(i);
    }

    public static Document parse(URI uri) throws DOMBuilderException {
        InputSource i = new InputSource(uri.toString());
        return DOMBuilderWrapper.parse(i);
    }

    public static Document parse(File f) throws DOMBuilderException {
        InputSource i = new InputSource(f.toURI().toString());
        return DOMBuilderWrapper.parse(i);
    }

    public static Document parse(Reader r) throws DOMBuilderException {
        InputSource i = new InputSource(r);
        return DOMBuilderWrapper.parse(i);
    }

    public static Document parse(InputStream in) throws DOMBuilderException {
        InputSource i = new InputSource(in);
        return DOMBuilderWrapper.parse(i);
    }

    public static void normalizeDocument(Document document) {
        ArrayList<Node> arraylist = new ArrayList<Node>();
        DocumentTraversal documenttraversal = (DocumentTraversal)((Object)document);
        NodeIterator nodeiterator = documenttraversal.createNodeIterator(document, 4, null, false);
        Node node = nodeiterator.nextNode();
        while (node != null) {
            Text text;
            String s;
            if (node instanceof Text && (s = (text = (Text)node).getNodeValue().trim()).length() == 0) {
                arraylist.add(node);
            }
            node = nodeiterator.nextNode();
        }
        int i = 0;
        while (i < arraylist.size()) {
            Node node1 = (Node)arraylist.get(i);
            Node node2 = node1.getParentNode();
            node2.removeChild(node1);
            ++i;
        }
    }
}

