/*
 * Decompiled with CFR 0.152.
 */
package core.xml;

import core.xml.Unicode;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.io.Writer;
import org.w3c.dom.Attr;
import org.w3c.dom.CDATASection;
import org.w3c.dom.Comment;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.Text;

public class XMLWriter {
    private static String TAG_END = " />";
    private static String TAG_START = "</";
    private String EOL;
    private String SPACE = " ";
    private String ENCODING;
    private boolean isUnicoded;
    private String NAME;
    private String PUBLIC_ID;
    private String SYSTEM_ID;

    public void setUnicoded(boolean isUnicoded) {
        this.isUnicoded = isUnicoded;
    }

    public boolean isUnicoded() {
        return this.isUnicoded;
    }

    public void setSpace(String space) {
        this.SPACE = space;
    }

    public String getSpace() {
        return this.SPACE;
    }

    public void setEncodingName(String encoding) {
        this.ENCODING = encoding;
    }

    public String getEncodingName() {
        return this.ENCODING;
    }

    public void setDocumentType(String qualifiedName, String publicId, String systemId) {
        this.NAME = qualifiedName;
        this.PUBLIC_ID = publicId;
        this.SYSTEM_ID = systemId;
    }

    public XMLWriter() {
        try {
            this.EOL = System.getProperty("line.separator", "\n");
        }
        catch (SecurityException e) {
            this.EOL = "\n";
        }
    }

    private void writeXml(Attr attr, IndentWriter out) throws IOException {
        String name = attr.getName();
        out.write(name);
        out.write("=\"");
        this.writeChildrenXml(attr, out);
        out.write(34);
    }

    private void writeChildrenXml(Attr attr, IndentWriter out) throws IOException {
        String value = attr.getValue();
        int i = 0;
        while (i < value.length()) {
            char c = value.charAt(i);
            if (this.isUnicoded && c > 'z') {
                out.write(Unicode.encode((int)c));
            } else {
                switch (c) {
                    case '<': {
                        out.write("&lt;");
                        break;
                    }
                    case '>': {
                        out.write("&gt;");
                        break;
                    }
                    case '&': {
                        out.write("&amp;");
                        break;
                    }
                    case '\'': {
                        out.write("&apos;");
                        break;
                    }
                    case '\"': {
                        out.write("&quot;");
                        break;
                    }
                    case '\n': {
                        break;
                    }
                    default: {
                        out.write(c);
                    }
                }
            }
            ++i;
        }
    }

    /*
     * Unable to fully structure code
     */
    private void writeXml(Comment comment, IndentWriter out) throws IOException {
        block4: {
            data = comment.getData().toCharArray();
            out.write("<!--");
            if (data == null) break block4;
            sawDash = false;
            length = data.length;
            i = 0;
            while (i < length) {
                if (data[i] != '-') ** GOTO lbl14
                if (!sawDash) {
                    sawDash = true;
                    out.write(45);
                } else {
                    out.write(32);
lbl14:
                    // 2 sources

                    sawDash = false;
                    out.write(data[i]);
                }
                ++i;
            }
            if (data[data.length - 1] == '-') {
                out.write(32);
            }
        }
        out.write("-->");
    }

    private void writeXml(Text text, IndentWriter out) throws IOException {
        String t = text.getData().trim();
        if (t.length() < 1) {
            return;
        }
        char[] data = t.toCharArray();
        int start = 0;
        int last = 0;
        while (last < data.length) {
            char c = data[last];
            if (c == '<') {
                out.write(data, start, last - start);
                start = last + 1;
                out.write("&lt;");
            } else if (c == '>') {
                out.write(data, start, last - start);
                start = last + 1;
                out.write("&gt;");
            } else if (c == '&') {
                out.write(data, start, last - start);
                start = last + 1;
                out.write("&amp;");
            } else if (this.isUnicoded && c > '\u007f') {
                out.write(data, start, last - start);
                start = last + 1;
                out.write(Unicode.encode(c));
            }
            ++last;
        }
        out.write(data, start, last - start);
    }

    private void writeXml(CDATASection cdataSection, IndentWriter out) throws IOException {
        char[] data = cdataSection.getData().toCharArray();
        out.write("<![CDATA[");
        int i = 0;
        while (i < data.length) {
            char c = data[i];
            if (c == ']' && i + 2 < data.length && data[i + 1] == ']' && data[i + 2] == '>') {
                out.write("]]]]><![CDATA[>");
            } else {
                out.write(c);
            }
            ++i;
        }
        out.write("]]>");
    }

    private void writeXml(Element element, IndentWriter out) throws IOException {
        out.write(TAG_START, 0, 1);
        out.write(element.getTagName());
        NamedNodeMap attributes = element.getAttributes();
        if (attributes != null) {
            int nAttr = attributes.getLength();
            int i = 0;
            while (i < nAttr) {
                Attr attr = (Attr)attributes.item(i);
                if (attr.getSpecified()) {
                    out.write(32);
                    this.writeXml(attr, out);
                }
                ++i;
            }
        }
        if (!element.hasChildNodes()) {
            out.write(TAG_END, 0, 3);
        } else {
            out.write(TAG_END, 2, 1);
            this.writeChildrenXml(element, out);
            out.write(TAG_START, 0, 2);
            out.write(element.getTagName());
            out.write(TAG_END, 2, 1);
        }
    }

    private void writeChildrenXml(Element element, IndentWriter out) throws IOException {
        NodeList children = element.getChildNodes();
        if (children == null) {
            return;
        }
        int length = children.getLength();
        int oldIndent = 0;
        oldIndent = out.getIndentLevel();
        try {
            out.setIndentLevel(oldIndent + 2);
            int i = 0;
            while (i < length) {
                if (children.item(i).getNodeType() != 3) {
                    out.printIndent();
                }
                this.writeXml(children.item(i), (Writer)out);
                ++i;
            }
        }
        catch (Throwable throwable) {
            Object var7_8 = null;
            out.setIndentLevel(oldIndent);
            Node t = children.item(length - 1);
            if (t.getNodeType() == 3 && t.getNodeValue().trim().length() != 0) {
                return;
            }
            out.printIndent();
            throw throwable;
        }
        Object var7_9 = null;
        out.setIndentLevel(oldIndent);
        Node t = children.item(length - 1);
        if (t.getNodeType() == 3 && t.getNodeValue().trim().length() != 0) {
            return;
        }
        out.printIndent();
    }

    private void writeDocumentHeader(IndentWriter out) throws IOException {
        if (this.ENCODING == null && out.getProxied() instanceof OutputStreamWriter) {
            String e = this.java2std(((OutputStreamWriter)out.getProxied()).getEncoding());
            this.setEncodingName(e);
        }
        out.write("<?xml version=\"1.0\"");
        if (this.ENCODING != null) {
            out.write(" encoding=\"");
            out.write(this.ENCODING);
            out.write(34);
        }
        out.write("?>");
        out.write(this.EOL);
        if (this.NAME != null && this.PUBLIC_ID != null && this.SYSTEM_ID != null) {
            out.write("<!DOCTYPE ");
            out.write(this.NAME);
            out.write(" PUBLIC '");
            out.write(this.PUBLIC_ID);
            out.write("' '");
            out.write(this.SYSTEM_ID);
            out.write("'");
            out.write(">");
            out.write(this.EOL);
        }
    }

    private void writeXml(Document document, IndentWriter out) throws IOException {
        this.writeDocumentHeader(out);
        NodeList childList = document.getChildNodes();
        this.writeXml(childList, out);
    }

    private void writeXml(NodeList childList, IndentWriter out) throws IOException {
        int length = childList.getLength();
        if (length == 0) {
            return;
        }
        int i = 0;
        while (i < length) {
            Node child = childList.item(i);
            this.writeXml(child, (Writer)out);
            out.write(this.EOL);
            ++i;
        }
    }

    private String java2std(String encodingName) {
        if (encodingName == null) {
            return null;
        }
        if (encodingName.startsWith("ISO8859_")) {
            return "ISO-8859-" + encodingName.substring(8);
        }
        if (encodingName.startsWith("8859_")) {
            return "ISO-8859-" + encodingName.substring(5);
        }
        if ("ASCII7".equalsIgnoreCase(encodingName) || "ASCII".equalsIgnoreCase(encodingName)) {
            return "US-ASCII";
        }
        if ("UTF8".equalsIgnoreCase(encodingName)) {
            return "UTF-8";
        }
        if (encodingName.startsWith("Unicode")) {
            return "UTF-16";
        }
        if ("SJIS".equalsIgnoreCase(encodingName)) {
            return "Shift_JIS";
        }
        if ("JIS".equalsIgnoreCase(encodingName)) {
            return "ISO-2022-JP";
        }
        if ("EUCJIS".equalsIgnoreCase(encodingName)) {
            return "EUC-JP";
        }
        return encodingName;
    }

    public void writeXml(Node node, Writer writer) throws IOException {
        IndentWriter out = null;
        out = writer instanceof IndentWriter ? (IndentWriter)writer : new IndentWriter(writer);
        switch (node.getNodeType()) {
            case 2: {
                this.writeXml((Attr)node, out);
                break;
            }
            case 8: {
                this.writeXml((Comment)node, out);
                break;
            }
            case 3: {
                this.writeXml((Text)node, out);
                break;
            }
            case 4: {
                this.writeXml((CDATASection)node, out);
                break;
            }
            case 9: {
                this.writeXml((Document)node, out);
                break;
            }
            case 11: {
                this.writeDocumentHeader(out);
                NodeList childList = node.getChildNodes();
                this.writeXml(childList, out);
                break;
            }
            case 1: {
                this.writeXml((Element)node, out);
            }
        }
    }

    private class IndentWriter
    extends Writer {
        private Writer proxied;
        private int indentLevel;

        public IndentWriter(Writer proxied) {
            if (proxied == null) {
                throw new NullPointerException();
            }
            this.proxied = proxied;
        }

        public void setIndentLevel(int indentLevel) {
            this.indentLevel = indentLevel;
        }

        public int getIndentLevel() {
            return this.indentLevel;
        }

        public void printIndent() throws IOException {
            this.proxied.write(XMLWriter.this.EOL);
            int temp = this.indentLevel;
            while (temp > 0) {
                this.proxied.write(XMLWriter.this.SPACE);
                --temp;
            }
        }

        public Writer getProxied() {
            return this.proxied;
        }

        public void write(int c) throws IOException {
            this.proxied.write(c);
        }

        public void write(char[] cbuf) throws IOException {
            this.proxied.write(cbuf);
        }

        public void write(char[] cbuf, int off, int len) throws IOException {
            this.proxied.write(cbuf, off, len);
        }

        public void write(String str) throws IOException {
            this.proxied.write(str);
        }

        public void write(String str, int off, int len) throws IOException {
            this.proxied.write(str, off, len);
        }

        public void flush() throws IOException {
            this.proxied.flush();
        }

        public void close() throws IOException {
            this.proxied.close();
        }
    }
}

