/*
 * Decompiled with CFR 0.152.
 */
package imhotep;

import com.jgoodies.plaf.FontSizeHints;
import com.jgoodies.plaf.Options;
import com.jgoodies.plaf.plastic.PlasticLookAndFeel;
import com.jgoodies.plaf.plastic.PlasticTheme;
import com.jgoodies.plaf.plastic.PlasticXPLookAndFeel;
import com.jgoodies.plaf.plastic.theme.DesertBluer;
import core.swing.CommandManager;
import core.swing.ResourceManager;
import core.text.RectangleFormat;
import core.xml.DOMBuilderException;
import imhotep.dom.DomPalette;
import imhotep.editor.SVGEditorDesktop;
import imhotep.editor.SVGPalette;
import imhotep.layer.LayerPalette;
import imhotep.library.LibraryPalette;
import imhotep.memory.MemoryPalette;
import imhotep.menu.Menu;
import imhotep.menu.MenuBar;
import imhotep.menu.UIDrawBar;
import imhotep.menu.UIMenuBar;
import imhotep.menu.UIPopupBar;
import imhotep.menu.UIStatusBar;
import imhotep.menu.UIToolBar;
import imhotep.properties.PropertiesPalette;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.lang.reflect.InvocationTargetException;
import java.net.URL;
import java.util.Locale;
import java.util.prefs.Preferences;
import javax.swing.ImageIcon;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JWindow;
import javax.swing.LookAndFeel;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;

public class Main
extends JFrame
implements WindowListener {
    private static String RESOURCE_NAME;
    private static ResourceManager resource;
    private static CommandManager commands;
    private SVGEditorDesktop desktop = new SVGEditorDesktop();
    private UIMenuBar menuBar = new UIMenuBar();
    private UIToolBar toolBar = new UIToolBar();
    private UIPopupBar popupBar0 = new UIPopupBar.Canvas();
    private UIPopupBar popupBar1 = new UIPopupBar.Source();
    private UIPopupBar popupBar2 = new UIPopupBar.Preview();
    private UIDrawBar drawBar = new UIDrawBar();
    private UIStatusBar statusBar = new UIStatusBar();
    private LibraryPalette libraryPalette = new LibraryPalette(this);
    private LayerPalette layerPalette = new LayerPalette(this);
    private DomPalette treePalette = new DomPalette(this);
    private PropertiesPalette propPalette = new PropertiesPalette(this);
    private MemoryPalette memoryPalette = new MemoryPalette(this);

    public Main() throws DOMBuilderException {
        Object[] keys = commands.allKeys();
        Menu menu = null;
        int i = 0;
        while (i < keys.length) {
            menu = (Menu)commands.getCommand(keys[i]);
            menu.register(this);
            menu.addCommandListener(this.statusBar);
            this.desktop.addSVGEditorListener(menu);
            ++i;
        }
        this.desktop.addSVGEditorListener(this.menuBar);
        this.desktop.addSVGEditorListener(this.toolBar);
        this.desktop.addSVGEditorListener(this.popupBar0);
        this.desktop.addSVGEditorListener(this.popupBar1);
        this.desktop.addSVGEditorListener(this.popupBar2);
        this.desktop.addSVGEditorListener(this.drawBar);
        this.desktop.addSVGEditorListener(this.statusBar);
        this.desktop.addSVGEditorListener(this.libraryPalette);
        this.desktop.addSVGEditorListener(this.layerPalette);
        this.desktop.addSVGEditorListener(this.treePalette);
        this.desktop.addSVGEditorListener(this.propPalette);
        this.desktop.addSVGEditorListener(this.memoryPalette);
        super.setTitle(resource.getString("Main.title"));
        super.setJMenuBar(this.menuBar);
        super.getContentPane().setLayout(new BorderLayout());
        super.getContentPane().add((Component)this.toolBar, "North");
        super.getContentPane().add((Component)this.drawBar, "West");
        super.getContentPane().add((Component)this.desktop, "Center");
        super.getContentPane().add((Component)this.statusBar, "South");
        super.setDefaultCloseOperation(0);
        super.addWindowListener(this);
        this.readPreferences();
    }

    public ResourceManager resource() {
        return resource;
    }

    public CommandManager commands() {
        return commands;
    }

    public String title() {
        return super.getTitle();
    }

    public SVGEditorDesktop desktop() {
        return this.desktop;
    }

    public MenuBar menuBar(String key) {
        return null;
    }

    public SVGPalette palette(String key) {
        if (this.libraryPalette.getClass().getName().equals(key)) {
            return this.libraryPalette;
        }
        if (this.layerPalette.getClass().getName().equals(key)) {
            return this.layerPalette;
        }
        if (this.treePalette.getClass().getName().equals(key)) {
            return this.treePalette;
        }
        if (this.propPalette.getClass().getName().equals(key)) {
            return this.propPalette;
        }
        if (this.memoryPalette.getClass().getName().equals(key)) {
            return this.memoryPalette;
        }
        return null;
    }

    private void doCloseAction() {
        commands.getCommand("imhotep.menu.file.Exit").actionPerformed(this);
    }

    private void readPreferences() {
        Preferences pref = Preferences.userNodeForPackage(this.getClass());
        int state = pref.getInt("Main.extends", 0);
        String bounds = pref.get("Main.bounds", "rect(0,0,800,600)");
        String layerBounds = pref.get("Layer.bounds", "rect(500,20,300,300)");
        String treeBounds = pref.get("Dom.bounds", "rect(520,40,300,300)");
        String propBounds = pref.get("Properties.bounds", "rect(540,60,300,300)");
        String libraryBounds = pref.get("Library.bounds", "rect(560,80,300,300)");
        String overviewBounds = pref.get("Overview.bounds", "rect(580,100,300,300)");
        String memoryBounds = pref.get("Memory.bounds", "rect(600,120,300,300)");
        boolean layerVisible = pref.getBoolean("Layer.visible", false);
        boolean treeVisible = pref.getBoolean("Dom.visible", false);
        boolean propVisible = pref.getBoolean("Properties.visible", false);
        boolean libraryVisible = pref.getBoolean("Library.visible", false);
        boolean overviewVisible = pref.getBoolean("Overview.visible", false);
        boolean memoryVisible = pref.getBoolean("Memory.visible", false);
        super.setBounds(RectangleFormat.parse(bounds));
        super.setExtendedState(state);
        ((Component)this.layerPalette).setBounds(RectangleFormat.parse(layerBounds));
        ((Component)this.treePalette).setBounds(RectangleFormat.parse(treeBounds));
        ((Component)this.propPalette).setBounds(RectangleFormat.parse(propBounds));
        ((Component)this.libraryPalette).setBounds(RectangleFormat.parse(libraryBounds));
        ((Component)this.memoryPalette).setBounds(RectangleFormat.parse(memoryBounds));
        if (layerVisible) {
            this.layerPalette.doCloseAction();
        }
        if (treeVisible) {
            this.treePalette.doCloseAction();
        }
        if (propVisible) {
            this.propPalette.doCloseAction();
        }
        if (libraryVisible) {
            this.libraryPalette.doCloseAction();
        }
        if (memoryVisible) {
            this.memoryPalette.doCloseAction();
        }
    }

    private void writePreferences() {
        Preferences pref = Preferences.userNodeForPackage(this.getClass());
        int state = super.getExtendedState();
        if (state == 1) {
            state = 0;
        }
        super.setExtendedState(0);
        pref.putInt("Main.extends", state);
        pref.put("Main.bounds", RectangleFormat.format(super.getBounds()));
        pref.put("Layer.bounds", RectangleFormat.format(this.layerPalette.getBounds()));
        pref.put("Dom.bounds", RectangleFormat.format(this.treePalette.getBounds()));
        pref.put("Properties.bounds", RectangleFormat.format(this.propPalette.getBounds()));
        pref.put("Library.bounds", RectangleFormat.format(this.libraryPalette.getBounds()));
        pref.put("Memory.bounds", RectangleFormat.format(this.memoryPalette.getBounds()));
        pref.putBoolean("Layer.visible", this.layerPalette.isVisible());
        pref.putBoolean("Dom.visible", this.treePalette.isVisible());
        pref.putBoolean("Properties.visible", this.propPalette.isVisible());
        pref.putBoolean("Library.visible", this.libraryPalette.isVisible());
        pref.putBoolean("Memory.visible", this.memoryPalette.isVisible());
    }

    public void windowOpened(WindowEvent e) {
    }

    public void windowClosing(WindowEvent e) {
        this.doCloseAction();
    }

    public void windowClosed(WindowEvent e) {
        this.writePreferences();
        System.exit(0);
    }

    public void windowActivated(WindowEvent e) {
    }

    public void windowDeactivated(WindowEvent e) {
    }

    public void windowDeiconified(WindowEvent e) {
    }

    public void windowIconified(WindowEvent e) {
    }

    public static void main(String[] args) throws InterruptedException, InvocationTargetException {
        try {
            if (args != null && "-US".equals(args[0])) {
                Locale.setDefault(Locale.US);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        RESOURCE_NAME = "imhotep.resources.Main";
        resource = ResourceManager.getBundle(RESOURCE_NAME);
        commands = CommandManager.getSystemBundle();
        IntroDialog intro = new IntroDialog();
        intro.show();
        Main.startGarbageCollector();
        Main.initializedApplication();
        SwingUtilities.invokeAndWait(new Runnable(){

            public void run() {
                Main.startApplication();
            }
        });
        intro.dispose();
        intro = null;
    }

    private static void initializedApplication() {
        try {
            UIManager.put("Application.useSystemFontSettings", Boolean.TRUE);
            Options.setGlobalFontSizeHints((FontSizeHints)FontSizeHints.MIXED);
            Options.setDefaultIconSize((Dimension)new Dimension(18, 18));
            PlasticLookAndFeel.setMyCurrentTheme((PlasticTheme)new DesertBluer(){

                protected Font getFont0() {
                    return new Font("\uad74\ub9bc", 0, 12);
                }
            });
            UIManager.setLookAndFeel((LookAndFeel)new PlasticXPLookAndFeel());
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private static void startApplication() {
        try {
            Main imhotep = new Main();
            ((Component)imhotep).setVisible(true);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private static void startGarbageCollector() {
        new Thread(){

            public void run() {
                while (true) {
                    try {
                        System.gc();
                        Thread.sleep(500L);
                    }
                    catch (Exception e) {
                        return;
                    }
                }
            }
        }.start();
    }

    public static class IntroDialog
    extends JWindow {
        public IntroDialog() {
            URL iconURL = ClassLoader.getSystemResource("imhotep/resources/mainSplash.jpg");
            ImageIcon icon = new ImageIcon(iconURL);
            JLabel label = new JLabel(icon);
            label.setBackground(Color.white);
            super.getContentPane().setLayout(new BorderLayout());
            super.getContentPane().add((Component)label, "Center");
            Dimension ss = super.getToolkit().getScreenSize();
            Dimension ds = super.getPreferredSize();
            super.setLocation((ss.width - ds.width) / 2, (ss.height - ds.height) / 2);
            super.setSize(ds);
        }
    }
}

