/*
 * Decompiled with CFR 0.152.
 */
package imhotep.editor.canvas;

import imhotep.editor.canvas.CanvasConer;
import imhotep.editor.canvas.CanvasRuler;
import imhotep.editor.canvas.DnDHandler;
import imhotep.editor.canvas.OverlayGrid;
import imhotep.editor.canvas.OverlayGuide;
import imhotep.editor.canvas.OverlaySelection;
import imhotep.editor.canvas.tool.AbstractTool;
import imhotep.editor.canvas.tool.BasicTool;
import imhotep.editor.canvas.tool.EllipseTool;
import imhotep.editor.canvas.tool.ImageTool;
import imhotep.editor.canvas.tool.LineTool;
import imhotep.editor.canvas.tool.PathTool;
import imhotep.editor.canvas.tool.PolygonTool;
import imhotep.editor.canvas.tool.PolylineTool;
import imhotep.editor.canvas.tool.RectTool;
import imhotep.editor.canvas.tool.RotateTool;
import imhotep.editor.canvas.tool.ScaleTool;
import imhotep.editor.canvas.tool.ShearTool;
import imhotep.editor.canvas.tool.TextTool;
import imhotep.editor.canvas.tool.TranslateTool;
import imhotep.model.SVGModel;
import java.awt.AlphaComposite;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.Shape;
import java.awt.event.MouseEvent;
import java.awt.geom.AffineTransform;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import java.util.HashMap;
import java.util.Map;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.Scrollable;
import javax.swing.border.LineBorder;
import javax.swing.event.MouseInputListener;
import org.apache.batik.gvt.GraphicsNode;
import org.apache.batik.gvt.renderer.DynamicRenderer;
import org.apache.batik.gvt.renderer.ImageRenderer;
import org.w3c.dom.svg.SVGElement;
import org.w3c.dom.svg.SVGSVGElement;

public class Canvas
extends JPanel
implements Scrollable {
    private JComponent extComponent;
    private JScrollPane scrollPane;
    private CanvasRuler ruler;
    private CanvasConer coner;
    private JPopupMenu popup;
    private boolean dispose;
    private AbstractTool tool;
    private DnDHandler handler;
    private OverlaySelection overlaySelection;
    private OverlayGuide overlayGuide;
    private OverlayGrid overlayGrid;
    public ImageRenderer renderer;
    protected BufferedImage image;
    protected Dimension canvasSize = new Dimension(10, 10);
    protected boolean antialiasing = true;
    protected SVGModel model;
    private MouseInputListener mouseInputListener;
    private Map toolMap;
    public static final int BASIC_TOOL_KEY = 0;
    public static final int TRANSLATE_TOOL_KEY = 17;
    public static final int ROTATE_TOOL_KEY = 18;
    public static final int SCALE_TOOL_KEY = 19;
    public static final int SHEAR_TOOL_KEY = 20;
    public static final int ELLIPSE_TOOL_KEY = 33;
    public static final int IMAGE_TOOL_KEY = 34;
    public static final int LINE_TOOL_KEY = 35;
    public static final int PATH_TOOL_KEY = 36;
    public static final int POLYGON_TOOL_KEY = 37;
    public static final int POLYLINE_TOOL_KEY = 38;
    public static final int RECT_TOOL_KEY = 39;
    public static final int TEXT_TOOL_KEY = 40;

    public Canvas() {
        super.setBorder(new LineBorder(Color.BLACK, 1, false));
        super.setFocusable(true);
        super.setSize(this.canvasSize);
        super.setPreferredSize(this.canvasSize);
        super.setBackground(Color.WHITE);
        this.handler = new DnDHandler();
        this.mouseInputListener = new MouseInputListenerImpl();
        this.overlaySelection = new OverlaySelection(this);
        this.overlayGuide = new OverlayGuide(this);
        this.overlayGrid = new OverlayGrid(this);
        this.ruler = new CanvasRuler();
        this.coner = new CanvasConer();
        try {
            super.setTransferHandler(this.handler);
            super.getDropTarget().addDropTargetListener(this.handler);
            super.getActionMap().put("cut", DnDHandler.getCutAction());
            super.getActionMap().put("copy", DnDHandler.getCopyAction());
            super.getActionMap().put("paste", DnDHandler.getPasteAction());
            super.getActionMap().put("delete-next", DnDHandler.getDeleteAction());
            super.getActionMap().put("undo", DnDHandler.getUndoAction());
            super.getActionMap().put("redo", DnDHandler.getRedoAction());
            super.getActionMap().put("select-all", DnDHandler.getSelectAllAction());
            super.addMouseListener(this.mouseInputListener);
            super.addMouseMotionListener(this.mouseInputListener);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        this.initTool();
        this.initExtComponent();
    }

    public void paintComponent(Graphics g) {
        super.paintComponent(g);
        Graphics2D g2 = (Graphics2D)g;
        if (this.image != null) {
            g2.setComposite(AlphaComposite.SrcOver);
            g2.drawRenderedImage(this.image, null);
        }
        this.overlaySelection.paint(g2);
        this.overlayGuide.paint(g2);
        this.overlayGrid.paint(g2);
        if (this.tool != null) {
            this.tool.paint(g2);
        }
    }

    public void setSVGModel(SVGModel m) {
        this.model = m;
    }

    public SVGModel getSVGModel() {
        return this.model;
    }

    public void active() {
        this.dispose();
        this.renderer = new DynamicRenderer();
        this.renderer.setTree(this.model.getRoot());
        this.renderer.setDoubleBuffered(true);
        int i = (int)Math.ceil(this.model.getSVGWidth());
        int j = (int)Math.ceil(this.model.getSVGHeight());
        this.canvasSize.setSize(i, j);
        this.renderer.updateOffScreen(i, j);
        this.refresh();
        this.revalidate();
        this.repaint();
        this.dispose = false;
    }

    public void dispose() {
        if (this.renderer != null) {
            this.renderer.dispose();
        }
        this.renderer = null;
        this.image = null;
        this.dispose = true;
    }

    public void overlay() {
        this.overlaySelection.update();
        this.overlayGuide.update();
        this.overlayGrid.update();
        this.repaint();
    }

    public void refresh() {
        Rectangle2D.Double shape = new Rectangle2D.Double(0.0, 0.0, this.model.getSVGWidth(), this.model.getSVGHeight());
        Cursor cursor = this.getCursor();
        this.setCursor(Cursor.getPredefinedCursor(3));
        RenderingHints renderinghints = ((DynamicRenderer)this.renderer).getRenderingHints();
        if (this.antialiasing) {
            renderinghints.put(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        } else {
            renderinghints.put(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_OFF);
        }
        try {
            try {
                this.renderer.repaint((Shape)shape);
                this.renderer.flush();
                this.image = this.renderer.getOffScreen();
                if (this.image != null) {
                    this.image = this.image.getSubimage(0, 0, (int)this.canvasSize.getWidth(), (int)this.canvasSize.getHeight());
                }
                this.overlay();
            }
            catch (Throwable e) {
                e.printStackTrace();
                this.overlay();
            }
        }
        catch (Throwable throwable) {
            Object var5_6 = null;
            this.setCursor(cursor);
            throw throwable;
        }
        Object var5_7 = null;
        this.setCursor(cursor);
    }

    public void zoom() {
        double d = this.model.getZoomValue();
        AffineTransform a = new AffineTransform();
        a.setToScale(d, d);
        this.renderer.setTransform(a);
        Rectangle2D.Double or = new Rectangle2D.Double(0.0, 0.0, this.model.getSVGWidth(), this.model.getSVGHeight());
        Rectangle2D zr = a.createTransformedShape(or).getBounds2D();
        int i = (int)Math.ceil(zr.getWidth());
        int j = (int)Math.ceil(zr.getHeight());
        this.canvasSize.setSize(i, j);
        if (this.image != null) {
            this.renderer.updateOffScreen(i, j);
        }
        this.refresh();
        this.revalidate();
    }

    protected void initExtComponent() {
        JPanel p = new JPanel(new GridBagLayout());
        p.add((Component)this, new GridBagConstraints());
        this.scrollPane = new JScrollPane();
        this.scrollPane.setViewportView(p);
        this.extComponent = new JPanel(new BorderLayout());
        this.extComponent.add((Component)this.scrollPane, "Center");
    }

    public JComponent getExtComponent() {
        return this.extComponent;
    }

    public void initPopup(JPopupMenu b) {
        this.popup = b;
    }

    public AffineTransform getRenderingTransform() {
        AffineTransform rt = this.renderer.getTransform();
        rt = rt == null ? new AffineTransform() : new AffineTransform(rt);
        return rt;
    }

    public AffineTransform getViewBoxTransform() {
        AffineTransform gt;
        GraphicsNode gn;
        AffineTransform t = this.getRenderingTransform();
        SVGSVGElement root = this.model.getRootElement();
        if (root != null && (gn = this.model.convertGraphicsNode((SVGElement)root)) != null && (gt = gn.getGlobalTransform()) != null) {
            t.concatenate(gt);
        }
        return t;
    }

    public void setAntialiasing(boolean flag) {
        this.antialiasing = flag;
    }

    public boolean isAntialiasing() {
        return this.antialiasing;
    }

    private void initTool() {
        this.toolMap = new HashMap();
        this.toolMap.put(Integer.toString(0), new BasicTool(this));
        this.toolMap.put(Integer.toString(17), new TranslateTool(this));
        this.toolMap.put(Integer.toString(18), new RotateTool(this));
        this.toolMap.put(Integer.toString(19), new ScaleTool(this));
        this.toolMap.put(Integer.toString(20), new ShearTool(this));
        this.toolMap.put(Integer.toString(33), new EllipseTool(this));
        this.toolMap.put(Integer.toString(34), new ImageTool(this));
        this.toolMap.put(Integer.toString(35), new LineTool(this));
        this.toolMap.put(Integer.toString(36), new PathTool(this));
        this.toolMap.put(Integer.toString(37), new PolygonTool(this));
        this.toolMap.put(Integer.toString(38), new PolylineTool(this));
        this.toolMap.put(Integer.toString(39), new RectTool(this));
        this.toolMap.put(Integer.toString(40), new TextTool(this));
    }

    public void setTool(int index) {
        AbstractTool t = (AbstractTool)this.toolMap.get(Integer.toString(index));
        this.setTool(t);
    }

    private void setTool(AbstractTool t) {
        if (t == null) {
            return;
        }
        if (this.tool != null) {
            this.tool.endTool();
        }
        this.tool = t;
        this.tool.startTool();
        this.overlay();
    }

    public void setBorderVisible(boolean b) {
        this.overlaySelection.setVisible(b);
    }

    public void setGuideVisible(boolean b) {
        this.overlayGuide.setVisible(b);
    }

    public void setGridVisible(boolean b) {
        this.overlayGrid.setVisible(b);
    }

    public boolean isBorderVisible() {
        return this.overlaySelection.isVisible();
    }

    public boolean isGuideVisible() {
        return this.overlayGuide.isVisible();
    }

    public boolean isGridVisible() {
        return this.overlayGrid.isVisible();
    }

    public boolean getScrollableTracksViewportHeight() {
        return false;
    }

    public boolean getScrollableTracksViewportWidth() {
        return false;
    }

    public Dimension getPreferredScrollableViewportSize() {
        return this.getSize();
    }

    public int getScrollableBlockIncrement(Rectangle visibleRect, int orientation, int direction) {
        int k = 30;
        if (direction == 1) {
            k = (int)Math.ceil(this.getHeight() / 20);
        } else if (direction == 0) {
            k = (int)Math.ceil(this.getWidth() / 20);
        }
        return k;
    }

    public int getScrollableUnitIncrement(Rectangle visibleRect, int orientation, int direction) {
        return this.getScrollableBlockIncrement(visibleRect, orientation, direction);
    }

    public int getHandleNumber(Point2D p) {
        return this.overlaySelection.getHandleNumber(p);
    }

    public Point2D getHandlePoint(int num) {
        return this.overlaySelection.getHandlePoint(num);
    }

    public Rectangle2D getHandleBounds(int i) {
        return this.overlaySelection.getHandleBounds(i);
    }

    protected class MouseInputListenerImpl
    implements MouseInputListener {
        protected MouseInputListenerImpl() {
        }

        private boolean isToolMouseEvent(MouseEvent e) {
            if (Canvas.this.tool == null) {
                return false;
            }
            int mods = e.getModifiers();
            return (mods & 4) == 0;
        }

        private void maybeShowPopup(MouseEvent e) {
            if (Canvas.this.popup == null) {
                return;
            }
            if (e.isPopupTrigger()) {
                Canvas.this.popup.show(e.getComponent(), e.getX(), e.getY());
            }
        }

        public void mouseClicked(MouseEvent e) {
            if (this.isToolMouseEvent(e)) {
                Canvas.this.tool.mouseClicked(e);
            }
        }

        public void mouseEntered(MouseEvent e) {
            if (this.isToolMouseEvent(e)) {
                Canvas.this.tool.mouseEntered(e);
            }
        }

        public void mouseExited(MouseEvent e) {
            if (this.isToolMouseEvent(e)) {
                Canvas.this.tool.mouseExited(e);
            }
        }

        public void mousePressed(MouseEvent e) {
            if (this.isToolMouseEvent(e)) {
                Canvas.this.tool.mousePressed(e);
            } else {
                this.maybeShowPopup(e);
            }
        }

        public void mouseReleased(MouseEvent e) {
            if (this.isToolMouseEvent(e)) {
                Canvas.this.tool.mouseReleased(e);
            } else {
                this.maybeShowPopup(e);
            }
        }

        public void mouseDragged(MouseEvent e) {
            if (this.isToolMouseEvent(e)) {
                Canvas.this.tool.mouseDragged(e);
            }
        }

        public void mouseMoved(MouseEvent e) {
            if (this.isToolMouseEvent(e)) {
                Canvas.this.tool.mouseMoved(e);
            }
        }
    }
}

