/*
 * Decompiled with CFR 0.152.
 */
package imhotep.editor.canvas.tool;

import imhotep.editor.canvas.Canvas;
import imhotep.editor.canvas.tool.AbstractTool;
import imhotep.model.SVGModel;
import imhotep.util.NodeSelection;
import imhotep.util.SVGGeomUtilities;
import imhotep.util.SVGRendererUtilities;
import java.awt.Cursor;
import java.awt.Graphics2D;
import java.awt.event.MouseEvent;
import java.awt.geom.AffineTransform;
import java.awt.geom.GeneralPath;
import java.awt.geom.Line2D;
import java.awt.geom.PathIterator;
import org.w3c.dom.Element;
import org.w3c.dom.svg.SVGDocument;

public class PolylineTool
extends AbstractTool {
    protected GeneralPath shape;
    private Line2D line;

    public PolylineTool(Canvas canvas) {
        super(canvas);
    }

    public void startTool() {
    }

    public void endTool() {
        if (this.shape != null) {
            MouseEvent e = new MouseEvent(this.svgCanvas, 500, 0L, 0, 0, 0, 2, false);
            this.mouseClicked(e);
        }
    }

    public void paint(Graphics2D g2) {
        if (this.shape != null) {
            g2.draw(this.shape);
        }
        if (this.line != null) {
            g2.draw(this.line);
        }
    }

    public void mousePressed(MouseEvent e) {
        this.pressPoint = e.getPoint();
        if (this.shape == null) {
            this.shape = new GeneralPath();
            this.line = new Line2D.Double();
        }
        if (this.shape.getCurrentPoint() == null) {
            this.shape.moveTo((float)this.pressPoint.getX(), (float)this.pressPoint.getY());
        } else {
            this.line.setLine(this.shape.getCurrentPoint(), this.pressPoint);
        }
        this.svgCanvas.repaint();
    }

    public void mouseDragged(MouseEvent e) {
        this.dragPoint = e.getPoint();
        if (this.shape != null) {
            double x1 = this.shape.getCurrentPoint().getX();
            double y1 = this.shape.getCurrentPoint().getY();
            double x2 = this.dragPoint.getX();
            double y2 = this.dragPoint.getY();
            double tx = x2 - x1;
            double ty = y2 - y1;
            if (e.isShiftDown()) {
                if (Math.abs(tx) > Math.abs(ty)) {
                    this.line.setLine(x1, y1, x2, y1);
                } else {
                    this.line.setLine(x1, y1, x1, y2);
                }
            } else {
                this.line.setLine(x1, y1, x2, y2);
            }
            this.svgCanvas.repaint();
        }
    }

    public void mouseReleased(MouseEvent e) {
        this.releasePoint = e.getPoint();
        if (this.shape != null) {
            this.shape.lineTo((float)this.line.getX2(), (float)this.line.getY2());
            this.line.setLine(0.0, 0.0, 0.0, 0.0);
        }
    }

    public void mouseClicked(MouseEvent e) {
        if (e.getClickCount() == 2 && this.shape != null && this.isValidateShape(this.shape)) {
            try {
                AffineTransform vt = this.svgCanvas.getViewBoxTransform().createInverse();
                PathIterator pi = this.shape.getPathIterator(vt);
                SVGModel model = this.svgCanvas.getSVGModel();
                SVGDocument doc = model.getSVGDocument();
                Element ele = doc.createElementNS("http://www.w3.org/2000/svg", "polyline");
                ele.setAttributeNS(null, "points", SVGGeomUtilities.toSVGPoints(pi));
                ele.setAttributeNS(null, "style", SVGRendererUtilities.LINE_DEFAULT_STYLE);
                model.addEntities(new NodeSelection(ele));
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
            this.shape = null;
            this.line = null;
            this.svgCanvas.repaint();
        }
    }

    public void mouseMoved(MouseEvent e) {
        this.svgCanvas.setCursor(Cursor.getPredefinedCursor(1));
    }
}

