/*
 * Decompiled with CFR 0.152.
 */
package imhotep.editor.canvas.tool;

import imhotep.editor.canvas.Canvas;
import imhotep.editor.canvas.tool.AbstractTool;
import imhotep.model.SVGModel;
import imhotep.util.NodeSelection;
import java.awt.BasicStroke;
import java.awt.Cursor;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Stroke;
import java.awt.event.MouseEvent;
import java.awt.geom.AffineTransform;
import java.awt.geom.Rectangle2D;

public class SelectionTool
extends AbstractTool {
    private Rectangle2D area;
    private int mode;
    private Stroke stroke = new BasicStroke(1.0f, 0, 0, 10.0f, new float[]{4.0f}, 0.0f);
    private static Cursor copyCursor = AbstractTool.createCurser("imhotep/menu/resources/win32_CopyDrop32x32.gif");

    public SelectionTool(Canvas canvas) {
        super(canvas);
    }

    public void startTool() {
    }

    public void endTool() {
    }

    public void paint(Graphics2D g2) {
        int i = 1;
        while (i <= 9) {
            g2.fill(this.svgCanvas.getHandleBounds(i));
            ++i;
        }
        if (this.area != null) {
            Stroke s = g2.getStroke();
            g2.setStroke(this.stroke);
            g2.draw(this.area);
            g2.setStroke(s);
        }
    }

    public void mousePressed(MouseEvent e) {
        this.pressPoint = e.getPoint();
        this.mode = this.svgCanvas.getHandleNumber(this.pressPoint);
        if (this.mode == -1) {
            SVGModel m = this.svgCanvas.getSVGModel();
            AffineTransform t = this.svgCanvas.getRenderingTransform();
            NodeSelection oldSelection = m.getSelectedNodes();
            NodeSelection newSelection = m.getNodesAt(t, this.pressPoint);
            if (newSelection.getLength() != 0) {
                if (!oldSelection.contains(newSelection.item(0))) {
                    if (e.isControlDown()) {
                        newSelection.addAll(0, oldSelection);
                    }
                    m.setSelectedNodes(newSelection);
                }
                this.mode = 0;
            } else {
                this.area = new Rectangle2D.Double();
            }
        }
    }

    public void mouseDragged(MouseEvent e) {
        this.dragPoint = e.getPoint();
        if (this.mode == -1) {
            this.area.setFrameFromDiagonal(this.pressPoint, this.dragPoint);
            this.svgCanvas.repaint();
        }
    }

    public void mouseReleased(MouseEvent e) {
        this.releasePoint = e.getPoint();
        if (this.mode == -1) {
            SVGModel m = this.svgCanvas.getSVGModel();
            NodeSelection n = m.getSelectedNodes();
            AffineTransform t = this.svgCanvas.getRenderingTransform();
            NodeSelection newSelection = m.getNodesAt(t, this.area);
            m.setSelectedNodes(newSelection);
            this.area = null;
            this.svgCanvas.repaint();
        }
    }

    public void mouseMoved(MouseEvent e) {
        Point movePoint = e.getPoint();
        int num = this.svgCanvas.getHandleNumber(movePoint);
        if (num == 0) {
            this.svgCanvas.setCursor(Cursor.getPredefinedCursor(13));
        } else if (num == 1) {
            this.svgCanvas.setCursor(Cursor.getPredefinedCursor(6));
        } else if (num == 2) {
            this.svgCanvas.setCursor(Cursor.getPredefinedCursor(8));
        } else if (num == 3) {
            this.svgCanvas.setCursor(Cursor.getPredefinedCursor(7));
        } else if (num == 4) {
            this.svgCanvas.setCursor(Cursor.getPredefinedCursor(10));
        } else if (num == 5) {
            this.svgCanvas.setCursor(Cursor.getPredefinedCursor(13));
        } else if (num == 6) {
            this.svgCanvas.setCursor(Cursor.getPredefinedCursor(11));
        } else if (num == 7) {
            this.svgCanvas.setCursor(Cursor.getPredefinedCursor(4));
        } else if (num == 8) {
            this.svgCanvas.setCursor(Cursor.getPredefinedCursor(9));
        } else if (num == 9) {
            this.svgCanvas.setCursor(Cursor.getPredefinedCursor(5));
        } else {
            NodeSelection ns = this.svgCanvas.getSVGModel().getNodesAt(this.svgCanvas.getRenderingTransform(), movePoint);
            if (ns.getLength() > 0) {
                this.svgCanvas.setCursor(Cursor.getPredefinedCursor(13));
            } else {
                this.svgCanvas.setCursor(Cursor.getPredefinedCursor(0));
            }
        }
    }
}

