/*
 * Decompiled with CFR 0.152.
 */
package imhotep.editor.canvas.tool;

import imhotep.editor.canvas.Canvas;
import imhotep.editor.canvas.tool.AbstractTool;
import imhotep.model.SVGModel;
import imhotep.util.NodeSelection;
import imhotep.util.SVGGeomUtilities;
import imhotep.util.SVGRendererUtilities;
import java.awt.Cursor;
import java.awt.Graphics2D;
import java.awt.event.MouseEvent;
import java.awt.geom.AffineTransform;
import java.awt.geom.Line2D;
import java.awt.geom.PathIterator;
import java.awt.geom.Point2D;
import javax.swing.JOptionPane;
import org.w3c.dom.Element;
import org.w3c.dom.svg.SVGDocument;

public class TextTool
extends AbstractTool {
    private Line2D shape;

    public TextTool(Canvas canvas) {
        super(canvas);
    }

    public void startTool() {
    }

    public void endTool() {
    }

    public void paint(Graphics2D g2) {
        if (this.shape != null) {
            g2.draw(this.shape);
        }
    }

    public void mouseClicked(MouseEvent e) {
        this.pressPoint = e.getPoint();
        this.shape = new Line2D.Double(this.pressPoint.getX(), this.pressPoint.getY(), this.pressPoint.getX(), this.pressPoint.getY() - 10.0);
        this.svgCanvas.repaint();
        try {
            String textString = JOptionPane.showInputDialog("Text");
            if (textString != null) {
                AffineTransform vt = this.svgCanvas.getViewBoxTransform().createInverse();
                PathIterator pi = this.shape.getPathIterator(vt);
                Point2D point = SVGGeomUtilities.convertPoint2D(pi);
                SVGModel model = this.svgCanvas.getSVGModel();
                SVGDocument doc = model.getSVGDocument();
                Element ele = doc.createElementNS("http://www.w3.org/2000/svg", "text");
                ele.setAttributeNS(null, "x", SVGGeomUtilities.doubleString(point.getX()));
                ele.setAttributeNS(null, "y", SVGGeomUtilities.doubleString(point.getY()));
                ele.setAttributeNS("http://www.w3.org/XML/1998/namespace", "xml:space", "preserve");
                ele.setAttributeNS(null, "style", SVGRendererUtilities.TEXT_DEFAULT_STYLE);
                ele.removeAttributeNS("xml", "space");
                ele.appendChild(doc.createTextNode(textString));
                model.addEntities(new NodeSelection(ele));
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        this.shape = null;
        this.svgCanvas.repaint();
    }

    public void mouseMoved(MouseEvent e) {
        this.svgCanvas.setCursor(Cursor.getPredefinedCursor(1));
    }
}

