/*
 * Decompiled with CFR 0.152.
 */
package imhotep.editor.canvas.tool;

import imhotep.editor.canvas.Canvas;
import imhotep.editor.canvas.tool.AbstractTool;
import imhotep.model.SVGModel;
import imhotep.util.NodeSelection;
import java.awt.Cursor;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Shape;
import java.awt.event.MouseEvent;
import java.awt.geom.AffineTransform;

public class TranslateTool
extends AbstractTool {
    protected Shape outline;
    protected Shape shape;
    protected int mode;

    public TranslateTool(Canvas canvas) {
        super(canvas);
    }

    public void startTool() {
    }

    public void endTool() {
    }

    public void paint(Graphics2D g2) {
        if (this.shape != null) {
            g2.draw(this.shape);
        }
    }

    public void mousePressed(MouseEvent e) {
        this.pressPoint = e.getPoint();
        this.mode = this.svgCanvas.getHandleNumber(this.pressPoint);
        if (this.mode == 0) {
            SVGModel m = this.svgCanvas.getSVGModel();
            AffineTransform t = this.svgCanvas.getRenderingTransform();
            this.outline = m.getSelectedOutline(t);
        }
    }

    public void mouseDragged(MouseEvent e) {
        this.dragPoint = e.getPoint();
        if (this.mode == 0) {
            double[] d = new double[]{this.pressPoint.getX(), this.pressPoint.getY(), this.dragPoint.getX(), this.dragPoint.getY()};
            double tx = d[2] - d[0];
            double ty = d[3] - d[1];
            AffineTransform at = new AffineTransform();
            at.translate(tx, ty);
            this.shape = at.createTransformedShape(this.outline);
            this.svgCanvas.repaint();
        }
    }

    public void mouseReleased(MouseEvent e) {
        this.releasePoint = e.getPoint();
        if (this.mode == 0) {
            try {
                double[] d = new double[]{this.pressPoint.getX(), this.pressPoint.getY(), this.releasePoint.getX(), this.releasePoint.getY()};
                AffineTransform vt = this.svgCanvas.getViewBoxTransform().createInverse();
                vt.transform(d, 0, d, 0, 2);
                double tx = d[2] - d[0];
                double ty = d[3] - d[1];
                AffineTransform at = new AffineTransform();
                at.translate(tx, ty);
                SVGModel m = this.svgCanvas.getSVGModel();
                NodeSelection ns = m.getSelectedNodes();
                m.transformEntities(ns, at);
            }
            catch (Exception e1) {
                e1.printStackTrace();
            }
        }
        this.outline = null;
        this.shape = null;
        this.svgCanvas.repaint();
    }

    public void mouseMoved(MouseEvent e) {
        Point movePoint = e.getPoint();
        int num = this.svgCanvas.getHandleNumber(movePoint);
        if (num == 0) {
            this.svgCanvas.setCursor(Cursor.getPredefinedCursor(13));
        } else {
            this.svgCanvas.setCursor(Cursor.getPredefinedCursor(0));
        }
    }
}

