/*
 * Decompiled with CFR 0.152.
 */
package imhotep.editor.preview;

import imhotep.editor.preview.PreviewAgent;
import imhotep.model.SVGModel;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import org.apache.batik.swing.JSVGCanvas;
import org.apache.batik.swing.svg.JSVGComponent;
import org.w3c.dom.svg.SVGDocument;

public class Preview
extends JSVGCanvas {
    private JComponent extComponent;
    public JPopupMenu popup;
    private SVGModel model;
    private boolean dispose;
    private MouseListener mouseListener = new MouseListenerImpl();

    public Preview() {
        super.setDocumentState(1);
        ((JSVGComponent)this).svgUserAgent = new PreviewAgent(this);
        this.initExtComponent();
    }

    public void setSVGDocument(SVGDocument d) {
        if (!this.dispose && d == null) {
            return;
        }
        super.setSVGDocument(d);
    }

    public void setSVGModel(SVGModel m) {
        this.model = m;
    }

    public SVGModel getSVGModel() {
        return this.model;
    }

    public void active() {
        SVGDocument doc = (SVGDocument)this.model.getSVGDocument().cloneNode(true);
        this.setSVGDocument(doc);
        super.setPreferredSize((Dimension)this.model.getSVGSize());
        super.revalidate();
        this.dispose = false;
    }

    public void refresh() {
        if (super.getUpdateManager() != null) {
            super.getUpdateManager().getUpdateRunnableQueue().invokeLater(new Runnable(){

                public void run() {
                }
            });
        }
    }

    public void dispose() {
        this.dispose = true;
        super.setURI(null);
    }

    protected void initExtComponent() {
        this.extComponent = new JPanel(new BorderLayout());
        this.extComponent.add((Component)new JScrollPane((Component)((Object)this)), "Center");
    }

    public JComponent getExtComponent() {
        return this.extComponent;
    }

    public void initPopup(JPopupMenu b) {
        this.popup = b;
        super.addMouseListener(this.mouseListener);
    }

    protected class MouseListenerImpl
    extends MouseAdapter {
        protected MouseListenerImpl() {
        }

        private void maybeShowPopup(MouseEvent e) {
            if (Preview.this.popup == null) {
                return;
            }
            if (e.isPopupTrigger()) {
                Preview.this.popup.show(e.getComponent(), e.getX(), e.getY());
            }
        }

        public void mousePressed(MouseEvent e) {
            this.maybeShowPopup(e);
        }

        public void mouseReleased(MouseEvent e) {
            this.maybeShowPopup(e);
        }
    }
}

